/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentParentChildGroupTable;

class ParentChildGroupTable
extends PersistentParentChildGroupTable {
    public static final ParentChildGroupTable DEFAULT = new ParentChildGroupTable(null);

    public ParentChildGroupTable(String alias) {
        super(alias);
    }

    public void checkReadPermission() {
        GroupTable.DEFAULT.checkReadPermission();
    }

    public void checkWritePermission() {
        GroupTable.DEFAULT.checkWritePermission();
    }

    public void checkDeletePermission() {
        GroupTable.DEFAULT.checkWritePermission();
    }

    public Select selectParentsByChild(GroupID childGroupID) {
        return this.select(ParentChildGroupTable.sList(this.Parent), ParentChildGroupTable.where(ParentChildGroupTable.equals(this.Child, childGroupID)));
    }

    public Select selectChildrenByParent(GroupID parentGroupID) {
        return this.select(ParentChildGroupTable.sList(this.Child), ParentChildGroupTable.where(ParentChildGroupTable.equals(this.Parent, parentGroupID)));
    }

    public int deleteByParentOrChild(GroupID groupID) throws PersistenceManagerException {
        return ParentChildGroupTable.execute(this.delete(ParentChildGroupTable.where(ParentChildGroupTable.or(ParentChildGroupTable.equals(this.Parent, groupID), ParentChildGroupTable.equals(this.Child, groupID)))));
    }

    public int deleteByParent(GroupID parentGroupID) throws PersistenceManagerException {
        return ParentChildGroupTable.execute(this.delete(ParentChildGroupTable.where(ParentChildGroupTable.equals(this.Parent, parentGroupID))));
    }

    public int deleteByChild(GroupID childGroupID) throws PersistenceManagerException {
        return ParentChildGroupTable.execute(this.delete(ParentChildGroupTable.where(ParentChildGroupTable.equals(this.Child, childGroupID))));
    }

    public ColumnList allColumnsButID() {
        return ParentChildGroupTable.cList(this.Parent, (ColumnNode)this.Child);
    }

    public int insert(GroupID parentGroup, GroupID[] childGroups) throws PersistenceManagerException {
        Select values = null;
        for (int i = 0; i < childGroups.length; ++i) {
            values = ParentChildGroupTable.anonSelect(this.sList(parentGroup, childGroups[i]), values);
        }
        return ParentChildGroupTable.execute(this.insert(this.allColumnsButID(), values));
    }

    private SelectList sList(GroupID parent, GroupID child) {
        return ParentChildGroupTable.sList(ParentChildGroupTable.v(parent), (ScalarExp)ParentChildGroupTable.v(child));
    }

    public int insert(GroupID[] parentGroups, GroupID childGroup) throws PersistenceManagerException {
        Select values = null;
        for (int i = 0; i < parentGroups.length; ++i) {
            values = ParentChildGroupTable.anonSelect(this.sList(parentGroups[i], childGroup), values);
        }
        return ParentChildGroupTable.execute(this.insert(this.allColumnsButID(), values));
    }

    public int insert(GroupID parent, GroupID child) throws PersistenceManagerException {
        return ParentChildGroupTable.execute(this.insert(this.allColumnsButID(), ParentChildGroupTable.vList(ParentChildGroupTable.v(parent), ParentChildGroupTable.v(child))));
    }
}

