/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.BeanProcessor;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserData;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserDataTable;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUser;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.UserOrder;
import com.raplix.rolloutexpress.systemmodel.userdb.UserTable;
import com.raplix.util.regex.GlobPattern;
import java.util.Vector;

public class MultiUserQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    private Visibility mVisibilityFilter;
    private Boolean mActiveFilter;
    private GlobPattern mNameFilter;
    private boolean mExcludeSentinelUser = true;

    public static MultiUserQuery all() {
        MultiUserQuery theQuery = new MultiUserQuery();
        theQuery.setObjectOrder(UserOrder.BY_NAME_ASC);
        theQuery.setVisibilityFilter(Visibility.VISIBLE);
        return theQuery;
    }

    static MultiUserQuery byIDs(UserIDSet idSet) {
        return new MultiUserQuery(idSet);
    }

    public Visibility getVisibilityFilter() {
        return this.mVisibilityFilter;
    }

    public void setVisibilityFilter(Visibility visibilityFilter) {
        this.mVisibilityFilter = visibilityFilter;
    }

    public Boolean getActiveFilter() {
        return this.mActiveFilter;
    }

    public void setActiveFilter(Boolean activeFilter) {
        this.mActiveFilter = activeFilter;
    }

    public GlobPattern getNameFilter() {
        return this.mNameFilter;
    }

    public void setNameFilter(GlobPattern nameFilter) {
        this.mNameFilter = nameFilter;
    }

    private boolean getExcludeSentinelUser() {
        return this.mExcludeSentinelUser;
    }

    private void setExcludeSentinelUser(boolean exclude) {
        this.mExcludeSentinelUser = exclude;
    }

    MultiUserQuery() {
        super((Table)UserTable.DEFAULT, (ConditionalExpression)null, UserOrder.FACTORY);
    }

    MultiUserQuery(UserIDSet idSet) {
        super((Table)UserTable.DEFAULT, idSet.toIDArray(), UserOrder.FACTORY);
        this.setExcludeSentinelUser(idSet.contains(UserID.USER_SENTINEL_ID));
    }

    public void setObjectOrder(ObjectOrder inUserOrder) {
        super.setObjectOrder((UserOrder)inUserOrder);
    }

    protected void addFilterCondition(QueryContext ctx) {
        UserTable t = (UserTable)this.getTable();
        if (this.getVisibilityFilter() != null) {
            ctx.addAndWhereCondition(UserTable.equals(t.cVisibility(), this.getVisibilityFilter()));
        }
        if (this.getActiveFilter() != null) {
            ctx.addAndWhereCondition(UserTable.equals(t.cActive(), this.getActiveFilter()));
        }
        if (this.getNameFilter() != null) {
            ctx.addAndWhereCondition(UserTable.likeLower(t.Username, this.getNameFilter()));
        }
        if (this.getExcludeSentinelUser()) {
            ctx.addAndWhereCondition(UserTable.not(UserTable.equals(t.ID, UserID.USER_SENTINEL_ID)));
        }
    }

    public User[] select() throws RPCException, PersistenceManagerException {
        return (User[])this.select(new UserBeanProcessor((PersistentUserDataTable)this.getTable(), false), RemoteUser.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return (HasObjectID[])this.select();
    }

    private static class UserBeanProcessor
    extends BeanProcessor {
        UserBeanProcessor(PersistentUserDataTable table, boolean isSingleResult) {
            super(table, isSingleResult);
        }

        protected Object mapObject(Object obj) {
            PersistentUserData thePUD = (PersistentUserData)obj;
            return new RemoteUser(thePUD.getUserID(), thePUD.toUserData());
        }

        public Vector getResults() throws PersistenceManagerException {
            this.mapResults();
            return super.getResults();
        }
    }
}

