/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrderFactory;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptorOrder;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptorProcessor;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptorSQLOps;
import com.raplix.rolloutexpress.systemmodel.userdb.SummarySessionVarDescriptor;
import com.raplix.util.regex.GlobPattern;

public class MultiSessionVarDescriptorQuery
extends MultiObjectQueryImpl {
    private GlobPattern mNameFilter;
    private GlobPattern mDescriptionFilter;

    public static MultiSessionVarDescriptorQuery all() {
        MultiSessionVarDescriptorQuery query = new MultiSessionVarDescriptorQuery(SessionVarDescriptorSQLOps.DEFAULT, null, SessionVarDescriptorOrder.FACTORY);
        query.setObjectOrder(SessionVarDescriptorOrder.BY_NAME_ASC);
        return query;
    }

    private MultiSessionVarDescriptorQuery(SessionVarDescriptorSQLOps table, ConditionalExpression condition, ObjectOrderFactory orderFactory) {
        super((Table)table, condition, orderFactory);
    }

    public GlobPattern getNameFilter() {
        return this.mNameFilter;
    }

    public void setNameFilter(GlobPattern nameFilter) {
        this.mNameFilter = nameFilter;
    }

    public GlobPattern getDescriptionFilter() {
        return this.mDescriptionFilter;
    }

    public void setDescriptionFilter(GlobPattern descriptionFilter) {
        this.mDescriptionFilter = descriptionFilter;
    }

    public SessionVarDescriptor[] select() throws RPCException, PersistenceManagerException {
        SessionVarDescriptorProcessor processor = new SessionVarDescriptorProcessor(this.getTable(), false, false);
        return (SessionVarDescriptor[])this.select(processor, SessionVarDescriptor.class);
    }

    public SummarySessionVarDescriptor[] selectSummaryView() throws RPCException, PersistenceManagerException {
        SessionVarDescriptorProcessor processor = new SessionVarDescriptorProcessor(this.getTable(), false, true);
        return (SummarySessionVarDescriptor[])this.select(processor, SummarySessionVarDescriptor.class);
    }

    protected void addFilterCondition(QueryContext ctx) {
        GlobPattern nameFilter = this.getNameFilter();
        GlobPattern descFilter = this.getDescriptionFilter();
        SessionVarDescriptorSQLOps table = (SessionVarDescriptorSQLOps)ctx.getTableOfType(SessionVarDescriptorSQLOps.class);
        if (nameFilter != null) {
            ctx.addAndWhereCondition(table.matchName(nameFilter));
        }
        if (descFilter != null) {
            ctx.addAndWhereCondition(table.matchDescription(descFilter));
        }
        ctx.addAndWhereCondition(SessionVarDescriptorSQLOps.not(table.isName("sys:detectpasschange")));
    }
}

