/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.BeanProcessor;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupOrder;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupData;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroup;
import com.raplix.util.regex.GlobPattern;
import java.util.Vector;

public class MultiGroupQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    private GlobPattern mNameFilter;
    private GlobPattern mDescriptionFilter;

    public static MultiGroupQuery all() {
        MultiGroupQuery theQuery = new MultiGroupQuery();
        theQuery.setObjectOrder(GroupOrder.BY_NAME_ASC);
        return theQuery;
    }

    static MultiGroupQuery byIDs(GroupID[] IDs) {
        return new MultiGroupQuery(IDs);
    }

    public GlobPattern getNameFilter() {
        return this.mNameFilter;
    }

    public void setNameFilter(GlobPattern nameFilter) {
        this.mNameFilter = nameFilter;
    }

    public GlobPattern getDescriptionFilter() {
        return this.mDescriptionFilter;
    }

    public void setDescriptionFilter(GlobPattern descriptionFilter) {
        this.mDescriptionFilter = descriptionFilter;
    }

    MultiGroupQuery() {
        super((Table)GroupTable.DEFAULT, (ConditionalExpression)null, GroupOrder.FACTORY);
    }

    MultiGroupQuery(GroupID[] IDs) {
        super((Table)GroupTable.DEFAULT, IDs, GroupOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder inGroupOrder) {
        super.setObjectOrder((GroupOrder)inGroupOrder);
    }

    protected void addFilterCondition(QueryContext ctx) {
        GroupTable t = (GroupTable)this.getTable();
        if (this.getNameFilter() != null) {
            ctx.addAndWhereCondition(GroupTable.likeLower(t.Name, this.getNameFilter()));
        }
        if (this.getDescriptionFilter() != null) {
            ctx.addAndWhereCondition(GroupTable.likeLower(t.Description, this.getDescriptionFilter()));
        }
    }

    public Group[] select() throws RPCException, PersistenceManagerException {
        return (Group[])this.select(new GroupProcessor(this.getTable()), RemoteGroup.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return (HasObjectID[])this.select();
    }

    private static class GroupProcessor
    extends BeanProcessor {
        public GroupProcessor(Table table) {
            super(table, false);
        }

        protected Object mapObject(Object obj) {
            PersistentGroupData thePGD = (PersistentGroupData)obj;
            return new RemoteGroup(thePGD.getGroupID(), thePGD.toGroupData());
        }

        public Vector getResults() throws PersistenceManagerException {
            this.mapResults();
            return super.getResults();
        }
    }
}

