/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetUpdateListener;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateNotAcceptedException;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.util.logger.Logger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class HostPermissionManager
implements HostSetUpdateListener {
    private static final String MSG_CANNOT_ADD_HOST_PERM = "userdb.hpm.CANNOT_ADD_HOST_PERM";
    private static final String MSG_CANNOT_REMOVE_HOST_PERM = "userdb.hpm.CANNOT_REMOVE_HOST_PERM";
    private PermissionManager mPermissionManager;
    private String mClassName;

    HostPermissionManager(PermissionManager pm, Class permissionClass) {
        this.setPermissionManager(pm);
        this.setClassName(permissionClass.getName());
    }

    private PermissionManager getPermissionManager() {
        return this.mPermissionManager;
    }

    private void setPermissionManager(PermissionManager permissionManager) {
        this.mPermissionManager = permissionManager;
    }

    private String getClassName() {
        return this.mClassName;
    }

    private void setClassName(String className) {
        this.mClassName = className;
    }

    public void hostSetAdded(final HostSetID hostSetID) throws UpdateNotAcceptedException {
        this.execPriv(new PrivilegedExceptionAction(){

            public Object run() throws UserDBException, RPCException {
                HostPermissionManager.this.addHostSetPerm(hostSetID);
                return null;
            }
        }, MSG_CANNOT_ADD_HOST_PERM, hostSetID);
    }

    private void addHostSetPerm(HostSetID hostSetID) throws UserDBException, RPCException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("creating permission " + this.getClassName() + " for host set " + hostSetID, this);
        }
        Permission perm = this.getPermissionManager().newPermission();
        perm.setClassName(this.getClassName());
        perm.setName(this.getName(hostSetID));
        perm.save();
    }

    private void execPriv(PrivilegedExceptionAction action, String errorCode, HostSetID hostSetID) throws UpdateNotAcceptedException {
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            throw this.newException(errorCode, hostSetID, pae.getException());
        }
    }

    private String getName(HostSetID hostSetID) {
        return "hostset:" + hostSetID.toString();
    }

    public void hostSetDeleted(final HostSetID hostSetID) throws UpdateNotAcceptedException {
        this.execPriv(new PrivilegedExceptionAction(){

            public Object run() throws UserDBException, RPCException {
                HostPermissionManager.this.deleteHostSetPerm(hostSetID);
                return null;
            }
        }, MSG_CANNOT_REMOVE_HOST_PERM, hostSetID);
    }

    public void deleteHostSetPerm(HostSetID hostSetID) throws UserDBException, RPCException {
        PermissionManager permMan = this.getPermissionManager();
        Permission[] perms = permMan.getPermissionsByCriteria(this.getName(hostSetID), this.getClassName(), null);
        if (perms.length == 0 && Logger.isWarnEnabled(this)) {
            Logger.warn("no permission found for deleted hostset: " + hostSetID, this);
        }
        for (int i = 0; i < perms.length; ++i) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("deleting permission " + this.getClassName() + " for host set " + hostSetID, this);
            }
            permMan.deletePermission(perms[i].getPermissionID());
        }
    }

    private UpdateNotAcceptedException newException(String messageKey, HostSetID hostSetID, Exception e) {
        Object[] args = new Object[]{this.getClassName(), hostSetID};
        return new UpdateNotAcceptedException(new ROXMessage(messageKey, args), (Throwable)e);
    }
}

