/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.OrExp;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GrantedPermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupGraphTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupMemberTable;
import com.raplix.rolloutexpress.systemmodel.userdb.ParentChildGroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupData;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupDataTable;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroup;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;

class GroupTable
extends PersistentGroupDataTable {
    public static final GroupTable DEFAULT = new GroupTable(null);

    public GroupTable(String alias) {
        super(alias);
    }

    public RemoteGroup[] execute(Select query) throws UserDBException {
        if (query == null) {
            return null;
        }
        try {
            PersistentBean[] groups = GroupTable.executeMultiResult(query, this);
            RemoteGroup[] result = new RemoteGroup[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                PersistentGroupData group = (PersistentGroupData)groups[i];
                result[i] = new RemoteGroup(group.getGroupID(), group.toGroupData());
            }
            return result;
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    public RemoteGroup[] executeSelectAll() throws UserDBException {
        return this.execute(this.select((SelectList)this.allColumns(), null, GroupTable.dictOrderAsc(this.Name)));
    }

    public RemoteGroup[] executeSelectByCriteria(String namePattern, String descPattern, String typePattern) throws UserDBException {
        return this.execute(this.selectByCriteria(namePattern, descPattern, typePattern));
    }

    public Select selectByCriteria(String namePattern, String descPattern, String typePattern) {
        if (namePattern == null && descPattern == null && typePattern == null) {
            return null;
        }
        AndExp where = GroupTable.and();
        if (namePattern != null) {
            where.add(GroupTable.like(this.Name, namePattern));
        }
        if (descPattern != null) {
            where.add(GroupTable.like(this.Description, descPattern));
        }
        if (typePattern != null) {
            where.add(GroupTable.like(this.Type, typePattern));
        }
        return this.select(GroupTable.where(where));
    }

    public RemoteGroup[] executeSelectByName(String groupName) throws UserDBException {
        return this.execute(this.selectByName(groupName));
    }

    public Select selectByName(String groupName) {
        return this.select(GroupTable.where(GroupTable.equals(this.Name, groupName)));
    }

    public RemoteGroup[] executeSelectByPermission(PermissionID permID) throws UserDBException {
        return this.execute(this.selectByPermission(permID));
    }

    public Select selectByPermission(PermissionID permID) {
        GrantedPermissionTable gpt = GrantedPermissionTable.DEFAULT;
        return this.select(GroupTable.where(GroupTable.in((ColumnNode)this.ID, gpt.selectGroupsByPermission(permID))));
    }

    public RemoteGroup[] executeSelectByUser(UserID userID) throws UserDBException {
        return this.execute(this.selectByUser(userID));
    }

    public Select selectByUser(UserID userID) {
        GroupMemberTable gmt = GroupMemberTable.DEFAULT;
        return this.select((SelectList)this.allColumns(), GroupTable.where(GroupTable.in((ColumnNode)this.ID, gmt.selectGroupsByUser(userID))), this.orderByNameAsc());
    }

    private Select selectByIDIn(Select idQuery) {
        return this.select(GroupTable.where(GroupTable.in((ColumnNode)this.ID, idQuery)));
    }

    public Select selectByMember(UserID userID) {
        GroupGraphTable ggt = GroupGraphTable.DEFAULT;
        return this.selectByIDIn(ggt.selectGroupsByMember(userID));
    }

    public RemoteGroup[] executeSelectByMember(UserID userID) throws UserDBException {
        return this.execute(this.selectByMember(userID));
    }

    public Select selectByChild(GroupID childGroupID) {
        ParentChildGroupTable pcgt = ParentChildGroupTable.DEFAULT;
        return this.selectByIDIn(pcgt.selectParentsByChild(childGroupID));
    }

    public RemoteGroup[] executeSelectByChild(GroupID childGroupID) throws UserDBException {
        return this.execute(this.selectByChild(childGroupID));
    }

    public Select selectByParent(GroupID parentGroupID) {
        ParentChildGroupTable pcgt = ParentChildGroupTable.DEFAULT;
        return this.selectByIDIn(pcgt.selectChildrenByParent(parentGroupID));
    }

    public RemoteGroup[] executeSelectByParent(GroupID parentGroupID) throws UserDBException {
        return this.execute(this.selectByParent(parentGroupID));
    }

    public Select selectDescendants(GroupID groupID) {
        GroupGraphTable ggt = GroupGraphTable.DEFAULT;
        return this.selectByIDIn(ggt.selectDescendantsOf(groupID));
    }

    public RemoteGroup[] executeSelectDescendants(GroupID groupID) throws UserDBException {
        return this.execute(this.selectDescendants(groupID));
    }

    public Select selectAncestors(GroupID groupID) {
        GroupGraphTable ggt = GroupGraphTable.DEFAULT;
        return this.selectByIDIn(ggt.selectAncestorsOf(groupID));
    }

    public RemoteGroup[] executeSelectAncestors(GroupID groupID) throws UserDBException {
        return this.execute(this.selectAncestors(groupID));
    }

    public int updateGroupsByPermission(PermissionID permID) throws PersistenceManagerException {
        GrantedPermissionTable gpt = GrantedPermissionTable.DEFAULT;
        return this.updateGroupsByID(gpt.selectGroupsByPermission(permID));
    }

    public int updateGroupsByUser(UserID userID) throws PersistenceManagerException {
        GroupMemberTable gmt = GroupMemberTable.DEFAULT;
        return this.updateGroupsByID(gmt.selectGroupsByUser(userID));
    }

    public int updateGroupsByParentOrChild(GroupID groupID) throws PersistenceManagerException {
        ParentChildGroupTable pcgt = ParentChildGroupTable.DEFAULT;
        Select parents = pcgt.selectParentsByChild(groupID);
        Select children = pcgt.selectChildrenByParent(groupID);
        return GroupTable.execute(this.update(GroupTable.uList(GroupTable.increment(this.UpdateCount)), GroupTable.where(GroupTable.or(GroupTable.in((ColumnNode)this.ID, parents), GroupTable.in((ColumnNode)this.ID, children)))));
    }

    public int updateGroupsByParent(GroupID parentGroupID) throws PersistenceManagerException {
        ParentChildGroupTable pcgt = ParentChildGroupTable.DEFAULT;
        return this.updateGroupsByID(pcgt.selectChildrenByParent(parentGroupID));
    }

    public int updateGroupsByChild(GroupID childGroupID) throws PersistenceManagerException {
        ParentChildGroupTable pcgt = ParentChildGroupTable.DEFAULT;
        return this.updateGroupsByID(pcgt.selectParentsByChild(childGroupID));
    }

    private int updateGroupsByID(Select groupIDs) throws PersistenceManagerException {
        return GroupTable.execute(this.update(GroupTable.uList(GroupTable.increment(this.UpdateCount)), GroupTable.where(GroupTable.in((ColumnNode)this.ID, groupIDs))));
    }

    public int updateGroupsByID(GroupID[] groupIDs) throws PersistenceManagerException {
        return GroupTable.execute(this.update(GroupTable.uList(GroupTable.increment(this.UpdateCount)), GroupTable.where(GroupTable.in((ColumnNode)this.ID, GroupTable.rList(groupIDs)))));
    }

    public ScalarExp isSysGroup() {
        OrExp theExp = GroupTable.or();
        theExp.add(GroupTable.equals(this.ID, RemoteGroupManager.ADMIN_GROUPID));
        theExp.add(GroupTable.equals(this.ID, RemoteGroupManager.REGISTERED_GROUPID));
        theExp.add(GroupTable.equals(this.ID, RemoteGroupManager.UNIVERSAL_GROUPID));
        return theExp;
    }

    public OrderByList orderByNameAsc() {
        return GroupTable.oList(GroupTable.orderByDesc(this.isSysGroup())).add(GroupTable.dictOrderAsc(this.Name));
    }

    public OrderByList orderByNameDesc() {
        return GroupTable.oList(GroupTable.orderByDesc(this.isSysGroup())).add(GroupTable.dictOrderDesc(this.Name));
    }
}

