/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionNameElements;
import com.raplix.rolloutexpress.systemmodel.userdb.GrantedPermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupData;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupEvent;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupGraphTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupListener;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManagerService;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupMemberTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupService;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.InvalidChangeException;
import com.raplix.rolloutexpress.systemmodel.userdb.ParentChildGroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupData;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroup;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermission;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUser;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserTable;
import com.raplix.util.Validate;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

class GroupServicesImpl
implements GroupManagerService,
GroupService {
    private static final String MSG_INVALID_NAME = "userdb.gsi.INVALID_NAME";
    private static final String MSG_INVALID_DESCRIPTION = "userdb.gsi.INVALID_DESCRIPTION";
    private static final String MSG_ADMIN_USER_REMOVE = "userdb.gsi.ADMIN_USER_REMOVE";
    private static final String MSG_DEFAULT_PERM_REMOVE = "userdb.gsi.DEFAULT_PERM_REMOVE";
    private static final String MSG_UNIVERSAL_GROUP_REMOVE = "userdb.gsi.UNIVERSAL_GROUP_REMOVE";
    private static final String MSG_REGISTERED_GROUP_REMOVE = "userdb.gsi.REGISTERED_GROUP_REMOVE";
    private static final String MSG_SYSTEM_NAME_CHANGED = "userdb.gsi.SYSTEM_NAME_CHANGED";
    private static final String MSG_SYSTEM_TYPE_CHANGED = "userdb.gsi.SYSTEM_TYPE_CHANGED";
    private AdminServicesManager mManager;
    private Vector mListeners = new Vector();

    GroupServicesImpl(AdminServicesManager manager) {
        this.setManager(manager);
    }

    public AdminServicesManager getManager() {
        return this.mManager;
    }

    private void setManager(AdminServicesManager manager) {
        this.mManager = manager;
    }

    private GroupTable getGroupTable() {
        return GroupTable.DEFAULT;
    }

    private UserTable getUserTable() {
        return UserTable.DEFAULT;
    }

    private GroupMemberTable getGroupMemberTable() {
        return GroupMemberTable.DEFAULT;
    }

    private PermissionTable getPermissionTable() {
        return PermissionTable.DEFAULT;
    }

    private GrantedPermissionTable getGrantedPermissionTable() {
        return GrantedPermissionTable.DEFAULT;
    }

    private ParentChildGroupTable getParentChildGroupTable() {
        return ParentChildGroupTable.DEFAULT;
    }

    private GroupGraphTable getGroupGraphTable() {
        return GroupGraphTable.DEFAULT;
    }

    private Object transact(Transaction t) throws UserDBException {
        return this.getManager().transact(t);
    }

    public void addGroupListener(GroupListener listener) {
        this.mListeners.add(listener);
    }

    public void removeGroupListener(GroupListener listener) {
        this.mListeners.remove(listener);
    }

    private void notifyGroupAdded(GroupID groupID) throws InvalidChangeException {
        GroupEvent event = new GroupEvent(groupID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((GroupListener)listeners.nextElement()).groupAdded(event);
        }
    }

    private void notifyGroupModified(GroupID groupID) throws InvalidChangeException {
        GroupEvent event = new GroupEvent(groupID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((GroupListener)listeners.nextElement()).groupModified(event);
        }
    }

    private void notifyGroupRemoved(GroupID groupID) throws InvalidChangeException {
        GroupEvent event = new GroupEvent(groupID);
        Enumeration listeners = this.mListeners.elements();
        while (listeners.hasMoreElements()) {
            ((GroupListener)listeners.nextElement()).groupRemoved(event);
        }
    }

    public RemoteGroup getGroup(String groupName) throws UserDBException {
        RemoteGroup[] results = this.getGroupTable().executeSelectByName(groupName);
        if (results.length > 0) {
            return results[0];
        }
        return null;
    }

    public RemoteGroup[] getGroupsByUser(UserID userID) throws UserDBException {
        return this.getGroupTable().executeSelectByMember(userID);
    }

    public RemoteGroup[] getGroupsByCriteria(String namePattern, String descPattern, String typePattern) throws UserDBException {
        GroupTable gt = this.getGroupTable();
        return gt.executeSelectByCriteria(namePattern, descPattern, typePattern);
    }

    public RemoteUser[] getGroupMembers(GroupID groupID) throws UserDBException {
        UserTable ut = this.getUserTable();
        return ut.executeSelectByMembership(groupID);
    }

    public boolean isGroupMember(GroupID groupID, UserID userID) throws UserDBException {
        GroupGraphTable ggt = this.getGroupGraphTable();
        return ggt.executeSelectGroupMemberCount(groupID, userID) > 0;
    }

    public RemotePermission[] getGrantedPermissions(GroupID groupID) throws UserDBException {
        PermissionTable pt = this.getPermissionTable();
        return pt.executeSelectByGroupAncestors(groupID);
    }

    public boolean isGrantedPermission(GroupID groupID, PermissionID permissionID) throws UserDBException {
        GrantedPermissionTable gpt = this.getGrantedPermissionTable();
        return gpt.executeSelectGrantedPermissionCount(groupID, permissionID) > 0;
    }

    public RemoteGroup[] getDescendantGroups(GroupID groupID) throws UserDBException {
        return this.getGroupTable().executeSelectDescendants(groupID);
    }

    public RemoteGroup[] getAncestorGroups(GroupID groupID) throws UserDBException {
        return this.getGroupTable().executeSelectAncestors(groupID);
    }

    public boolean isGroupDescendant(GroupID parentGroupID, GroupID childGroupID) throws UserDBException {
        int count = this.getGroupGraphTable().getDescendantCount(parentGroupID, childGroupID);
        return count > 0;
    }

    public GroupData getGroupData(GroupID groupID) throws UserDBException {
        try {
            PersistentGroupData result = new PersistentGroupData(groupID);
            result.retrieve();
            return result.toGroupData();
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    public RemoteUser[] getUsers(GroupID groupID) throws UserDBException {
        UserTable ut = this.getUserTable();
        return ut.executeSelectByGroup(groupID);
    }

    public RemotePermission[] getPermissions(GroupID groupID) throws UserDBException {
        PermissionTable pt = this.getPermissionTable();
        return pt.executeSelectByGroup(groupID, FolderPermission.class.getName());
    }

    public RemoteGroup[] getChildGroups(GroupID parentGroupID) throws UserDBException {
        GroupTable gt = this.getGroupTable();
        return gt.executeSelectByParent(parentGroupID);
    }

    public RemoteGroup[] getParentGroups(GroupID childGroupID) throws UserDBException {
        GroupTable gt = this.getGroupTable();
        return gt.executeSelectByChild(childGroupID);
    }

    public GroupID save(final GroupID groupID, final GroupData groupData, final UserID[] users, PermissionID[] permissions, final GroupID[] parentGroups, final GroupID[] childGroups) throws UserDBException {
        if (groupID == null || groupData != null) {
            this.validate(groupData);
        }
        if (RemoteGroupManager.isSystemGroup(groupID)) {
            this.validateSystemGroup(groupID, groupData);
            if (RemoteGroupManager.ADMIN_GROUPID.equals(groupID)) {
                if (users != null) {
                    this.verifyContainsAdminUser(users);
                }
            } else if (RemoteGroupManager.REGISTERED_GROUPID.equals(groupID)) {
                if (parentGroups != null) {
                    this.verifyContainsGroup(parentGroups, RemoteGroupManager.UNIVERSAL_GROUPID, MSG_UNIVERSAL_GROUP_REMOVE);
                }
            } else if (RemoteGroupManager.UNIVERSAL_GROUPID.equals(groupID) && childGroups != null) {
                this.verifyContainsGroup(childGroups, RemoteGroupManager.REGISTERED_GROUPID, MSG_REGISTERED_GROUP_REMOVE);
            }
            if (permissions != null) {
                permissions = this.addInvisiblePermissions(permissions, groupID);
                this.verifyContainsDefaultPermissions(groupID, permissions);
            }
        }
        final PermissionID[] finalPerms = permissions;
        return (GroupID)this.transact(new Transaction(){

            public Object execute() throws SQLException, PersistenceManagerException {
                return GroupServicesImpl.this.transactSave(groupID, groupData, users, finalPerms, parentGroups, childGroups);
            }
        });
    }

    private GroupID transactSave(GroupID groupID, GroupData groupData, UserID[] users, PermissionID[] permissions, GroupID[] parentGroups, GroupID[] childGroups) throws PersistenceManagerException {
        PersistentGroupData pData;
        boolean isNew;
        boolean bl = isNew = groupID == null;
        if (isNew) {
            pData = new PersistentGroupData(groupID, groupData);
            pData.save();
            groupID = pData.getGroupID();
        } else {
            this.lock(groupID);
        }
        if (isNew) {
            this.insertGroupGraph(groupID);
        }
        if (permissions != null) {
            if (!isNew) {
                this.deleteGrantedPermissions(groupID, FolderPermission.class.getName());
            }
            if (permissions.length > 0) {
                this.insertGrantedPermissions(groupID, permissions);
            }
        }
        if (users != null) {
            if (!isNew) {
                this.deleteGroupMembers(groupID);
            }
            if (users.length > 0) {
                this.insertGroupMembers(groupID, users);
            }
        }
        if (parentGroups != null) {
            if (!isNew) {
                this.removeParentChildLinksByChild(groupID);
                this.deleteParentGroups(groupID);
            }
            if (parentGroups.length > 0) {
                this.insertParentGroups(groupID, parentGroups);
                this.updateGroupGraph(parentGroups, groupID);
            }
        }
        if (childGroups != null) {
            if (!isNew) {
                this.removeParentChildLinksByParent(groupID);
                this.deleteChildGroups(groupID);
            }
            if (childGroups.length > 0) {
                this.insertChildGroups(groupID, childGroups);
                this.updateGroupGraph(groupID, childGroups);
            }
        }
        if (isNew) {
            this.notifyGroupAdded(groupID);
        } else {
            pData = new PersistentGroupData(groupID, groupData);
            pData.save();
            this.notifyGroupModified(groupID);
        }
        return groupID;
    }

    private void validate(GroupData groupData) throws UserDBException {
        if (groupData == null) {
            throw new UserDBException(MSG_INVALID_NAME, null);
        }
        String name = groupData.getName();
        if (!this.isValidGroupName(name)) {
            throw new UserDBException(MSG_INVALID_NAME, groupData.getName());
        }
        String description = groupData.getDescription();
        if (description != null && !Validate.isValidObjectDescription(description)) {
            throw new UserDBException(MSG_INVALID_DESCRIPTION);
        }
    }

    private void validateSystemGroup(GroupID groupID, GroupData groupData) throws UserDBException {
        GroupData savedGroup = this.getGroupData(groupID);
        if (!savedGroup.getName().equals(groupData.getName())) {
            throw new UserDBException(MSG_SYSTEM_NAME_CHANGED, groupID);
        }
        if (!savedGroup.getType().equals(groupData.getType())) {
            throw new UserDBException(MSG_SYSTEM_TYPE_CHANGED, groupID);
        }
    }

    private boolean isValidGroupName(String name) {
        return this.getManager().isValidName(name, 0);
    }

    private void verifyContainsAdminUser(UserID[] users) throws UserDBException {
        if (!Arrays.asList(users).contains(RemoteUserManager.ADMIN_USERID)) {
            throw new UserDBException(MSG_ADMIN_USER_REMOVE);
        }
    }

    private void verifyContainsDefaultPermissions(GroupID group, PermissionID[] perms) throws UserDBException {
        HashSet defaultPerms = new HashSet(RemoteGroupManager.getRegisteredPermissions(group));
        defaultPerms.remove(RemotePermissionManager.ALL_FOLDERS_ACTIONS_PERMISSIONID);
        defaultPerms.remove(RemotePermissionManager.AUTOGEN_FOLDER_EXECUTE_ALL_PERMISSIONID);
        if (!Arrays.asList(perms).containsAll(defaultPerms)) {
            throw new UserDBException(MSG_DEFAULT_PERM_REMOVE);
        }
    }

    private void verifyContainsGroup(GroupID[] groups, GroupID group, String messageKey) throws UserDBException {
        if (!Arrays.asList(groups).contains(group)) {
            throw new UserDBException(messageKey);
        }
    }

    private PermissionID[] addInvisiblePermissions(PermissionID[] permIDs, GroupID groupID) {
        HashSet<PermissionID> permList = new HashSet<PermissionID>(Arrays.asList(permIDs));
        HashSet defaultPerms = new HashSet(RemoteGroupManager.getRegisteredPermissions(groupID));
        Iterator i = defaultPerms.iterator();
        while (i.hasNext()) {
            PermissionID id = (PermissionID)i.next();
            if (RemotePermissionManager.isVisiblePermission(id) || permList.contains(id)) continue;
            permList.add(id);
        }
        return permList.toArray(new PermissionID[0]);
    }

    private void lock(GroupID groupID) throws PersistenceManagerException {
        PersistentGroupData pData = new PersistentGroupData(groupID);
        pData.lockForUpdate();
    }

    private void insertGroupGraph(GroupID group) throws PersistenceManagerException {
        this.getGroupGraphTable().insertGroup(group);
    }

    private void insertGrantedPermissions(GroupID group, PermissionID[] perms) throws PersistenceManagerException {
        this.getPermissionTable().updatePermissionsByID(perms);
        this.getGrantedPermissionTable().insert(group, perms);
    }

    private void insertGroupMembers(GroupID group, UserID[] users) throws PersistenceManagerException {
        this.getUserTable().updateUsersByID(users);
        this.getGroupMemberTable().insert(group, users);
    }

    private void insertParentGroups(GroupID child, GroupID[] parents) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByID(parents);
        this.getParentChildGroupTable().insert(parents, child);
    }

    private void insertChildGroups(GroupID parent, GroupID[] children) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByID(children);
        this.getParentChildGroupTable().insert(parent, children);
    }

    private void removeParentChildLinksByChild(GroupID child) throws PersistenceManagerException {
        this.getGroupGraphTable().removeParentChildLinksByChild(child);
    }

    private void removeParentChildLinksByParent(GroupID parent) throws PersistenceManagerException {
        this.getGroupGraphTable().removeParentChildLinksByParent(parent);
    }

    private void updateGroupGraph(GroupID[] parents, GroupID child) throws PersistenceManagerException {
        this.getGroupGraphTable().addParentChildLinks(parents, child);
    }

    private void updateGroupGraph(GroupID parent, GroupID[] children) throws PersistenceManagerException {
        this.getGroupGraphTable().addParentChildLinks(parent, children);
    }

    void delete(final GroupID groupID) throws UserDBException {
        Permission[] grantedPerms = PermissionTable.DEFAULT.executeSelectGranted(groupID, null, FolderPermission.class.getName(), null);
        final FolderIDSet grantedFolders = FolderPermissionNameElements.extractFolderIDs(grantedPerms);
        this.transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                GroupServicesImpl.this.transactDelete(groupID, grantedFolders);
                return null;
            }
        });
    }

    private void transactDelete(GroupID groupID, FolderIDSet grantedFolders) throws PersistenceManagerException {
        this.removeParentChildLinks(groupID);
        this.deleteParentChildGroups(groupID);
        this.deleteGroupGraph(groupID);
        this.incrementUpdateCounts(grantedFolders);
        this.deleteGrantedPermissions(groupID, null);
        this.deleteGroupMembers(groupID);
        new PersistentGroupData(groupID).delete();
        this.notifyGroupRemoved(groupID);
    }

    private void incrementUpdateCounts(FolderIDSet idSet) throws PersistenceManagerException {
        if (!idSet.isEmpty()) {
            FolderImplTable table = FolderImplTable.DEFAULT;
            FolderImplTable.execute(table.incrUpdateCountWhere(FolderImplTable.in((ColumnNode)table.ID, FolderImplTable.rList(idSet.toIDArray()))));
        }
    }

    private void deleteGroupGraph(GroupID groupID) throws PersistenceManagerException {
        this.getGroupGraphTable().deleteGroup(groupID);
    }

    private void deleteGrantedPermissions(GroupID groupID, String excludeClassNamePattern) throws PersistenceManagerException {
        this.getPermissionTable().updatePermissionsByGroup(groupID, excludeClassNamePattern);
        this.getGrantedPermissionTable().deleteByGroup(groupID, excludeClassNamePattern);
    }

    private void deleteGroupMembers(GroupID groupID) throws PersistenceManagerException {
        this.getUserTable().updateUsersByGroup(groupID);
        this.getGroupMemberTable().deleteByGroup(groupID);
    }

    private void deleteParentChildGroups(GroupID groupID) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByParentOrChild(groupID);
        this.getParentChildGroupTable().deleteByParentOrChild(groupID);
    }

    private void deleteParentGroups(GroupID childGroupID) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByChild(childGroupID);
        this.getParentChildGroupTable().deleteByChild(childGroupID);
    }

    private void deleteChildGroups(GroupID parentGroupID) throws PersistenceManagerException {
        this.getGroupTable().updateGroupsByParent(parentGroupID);
        this.getParentChildGroupTable().deleteByParent(parentGroupID);
    }

    private void removeParentChildLinks(GroupID group) throws PersistenceManagerException {
        this.getGroupGraphTable().removeParentChildLinks(group);
    }
}

