/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupGraphTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupMemberTable;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserTable;

class GroupMemberTable
extends PersistentGroupMemberTable {
    public static final GroupMemberTable DEFAULT = new GroupMemberTable(null);

    public GroupMemberTable(String alias) {
        super(alias);
    }

    public void checkReadPermission() {
        GroupTable.DEFAULT.checkReadPermission();
        UserTable.DEFAULT.checkReadPermission();
    }

    public void checkWritePermission() {
        GroupTable.DEFAULT.checkWritePermission();
        UserTable.DEFAULT.checkWritePermission();
    }

    public void checkDeletePermission() {
        GroupTable.DEFAULT.checkWritePermission();
        UserTable.DEFAULT.checkWritePermission();
    }

    public Select selectGroupsByUser(UserID userID) {
        return this.select(GroupMemberTable.sList(this.Group), GroupMemberTable.where(GroupMemberTable.equals(this.User, userID)));
    }

    public Select selectUsersByGroup(GroupID groupID) {
        return this.select(GroupMemberTable.sList(this.User), GroupMemberTable.where(GroupMemberTable.equals(this.Group, groupID)));
    }

    public Select selectMembersByGroup(GroupID groupID) {
        return this.select(GroupMemberTable.sList(this.User), GroupMemberTable.where(this.groupIsDescendantOf(groupID)));
    }

    private ConditionalExpression groupIsDescendantOf(GroupID groupID) {
        GroupGraphTable groupGraph = GroupGraphTable.DEFAULT;
        return GroupMemberTable.in((ColumnNode)this.Group, groupGraph.selectDescendantsOf(groupID));
    }

    public int deleteByUser(UserID userID) throws PersistenceManagerException {
        return GroupMemberTable.execute(this.delete(GroupMemberTable.where(GroupMemberTable.equals(this.User, userID))));
    }

    public int deleteByGroup(GroupID groupID) throws PersistenceManagerException {
        return GroupMemberTable.execute(this.delete(GroupMemberTable.where(GroupMemberTable.equals(this.Group, groupID))));
    }

    public ColumnList allColumnsButID() {
        return GroupMemberTable.cList(this.Group, (ColumnNode)this.User);
    }

    public int insert(GroupID group, UserID[] users) throws PersistenceManagerException {
        Select values = null;
        for (int i = 0; i < users.length; ++i) {
            values = GroupMemberTable.anonSelect(this.sList(group, users[i]), values);
        }
        return GroupMemberTable.execute(this.insert(this.allColumnsButID(), values));
    }

    public SelectList sList(GroupID group, UserID user) {
        return GroupMemberTable.sList(GroupMemberTable.v(group), (ScalarExp)GroupMemberTable.v(user));
    }

    public int insert(GroupID[] groups, UserID user) throws PersistenceManagerException {
        Select values = null;
        for (int i = 0; i < groups.length; ++i) {
            values = GroupMemberTable.anonSelect(this.sList(groups[i], user), values);
        }
        return GroupMemberTable.execute(this.insert(this.allColumnsButID(), values));
    }

    public int insert(GroupID group, UserID user) throws PersistenceManagerException {
        return GroupMemberTable.execute(this.insert(this.allColumnsButID(), GroupMemberTable.vList(GroupMemberTable.v(group), GroupMemberTable.v(user))));
    }
}

