/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessControlManagerImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionNameElements;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupData;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import java.util.LinkedList;

public class GroupID
extends ObjectID {
    private static final PersistentGroupData.IDFactory ID_FACTORY = new PersistentGroupData.IDFactory();
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission;

    private GroupID() {
    }

    public GroupID(String ID2) {
        super(ID2);
    }

    public static GroupID generateGroupID() {
        return ID_FACTORY.generateGroupID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        block7: {
            GroupManager gm = null;
            try {
                gm = this.getGroupManager();
                if (RemoteGroupManager.isSystemGroup(this)) {
                    throw new ObjectNotDeletableException(new ROXMessage("userdb.SYSTEM_GROUP_DELETE"));
                }
                Permission[] perms = gm.getGrantedPermissions(this);
                LinkedList<Permission> ownerPerms = new LinkedList<Permission>();
                for (int i = 0; i < perms.length; ++i) {
                    Permission perm = perms[i];
                    if (!(class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? GroupID.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission") : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName().equals(perm.getClassName()) || !"owner".equals(perm.getActions())) continue;
                    ownerPerms.add(perm);
                }
                if (ownerPerms.isEmpty()) break block7;
                String groupName = this.toString();
                try {
                    groupName = gm.getGroup(this).getName();
                }
                catch (UserDBException ignored) {
                    // empty catch block
                }
                FolderIDSet idSet = FolderPermissionNameElements.extractFolderIDs(ownerPerms.toArray(new Permission[ownerPerms.size()]));
                throw new ObjectNotDeletableException(new ROXMessage("userdb.GROUP_OWNS_FOLDERS", groupName, FolderAccessControlManagerImpl.toString(idSet)));
            }
            catch (UserDBException udbe) {
                throw new PersistenceManagerException(udbe);
            }
            catch (RPCException e) {
                throw new PersistenceManagerException(e);
            }
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        GroupIDSet idset = new GroupIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        try {
            PersistenceManager.getInstance().getApplication().getUserDBSubsystem().getAdminServicesManager().getGroupServices().delete(this);
        }
        catch (UnsupportedSubsystemException e) {
            throw new PersistenceManagerException(e);
        }
        catch (UserDBException e) {
            throw new PersistenceManagerException(e);
        }
    }

    protected GroupManager getGroupManager() throws UserDBException {
        try {
            return PersistenceManager.getInstance().getApplication().getUserDBSubsystem().getLocalUserDBAdmin().getGroupManager();
        }
        catch (UnsupportedSubsystemException use) {
            throw new UserDBException(use);
        }
    }
}

