/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Comparison;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IDValueProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Set;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.ValueWrapper;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupMemberTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.ParentChildGroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupGraphTable;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteGroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Collection;

class GroupGraphTable
extends PersistentGroupGraphTable {
    private static final GroupMemberTable GMT = new GroupMemberTable("gmT");
    public static final GroupGraphTable DEFAULT = new GroupGraphTable(null);
    private static final ScalarExp ZERO = GroupGraphTable.v(0);
    private static final ScalarExp ONE = GroupGraphTable.v(1);

    public GroupGraphTable(String alias) {
        super(alias);
    }

    public void checkReadPermission() {
        GroupTable.DEFAULT.checkReadPermission();
    }

    public void checkWritePermission() {
        GroupTable.DEFAULT.checkWritePermission();
    }

    public void checkDeletePermission() {
        GroupTable.DEFAULT.checkWritePermission();
    }

    public ColumnList allColumnsButID() {
        return GroupGraphTable.cList(this.Ancestor, this.Descendant, this.Count);
    }

    public int insertGroup(GroupID groupID) throws PersistenceManagerException {
        GroupTable groups = GroupTable.DEFAULT;
        ValueWrapper groupExpr = GroupGraphTable.v(groupID);
        Comparison groupNotEqual = GroupGraphTable.notEquals(groups.ID, groupID);
        Select values = GroupGraphTable.anonSelect(GroupGraphTable.sList(groupExpr, groupExpr, ONE));
        values = groups.select(GroupGraphTable.sList(groupExpr, groups.ID, ZERO), GroupGraphTable.where(groupNotEqual), values);
        values = groups.select(GroupGraphTable.sList(groups.ID, groupExpr, ZERO), GroupGraphTable.where(groupNotEqual), values);
        return GroupGraphTable.execute(this.insert(this.allColumnsButID(), values));
    }

    public int deleteGroup(GroupID groupID) throws PersistenceManagerException {
        return GroupGraphTable.execute(this.delete(GroupGraphTable.where(GroupGraphTable.or(GroupGraphTable.equals(this.Ancestor, groupID), GroupGraphTable.equals(this.Descendant, groupID)))));
    }

    public int addParentChildLink(GroupID parent, GroupID child) throws PersistenceManagerException {
        return GroupGraphTable.execute(this.update(GroupGraphTable.uList(this.incrementCount(parent, child)), GroupGraphTable.where(this.relationsOfParentAndChild(parent, child))));
    }

    public int addParentChildLinks(GroupID[] parents, GroupID child) throws PersistenceManagerException {
        return GroupGraphTable.execute(this.update(GroupGraphTable.uList(this.incrementCount(parents, child)), GroupGraphTable.where(this.relationsOfParentsAndChild(parents, child))));
    }

    public int addParentChildLinks(GroupID parent, GroupID[] children) throws PersistenceManagerException {
        return GroupGraphTable.execute(this.update(GroupGraphTable.uList(this.incrementCount(parent, children)), GroupGraphTable.where(this.relationsOfParentAndChildren(parent, children))));
    }

    public int removeParentChildLink(GroupID parent, GroupID child) throws PersistenceManagerException {
        return GroupGraphTable.execute(this.update(GroupGraphTable.uList(this.decrementCount(parent, child)), GroupGraphTable.where(this.relationsOfParentAndChild(parent, child))));
    }

    public int removeParentChildLinksByChild(GroupID child) throws PersistenceManagerException {
        return GroupGraphTable.execute(this.update(GroupGraphTable.uList(this.decrementCountByParentsOf(child)), GroupGraphTable.where(this.relationsOfParentsAndChild(child))));
    }

    public int removeParentChildLinksByParent(GroupID parent) throws PersistenceManagerException {
        return GroupGraphTable.execute(this.update(GroupGraphTable.uList(this.decrementCountByChildrenOf(parent)), GroupGraphTable.where(this.relationsOfParentAndChildren(parent))));
    }

    public int removeParentChildLinks(GroupID group) throws PersistenceManagerException {
        return GroupGraphTable.execute(this.update(GroupGraphTable.uList(this.decrementCount(group)), GroupGraphTable.where(this.relationsOfParentsAndChildren(group))));
    }

    private Set incrementCountBy(ScalarExp expr) {
        return GroupGraphTable.set((ColumnNode)this.Count, GroupGraphTable.plus(this.Count, expr));
    }

    private Set incrementCount(GroupID parent, GroupID child) {
        return this.incrementCountBy(this.findCountVia(parent, child));
    }

    private Set incrementCount(GroupID parent, GroupID[] children) {
        return this.incrementCountBy(this.findCountVia(parent, children));
    }

    private Set incrementCount(GroupID[] parents, GroupID child) {
        return this.incrementCountBy(this.findCountVia(parents, child));
    }

    private ScalarExp findCountVia(GroupID parent, GroupID child) {
        return GroupGraphTable.times(this.count(this.Ancestor, parent), this.count(child, this.Descendant));
    }

    private ScalarExp findCountVia(GroupID parent, GroupID[] children) {
        ScalarExp childCountSum = null;
        for (int i = 0; i < children.length; ++i) {
            ScalarExp count = this.count(children[i], this.Descendant);
            childCountSum = childCountSum == null ? count : GroupGraphTable.plus(count, childCountSum);
        }
        return GroupGraphTable.times(this.count(this.Ancestor, parent), childCountSum);
    }

    private ScalarExp findCountVia(GroupID[] parents, GroupID child) {
        ScalarExp parentCountSum = null;
        for (int i = 0; i < parents.length; ++i) {
            ScalarExp count = this.count(this.Ancestor, parents[i]);
            parentCountSum = parentCountSum == null ? count : GroupGraphTable.plus(count, parentCountSum);
        }
        return GroupGraphTable.times(parentCountSum, this.count(child, this.Descendant));
    }

    private ScalarExp count(GroupID ancestor, ColumnNode descendant) {
        return this.count(GroupGraphTable.v(ancestor), (ScalarExp)descendant);
    }

    private ScalarExp count(ColumnNode ancestor, GroupID descendant) {
        return this.count((ScalarExp)ancestor, GroupGraphTable.v(descendant));
    }

    private ScalarExp count(ScalarExp ancestor, ScalarExp descendant) {
        return GroupGraphTable.function("rox_group_relations_count", GroupGraphTable.rList(ancestor, descendant));
    }

    private Set decrementCountBy(ScalarExp expr) {
        return GroupGraphTable.set((ColumnNode)this.Count, GroupGraphTable.minus(this.Count, expr));
    }

    private Set decrementCount(GroupID parent, GroupID child) {
        return this.decrementCountBy(this.findCountVia(parent, child));
    }

    private Set decrementCountByChildrenOf(GroupID parent) {
        return this.decrementCountBy(this.findCountViaChildrenOf(parent));
    }

    private Set decrementCountByParentsOf(GroupID child) {
        return this.decrementCountBy(this.findCountViaParentsOf(child));
    }

    private Set decrementCount(GroupID group) {
        return this.decrementCountBy(this.findCountVia(group));
    }

    private ScalarExp findParentCountSum(GroupID child) {
        ParentChildGroupTable pcg = new ParentChildGroupTable("pcg");
        return GroupGraphTable.scalar(pcg.select(GroupGraphTable.sList(GroupGraphTable.sum(this.count((ScalarExp)this.Ancestor, (ScalarExp)pcg.Parent))), GroupGraphTable.where(GroupGraphTable.equals(pcg.Child, child))));
    }

    private ScalarExp findCountViaParentsOf(GroupID child) {
        return GroupGraphTable.times(this.findParentCountSum(child), this.count(child, this.Descendant));
    }

    private ScalarExp findChildCountSum(GroupID parent) {
        ParentChildGroupTable pcg = new ParentChildGroupTable("pcg");
        return GroupGraphTable.scalar(pcg.select(GroupGraphTable.sList(GroupGraphTable.sum(this.count((ScalarExp)pcg.Child, (ScalarExp)this.Descendant))), GroupGraphTable.where(GroupGraphTable.equals(pcg.Parent, parent))));
    }

    private ScalarExp findCountViaChildrenOf(GroupID parent) {
        return GroupGraphTable.times(this.count(this.Ancestor, parent), this.findChildCountSum(parent));
    }

    private ScalarExp findCountVia(GroupID group) {
        return GroupGraphTable.times(this.findParentCountSum(group), this.findChildCountSum(group));
    }

    private ConditionalExpression relationsOfParentAndChild(GroupID parent, GroupID child) {
        return GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Ancestor, this.selectAncestorsOf(parent)), GroupGraphTable.in((ColumnNode)this.Descendant, this.selectDescendantsOf(child)));
    }

    private ConditionalExpression relationsOfParentAndChildren(GroupID parent, GroupID[] children) {
        return GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Ancestor, this.selectAncestorsOf(parent)), GroupGraphTable.in((ColumnNode)this.Descendant, this.selectDescendantsOf(children)));
    }

    private ConditionalExpression relationsOfParentsAndChild(GroupID[] parents, GroupID child) {
        return GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Ancestor, this.selectAncestorsOf(parents)), GroupGraphTable.in((ColumnNode)this.Descendant, this.selectDescendantsOf(child)));
    }

    private ConditionalExpression relationsOfParentsAndChild(GroupID child) {
        return GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Ancestor, this.selectAncestorsOf(this.selectParentsOf(child))), GroupGraphTable.in((ColumnNode)this.Descendant, this.selectDescendantsOf(child)));
    }

    private ConditionalExpression relationsOfParentAndChildren(GroupID parent) {
        return GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Ancestor, this.selectAncestorsOf(parent)), GroupGraphTable.in((ColumnNode)this.Descendant, this.selectDescendantsOf(this.selectChildrenOf(parent))));
    }

    private ConditionalExpression relationsOfParentsAndChildren(GroupID group) {
        return GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Ancestor, this.selectAncestorsOf(this.selectParentsOf(group))), GroupGraphTable.in((ColumnNode)this.Descendant, this.selectDescendantsOf(this.selectChildrenOf(group))));
    }

    private Select selectParentsOf(GroupID child) {
        return ParentChildGroupTable.DEFAULT.selectParentsByChild(child);
    }

    private Select selectChildrenOf(GroupID parent) {
        return ParentChildGroupTable.DEFAULT.selectChildrenByParent(parent);
    }

    public Select selectAncestorsOf(GroupID group) {
        return this.select(GroupGraphTable.sList(this.Ancestor), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.equals(this.Descendant, group), this.countIsPositive())));
    }

    public Select selectAncestorsOf(GroupID[] groups) {
        return this.select(GroupGraphTable.sList(this.Ancestor), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Descendant, GroupGraphTable.rList(groups)), this.countIsPositive())));
    }

    public Select selectAncestorsOf(Select groups) {
        return this.select(GroupGraphTable.sList(this.Ancestor), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Descendant, groups), this.countIsPositive())));
    }

    private ConditionalExpression countIsPositive() {
        return GroupGraphTable.greaterThan(this.Count, 0);
    }

    public Select selectDescendantsOf(GroupID group) {
        return this.select(GroupGraphTable.sList(this.Descendant), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.equals(this.Ancestor, group), this.countIsPositive())));
    }

    public Select selectDescendantsOf(GroupID[] groups) {
        return this.select(GroupGraphTable.sList(this.Descendant), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Ancestor, GroupGraphTable.rList(groups)), this.countIsPositive())));
    }

    public Select selectDescendantsOf(Select groups) {
        return this.select(GroupGraphTable.sList(this.Descendant), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.in((ColumnNode)this.Ancestor, groups), this.countIsPositive())));
    }

    public int getDescendantCount(GroupID ancestor, GroupID descendant) throws UserDBException {
        try {
            return GroupGraphTable.executeInt(this.selectCount(ancestor, descendant));
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    private Select selectCount(GroupID ancestor, GroupID descendant) {
        return this.select(GroupGraphTable.sList(this.Count), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.equals(this.Ancestor, ancestor), GroupGraphTable.equals(this.Descendant, descendant))));
    }

    public Select selectGroupsByMember(UserID userID) {
        GroupID systemGroup = this.getSystemGroupForUser(userID);
        return GroupGraphTable.select(GroupGraphTable.sList(this.Ancestor), GroupGraphTable.tList(this, (TableClause)GMT), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.greaterThan(this.Count, 0), GroupGraphTable.and(GroupGraphTable.equals(GroupGraphTable.GMT.User, userID), GroupGraphTable.equals((ColumnNode)GroupGraphTable.GMT.Group, this.Descendant)))), this.select(GroupGraphTable.sList(this.Ancestor), GroupGraphTable.where(GroupGraphTable.and(GroupGraphTable.greaterThan(this.Count, 0), GroupGraphTable.equals(this.Descendant, systemGroup)))));
    }

    GroupIDSet getGroupsByMember(UserID userID) throws UserDBException {
        return this.executeFetchAncestor(this.selectGroupsByMember(userID));
    }

    private GroupIDSet executeFetchAncestor(Select query) throws UserDBException {
        if (query == null) {
            return null;
        }
        try {
            IDValueProcessor proc = new IDValueProcessor(this.Ancestor);
            GroupGraphTable.execute(query, proc);
            GroupIDSet groupIds = new GroupIDSet();
            groupIds.addAll((Collection)proc.getRetrievedValues());
            return groupIds;
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    private ConditionalExpression ancestorContainsUser(UserID userID) {
        Select groupsByUser = GroupMemberTable.DEFAULT.selectGroupsByUser(userID);
        GroupID systemGroup = this.getSystemGroupForUser(userID);
        return GroupGraphTable.and(this.countIsPositive(), GroupGraphTable.or(GroupGraphTable.in((ColumnNode)this.Descendant, groupsByUser), GroupGraphTable.equals(this.Descendant, systemGroup)));
    }

    public GroupID getSystemGroupForUser(UserID user) {
        return user == null ? RemoteGroupManager.UNIVERSAL_GROUPID : RemoteGroupManager.REGISTERED_GROUPID;
    }

    public ConditionalExpression isDescendantOf(GroupID parent, GroupID child) {
        return GroupGraphTable.greaterThan(this.selectCount(parent, child), 0);
    }

    public int executeSelectGroupMemberCount(GroupID group, UserID user) throws UserDBException {
        try {
            AndExp where = GroupGraphTable.and(this.ancestorContainsUser(user), GroupGraphTable.equals(this.Ancestor, group));
            return this.selectCount(GroupGraphTable.where(where));
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }
}

