/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnList;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.systemmodel.userdb.AdminServicesManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupGraphTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGrantedPermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentPermissionDataTable;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

class GrantedPermissionTable
extends PersistentGrantedPermissionTable {
    public static final GrantedPermissionTable DEFAULT = new GrantedPermissionTable(null);
    private static final GroupGraphTable GGT = new GroupGraphTable("ggT");

    public GrantedPermissionTable(String alias) {
        super(alias);
    }

    public void checkReadPermission() {
        GroupTable.DEFAULT.checkReadPermission();
        PermissionTable.DEFAULT.checkReadPermission();
    }

    public void checkWritePermission() {
        GroupTable.DEFAULT.checkWritePermission();
        PermissionTable.DEFAULT.checkWritePermission();
    }

    public void checkDeletePermission() {
        GroupTable.DEFAULT.checkWritePermission();
        PermissionTable.DEFAULT.checkWritePermission();
    }

    public Select selectGroupsByPermission(PermissionID permID) {
        return this.select(GrantedPermissionTable.sList(this.Group), GrantedPermissionTable.where(GrantedPermissionTable.equals(this.Permission, permID)));
    }

    public Select selectGroupsByPermission(IDColumn permID) {
        return this.select(GrantedPermissionTable.sList(this.Group), GrantedPermissionTable.where(GrantedPermissionTable.equals((ColumnNode)this.Permission, permID)));
    }

    public Select selectPermissionsByGroup(GroupID groupID) {
        return this.select(GrantedPermissionTable.sList(this.Permission), GrantedPermissionTable.where(GrantedPermissionTable.equals(this.Group, groupID)));
    }

    public Select selectPermissionsByGroupAncestors(GroupID groupID) {
        return this.select(GrantedPermissionTable.sList(this.Permission), GrantedPermissionTable.where(this.groupIsAncestorOf(groupID)));
    }

    private ConditionalExpression groupIsAncestorOf(GroupID groupID) {
        return GrantedPermissionTable.in((ColumnNode)this.Group, GroupGraphTable.DEFAULT.selectAncestorsOf(groupID));
    }

    public int deleteByPermission(PermissionID permID) throws PersistenceManagerException {
        return GrantedPermissionTable.execute(this.delete(GrantedPermissionTable.where(GrantedPermissionTable.equals(this.Permission, permID))));
    }

    public int deleteByGroup(GroupID groupID, String excludeClassNamePattern) throws PersistenceManagerException {
        PermissionTable pTable = PermissionTable.DEFAULT;
        AndExp andExp = GrantedPermissionTable.and();
        andExp.add(GrantedPermissionTable.equals(this.Group, groupID));
        if (excludeClassNamePattern != null) {
            andExp.add(GrantedPermissionTable.in((ColumnNode)this.Permission, pTable.selectID(excludeClassNamePattern)));
        }
        return GrantedPermissionTable.execute(this.delete(GrantedPermissionTable.where(andExp)));
    }

    public ColumnList allColumnsButID() {
        return GrantedPermissionTable.cList(this.Group, (ColumnNode)this.Permission);
    }

    public int insert(GroupID group, PermissionID[] perms) throws PersistenceManagerException {
        Select values = null;
        for (int i = 0; i < perms.length; ++i) {
            values = GrantedPermissionTable.anonSelect(this.sList(group, perms[i]), values);
        }
        return GrantedPermissionTable.execute(this.insert(this.allColumnsButID(), values));
    }

    public SelectList sList(GroupID group, PermissionID perm) {
        return GrantedPermissionTable.sList(GrantedPermissionTable.v(group), (ScalarExp)GrantedPermissionTable.v(perm));
    }

    public int insert(GroupID[] groups, PermissionID perm) throws PersistenceManagerException {
        Select values = null;
        for (int i = 0; i < groups.length; ++i) {
            values = GrantedPermissionTable.anonSelect(this.sList(groups[i], perm), values);
        }
        return GrantedPermissionTable.execute(this.insert(this.allColumnsButID(), values));
    }

    public int insert(GroupID group, PermissionID perm) throws PersistenceManagerException {
        return GrantedPermissionTable.execute(this.insert(this.allColumnsButID(), GrantedPermissionTable.vList(GrantedPermissionTable.v(group), GrantedPermissionTable.v(perm))));
    }

    public ConditionalExpression selectPermissionsByUser(UserID userID, PersistentPermissionDataTable pddt) throws UserDBException {
        return GrantedPermissionTable.and(GrantedPermissionTable.equals((ColumnNode)this.Permission, pddt.ID), GrantedPermissionTable.in((ColumnNode)this.Group, GrantedPermissionTable.rList(GGT.getGroupsByMember(userID).toIDArray())));
    }

    public int executeSelectGrantedPermissionCount(GroupID groupID, PermissionID permID) throws UserDBException {
        try {
            AndExp where = GrantedPermissionTable.and(GrantedPermissionTable.equals(this.Permission, permID), this.groupIsAncestorOf(groupID));
            return this.selectCount(GrantedPermissionTable.where(where));
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    public HashMap getGrantedGroups(PermissionID[] permIDs) throws PersistenceManagerException {
        final HashMap returnValue = new HashMap();
        if (permIDs == null || permIDs.length == 0) {
            return returnValue;
        }
        GrantedPermissionTable.execute(GrantedPermissionTable.select(GrantedPermissionTable.sList(this.Group, (ScalarExp)this.Permission), GrantedPermissionTable.tList(this), GrantedPermissionTable.where(GrantedPermissionTable.in((ColumnNode)this.Permission, GrantedPermissionTable.rList(permIDs)))), new ResultSetProcessor(){

            public void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
                while (inResultSet.next()) {
                    PermissionID permID = (PermissionID)GrantedPermissionTable.this.Permission.retrieveValue(inResultSet);
                    GroupID groupID = (GroupID)GrantedPermissionTable.this.Group.retrieveValue(inResultSet);
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("PermID:" + permID + ":groupID:" + groupID, this);
                    }
                    GroupIDSet gIDSet = null;
                    gIDSet = (GroupIDSet)returnValue.get(permID);
                    if (gIDSet == null) {
                        gIDSet = new GroupIDSet();
                        returnValue.put(permID, gIDSet);
                    }
                    gIDSet.add(groupID);
                }
            }
        });
        return returnValue;
    }

    public int deleteByPermPattern(String namePattern, String classNamePattern, String actionsPattern) throws PersistenceManagerException {
        return GrantedPermissionTable.execute(this.delete(GrantedPermissionTable.where(GrantedPermissionTable.in((ColumnNode)this.Permission, PermissionTable.DEFAULT.selectIDByCriteria(namePattern, classNamePattern, actionsPattern)))));
    }
}

