/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.systemmodel.userdb.DigestStringHasher;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserServicesImpl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;

public class GenerateHashedPassword {
    private static final int UNKNOWN_ERROR = -2;
    private static final int ILLEGAL_USAGE = -1;
    private static final int ILLEGAL_INPUT = 1;

    public static void main(String[] args) {
        PrintStream origStdout = System.out;
        PrintStream newStdout = new PrintStream(new ByteArrayOutputStream());
        System.setOut(newStdout);
        if (args.length != 2 || !args[0].equals("-u")) {
            System.err.println("Usage: GenerateHashedPassword -u <username>");
            System.exit(-1);
        }
        String userName = args[1];
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            String password = in.readLine();
            String hash = GenerateHashedPassword.generateHashedPassword(userName, password);
            origStdout.println(hash);
        }
        catch (UserDBException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-2);
        }
    }

    public static String generateHashedPassword(String username, String password) throws UserDBException {
        UserServicesImpl.validatePassword(password);
        String passwordHash = null;
        try {
            passwordHash = new DigestStringHasher().hash(username, password).toString();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
            System.exit(-2);
        }
        return passwordHash;
    }
}

