/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;

class FolderPermissionNameElements {
    static final FolderPermissionNameElements ANY_FOLDER = new FolderPermissionNameElements();
    private String mName = null;
    private boolean mFolderAll = false;
    private boolean mFolderAny = false;
    private FolderID mFolderID = null;
    private boolean mTargetPerm = false;
    private boolean mTargetHostSet = false;
    private boolean mHostSetAll = false;
    private HostSetID mHostSetID = null;
    private boolean mHostAll = false;
    private boolean mHostAny = false;
    private HostID mHostID = null;

    public boolean isFolderAll() {
        return this.mFolderAll;
    }

    public boolean isFolderAny() {
        return this.mFolderAny;
    }

    public FolderID getFolderID() {
        return this.mFolderID;
    }

    public boolean isTargetPerm() {
        return this.mTargetPerm;
    }

    public boolean isHostAll() {
        return this.mHostAll;
    }

    public boolean isHostAny() {
        return this.mHostAny;
    }

    public HostID getHostID() {
        return this.mHostID;
    }

    public boolean isTargetHostSet() {
        return this.mTargetHostSet;
    }

    public boolean isHostSetAll() {
        return this.mHostSetAll;
    }

    public HostSetID getHostSetID() {
        return this.mHostSetID;
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return "FolderID:" + this.mFolderID + ":FolderAny:" + this.mFolderAny + ":FolderAll:" + this.mFolderAll + ":Target:" + this.mTargetPerm + ":TargetHostSet?:" + this.mTargetHostSet + ":HostSetID:" + this.mHostSetID + ":HostSetAll:" + this.mHostSetAll + ":HostID:" + this.mHostID + ":HostAll:" + this.mHostAll + ":HostAny:" + this.mHostAny + ":Name:" + this.mName;
    }

    FolderPermissionNameElements(String name) {
        this.mName = name;
        if (!name.startsWith("folder:")) {
            FolderPermissionNameElements.throwIllegalName(name);
        }
        int idx = name.indexOf(58, "folder:".length());
        String folderID = null;
        if (idx == -1) {
            if (name.length() <= "folder:".length()) {
                FolderPermissionNameElements.throwIllegalName(name);
            } else {
                folderID = name.substring("folder:".length());
            }
        } else {
            folderID = name.substring("folder:".length(), idx);
        }
        if (folderID.length() == 0) {
            FolderPermissionNameElements.throwIllegalName(name);
        }
        if ("*".equals(folderID)) {
            this.mFolderAll = true;
        } else if ("-".equals(folderID)) {
            this.mFolderAny = true;
        } else {
            if (!FolderPermissionNameElements.isValidObjectID(folderID)) {
                FolderPermissionNameElements.throwIllegalName(name);
            }
            this.mFolderID = new FolderID(folderID);
        }
        if (idx > 0) {
            name = name.substring(idx);
            this.mTargetPerm = true;
            if (name.startsWith(":hostset:")) {
                this.mTargetHostSet = true;
                String hostsetName = name.substring(":hostset:".length());
                if ("*".equals(hostsetName)) {
                    this.mHostSetAll = true;
                } else {
                    if (!FolderPermissionNameElements.isValidObjectID(hostsetName)) {
                        FolderPermissionNameElements.throwIllegalName(name);
                    }
                    this.mHostSetID = new HostSetID(hostsetName);
                }
            } else if (name.startsWith(":host:")) {
                String hostName = name.substring(":host:".length());
                if ("*".equals(hostName)) {
                    this.mHostAll = true;
                } else if ("-".equals(hostName)) {
                    this.mHostAny = true;
                } else {
                    if (!FolderPermissionNameElements.isValidObjectID(hostName)) {
                        FolderPermissionNameElements.throwIllegalName(name);
                    }
                    this.mHostID = new HostID(hostName);
                }
            } else {
                FolderPermissionNameElements.throwIllegalName(name);
            }
        }
    }

    FolderPermissionNameElements(FolderID inFolderID) {
        this.mFolderID = inFolderID;
        this.mName = FolderPermissionNameElements.getName(inFolderID);
    }

    FolderPermissionNameElements(FolderID inFolderID, HostID inHostID) {
        this.mFolderID = inFolderID;
        this.mTargetPerm = true;
        this.mHostID = inHostID;
        this.mName = FolderPermissionNameElements.getName(inFolderID, inHostID);
    }

    FolderPermissionNameElements(FolderID inFolderID, HostSetID inHostSetID) {
        this.mFolderID = inFolderID;
        this.mTargetPerm = true;
        this.mTargetHostSet = true;
        this.mHostSetID = inHostSetID;
        this.mName = FolderPermissionNameElements.getName(inFolderID, inHostSetID);
    }

    static FolderPermissionNameElements createHostAnywhere(FolderID inFolderID) {
        FolderPermissionNameElements f = new FolderPermissionNameElements(inFolderID);
        f.mName = "folder:" + inFolderID + ":host:" + "-";
        f.mTargetPerm = true;
        f.mHostAny = true;
        return f;
    }

    static String getName(FolderID inFolderID) throws IllegalArgumentException {
        if (inFolderID == null) {
            throw new IllegalArgumentException();
        }
        return "folder:" + inFolderID.toString();
    }

    static String getName(FolderID inFolderID, HostSetID inHostSetID) throws IllegalArgumentException {
        if (inFolderID == null || inHostSetID == null) {
            throw new IllegalArgumentException();
        }
        return "folder:" + inFolderID.toString() + ":hostset:" + inHostSetID;
    }

    static String getName(FolderID inFolderID, HostID inHostID) throws IllegalArgumentException {
        if (inFolderID == null || inHostID == null) {
            throw new IllegalArgumentException();
        }
        return "folder:" + inFolderID.toString() + ":host:" + inHostID;
    }

    static String getNameAllHostSets(FolderID inFolderID) throws IllegalArgumentException {
        if (inFolderID == null) {
            throw new IllegalArgumentException();
        }
        return FolderPermissionNameElements.getName(inFolderID) + ":hostset:" + "*";
    }

    private FolderPermissionNameElements() {
    }

    private static void throwIllegalName(String name) {
        throw new IllegalArgumentException(new ROXMessage("userdb.ILLEGAL_FPERM_NAME", name).toString());
    }

    private static boolean isValidObjectID(String mID) {
        if (mID == null) {
            return false;
        }
        if ((mID = mID.trim()).length() == 0) {
            return false;
        }
        char[] chars = mID.toCharArray();
        boolean seenDigit = false;
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                seenDigit = true;
                continue;
            }
            if ('-' == chars[i]) continue;
            return false;
        }
        return seenDigit;
    }

    static FolderIDSet extractFolderIDs(Permission[] inOwnedPerms) throws UserDBException {
        FolderIDSet idSet = new FolderIDSet();
        for (int i = 0; i < inOwnedPerms.length; ++i) {
            Permission ownedPerm = inOwnedPerms[i];
            FolderPermissionNameElements elem = null;
            try {
                elem = new FolderPermissionNameElements(ownedPerm.getName());
            }
            catch (Exception e) {
                throw new UserDBException("userdb.ILLEGAL_FPERM_NAME", (Throwable)e, ownedPerm.getName());
            }
            if (elem == null || elem.getFolderID() == null) continue;
            idSet.add(elem.getFolderID());
        }
        return idSet;
    }

    static {
        FolderPermissionNameElements.ANY_FOLDER.mFolderAny = true;
        FolderPermissionNameElements.ANY_FOLDER.mName = "folder:-";
    }
}

