/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionAction;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionNameElements;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermissionBase;
import com.raplix.util.ObjectUtil;
import com.raplix.util.enum.NoSuchEnumException;
import com.raplix.util.logger.Logger;
import com.sun.n1.util.RPCSerializable;
import java.security.Permission;

public class FolderPermission
extends ROXPermissionBase
implements ROXPermission {
    public static final String FOLDER_PREFIX = "folder:";
    public static final String HOSTSET_PREFIX = ":hostset:";
    public static final String HOST_PREFIX = ":host:";
    public static final String ACTION_WRITE = "write";
    public static final String ACTION_CHECKIN = "checkin";
    public static final String ACTION_AUTORUN = "autorun";
    public static final String ACTION_OWNER = "owner";
    public static final String ACTION_EXECUTE = "execute";
    public static final String ACTION_DELETE_HISTORY = "delete-history";
    public static final String ACTION_ALL = "*";
    public static final String HOST_ANYWHERE = "-";
    public static final String HOST_ALL = "*";
    public static final String FOLDER_ALL = "*";
    public static final String FOLDER_ANY = "-";
    public static final FolderPermission PERM_EXECUTE_ANYWHERE = new FolderPermission("folder:-:host:-", "execute");
    public static final FolderPermission PERM_DELETE_HISTORY_ANYWHERE = new FolderPermission("folder:-:host:-", "delete-history");
    private FolderPermissionAction mAction;
    private NameFolderSpec mNameFolderSpec;
    private NameTargetSpec mNameTargetSpec;

    public FolderPermission(String name, String action) {
        this(new FolderPermissionNameElements(name), FolderPermission.parseAction(action));
    }

    private static FolderPermissionAction parseAction(String action) {
        if (action == null) {
            throw new IllegalArgumentException(new ROXMessage("userdb.ILLEGAL_FPERM_ACTION", action).toString());
        }
        try {
            return FolderPermissionAction.FACTORY.get(action);
        }
        catch (NoSuchEnumException e) {
            throw new IllegalArgumentException(new ROXMessage("userdb.ILLEGAL_FPERM_ACTION", action).toString());
        }
    }

    private FolderPermission(FolderPermissionNameElements inName, FolderPermissionAction inAction) {
        super(inName.getName());
        this.initName(inName);
        this.mAction = inAction;
        if (!FolderPermissionAction.ALL.equals(this.mAction) && (FolderPermissionAction.EXECUTE.equals(this.mAction) || FolderPermissionAction.DELETE_HISTORY.equals(this.mAction)) ^ this.mNameTargetSpec != null) {
            throw new IllegalArgumentException(new ROXMessage("userdb.ILLEGAL_FPERM_NAME_ACTION", inName.getName(), inAction.toString()).toString());
        }
    }

    private void initName(FolderPermissionNameElements perm) {
        this.mNameFolderSpec = FolderPermission.getFolderSpec(perm);
        this.mNameTargetSpec = FolderPermission.getTargetSpec(perm);
    }

    private static NameTargetSpec getTargetSpec(FolderPermissionNameElements perm) {
        NameTargetSpec targetSpec = null;
        if (perm.isTargetPerm()) {
            targetSpec = perm.isTargetHostSet() ? (perm.isHostSetAll() ? HostSetTargetSpec.ALL : new HostSetTargetSpec(perm.getHostSetID())) : (perm.isHostAll() ? HostTargetSpec.ALL : (perm.isHostAny() ? HostTargetSpec.ANY : new HostTargetSpec(perm.getHostID())));
        }
        return targetSpec;
    }

    static NameFolderSpec getFolderSpec(FolderPermissionNameElements perm) {
        NameFolderSpec folderSpec = perm.isFolderAll() ? NameFolderSpec.AllFolders : (perm.isFolderAny() ? NameFolderSpec.AnyFolder : new NameFolderSpec(perm.getFolderID()));
        return folderSpec;
    }

    public FolderPermission(FolderID inFolderID, String action) {
        this(new FolderPermissionNameElements(inFolderID), FolderPermission.parseAction(action));
    }

    public static FolderPermission createExecutePermission(FolderID inFolderID, HostSetID inHostSetID) {
        return new FolderPermission(new FolderPermissionNameElements(inFolderID, inHostSetID), FolderPermissionAction.EXECUTE);
    }

    public static FolderPermission createExecutePermission(FolderID inFolderID, HostID inHostID) {
        return new FolderPermission(new FolderPermissionNameElements(inFolderID, inHostID), FolderPermissionAction.EXECUTE);
    }

    public static FolderPermission createDeleteHistoryPermission(FolderID inFolderID, HostSetID inHostSetID) {
        return new FolderPermission(new FolderPermissionNameElements(inFolderID, inHostSetID), FolderPermissionAction.DELETE_HISTORY);
    }

    public static FolderPermission createDeleteHistoryPermission(FolderID inFolderID, HostID inHostID) {
        return new FolderPermission(new FolderPermissionNameElements(inFolderID, inHostID), FolderPermissionAction.DELETE_HISTORY);
    }

    public static FolderPermission createTestExecuteAnywhere(FolderID inFolderID) {
        if (inFolderID == null) {
            throw new IllegalArgumentException();
        }
        return new FolderPermission(FolderPermissionNameElements.createHostAnywhere(inFolderID), FolderPermissionAction.EXECUTE);
    }

    public static FolderPermission createTestAnyFolder(String action) {
        if (ACTION_EXECUTE.equals(action)) {
            throw new IllegalArgumentException(action);
        }
        return new FolderPermission(FolderPermissionNameElements.ANY_FOLDER, FolderPermission.parseAction(action));
    }

    public static FolderPermission createTestDeleteHistoryAnywhere(FolderID inFolderID) {
        if (inFolderID == null) {
            throw new IllegalArgumentException();
        }
        return new FolderPermission(FolderPermissionNameElements.createHostAnywhere(inFolderID), FolderPermissionAction.DELETE_HISTORY);
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FolderPermission) {
            FolderPermission perm = (FolderPermission)obj;
            return ObjectUtil.equals(this.getName(), perm.getName()) && ObjectUtil.equals(this.getActions(), perm.getActions());
        }
        return false;
    }

    public String getActions() {
        return this.mAction.toString();
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof FolderPermission)) {
            return false;
        }
        FolderPermission other = (FolderPermission)permission;
        return this.checkImpliesAction(other) && this.checkImpliesName(other);
    }

    private boolean checkImpliesName(FolderPermission other) {
        if (!this.mNameFolderSpec.implies(other.mNameFolderSpec)) {
            return false;
        }
        if (FolderPermissionAction.EXECUTE.equals(other.getAction()) || FolderPermissionAction.DELETE_HISTORY.equals(other.getAction())) {
            if (this.mNameTargetSpec == null || other.mNameTargetSpec == null) {
                return false;
            }
            return this.mNameTargetSpec.implies(other.mNameTargetSpec);
        }
        return true;
    }

    private boolean checkImpliesAction(FolderPermission other) {
        return this.getAction().implies(other.getAction());
    }

    protected ROXMessage getMessageMS() {
        String folderName = this.mNameFolderSpec.getFolderName();
        String targetType = null;
        String targetName = null;
        int isTarget = 0;
        if (this.mNameTargetSpec != null) {
            isTarget = 1;
            targetType = this.mNameTargetSpec.getTargetType();
            targetName = this.mNameTargetSpec.getTargetName();
        }
        return new ROXMessage("userdb.FOLDER_PERM", new Object[]{this.getAction().toString(), folderName, new Integer(isTarget), targetType, targetName});
    }

    FolderPermissionAction getAction() {
        return this.mAction;
    }

    public String toDebugString() {
        return "FolderPermission{mAction=" + this.mAction + ", mNameFolderSpec=" + this.mNameFolderSpec + ", mNameTargetSpec=" + this.mNameTargetSpec + "}";
    }

    private static class HostSetTargetSpec
    implements NameTargetSpec {
        public static final HostSetTargetSpec ALL = new HostSetTargetSpec(null){

            public boolean implies(NameTargetSpec inSpec) {
                return true;
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj != null && obj.getClass().equals(this.getClass());
            }

            public String getTargetName() {
                return "*";
            }
        };
        private HostSetID mHostSetID;

        public HostSetTargetSpec(HostSetID inHostSetID) {
            this.mHostSetID = inHostSetID;
        }

        public boolean implies(NameTargetSpec inSpec) {
            if (inSpec == null) {
                return false;
            }
            if (HostTargetSpec.ANY.equals(inSpec)) {
                return true;
            }
            if (HostTargetSpec.ALL.equals(inSpec) || ALL.equals(inSpec)) {
                return false;
            }
            if (inSpec instanceof HostTargetSpec) {
                HostID hostID = ((HostTargetSpec)inSpec).getHostID();
                try {
                    return this.mHostSetID.contains(hostID);
                }
                catch (PersistenceManagerException e) {
                    this.flagHostResolutionError(e);
                }
                catch (RPCException e) {
                    this.flagHostResolutionError(e);
                }
            }
            if (inSpec instanceof HostSetTargetSpec) {
                HostSetID hostsetID = ((HostSetTargetSpec)inSpec).mHostSetID;
                try {
                    return this.mHostSetID.equals(hostsetID) || this.mHostSetID.containsAll(hostsetID);
                }
                catch (PersistenceManagerException e) {
                    this.flagHostResolutionError(e);
                }
                catch (RPCException e) {
                    this.flagHostResolutionError(e);
                }
            }
            return false;
        }

        public String getTargetType() {
            try {
                return PersistenceManager.getObjectName(Class.forName("com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImpl")).getMessageString();
            }
            catch (ClassNotFoundException e) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Error fetching permission text", e, this);
                }
                return "hostset";
            }
        }

        public String getTargetName() {
            block4: {
                try {
                    return this.mHostSetID.getByIDQuery().selectSummaryView().getName();
                }
                catch (RPCException e) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error fetching permission text", e, this);
                    }
                }
                catch (PersistenceManagerException e) {
                    if (!Logger.isErrorEnabled(this)) break block4;
                    Logger.error("Error fetching permission text", e, this);
                }
            }
            return this.mHostSetID.toString();
        }

        private void flagHostResolutionError(RaplixException inE) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("unable to determine hostset membership", inE, this);
            }
        }

        public String toString() {
            return "HostSetTargetSpec{mHostSetID=" + this.mHostSetID + "}";
        }
    }

    private static class HostTargetSpec
    implements NameTargetSpec {
        public static final HostTargetSpec ALL = new HostTargetSpec(null){

            public boolean implies(NameTargetSpec inSpec) {
                return true;
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj != null && obj.getClass().equals(this.getClass());
            }

            public String getTargetName() {
                return "*";
            }
        };
        public static final HostTargetSpec ANY = new HostTargetSpec(null){

            public boolean implies(NameTargetSpec inSpec) {
                return false;
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj != null && obj.getClass().equals(this.getClass());
            }

            public String getTargetName() {
                return "-";
            }
        };
        private HostID mHostID;

        public HostTargetSpec(HostID inHostID) {
            this.mHostID = inHostID;
        }

        public boolean implies(NameTargetSpec inSpec) {
            if (inSpec == null || !(inSpec instanceof HostTargetSpec)) {
                return false;
            }
            return ANY.equals(inSpec) || this.mHostID.equals(((HostTargetSpec)inSpec).mHostID);
        }

        public String getTargetType() {
            try {
                return PersistenceManager.getObjectName(Class.forName("com.raplix.rolloutexpress.systemmodel.hostdbx.HostImpl")).getMessageString();
            }
            catch (ClassNotFoundException e) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Error fetching permission text", e, this);
                }
                return "host";
            }
        }

        public String getTargetName() {
            block4: {
                try {
                    return this.mHostID.getByIDQuery().selectSummaryView().getName();
                }
                catch (RPCException e) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error fetching permission text", e, this);
                    }
                }
                catch (PersistenceManagerException e) {
                    if (!Logger.isErrorEnabled(this)) break block4;
                    Logger.error("Error fetching permission text", e, this);
                }
            }
            return this.mHostID.toString();
        }

        HostID getHostID() {
            return this.mHostID;
        }

        public String toString() {
            return "HostTargetSpec{mHostID=" + this.mHostID + "}";
        }
    }

    private static interface NameTargetSpec
    extends RPCSerializable {
        public boolean implies(NameTargetSpec var1);

        public String getTargetType();

        public String getTargetName();
    }

    static class NameFolderSpec
    implements RPCSerializable {
        public static final NameFolderSpec AllFolders = new NameFolderSpec(null){

            public boolean implies(NameFolderSpec nfID) {
                return true;
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj != null && obj.getClass().equals(this.getClass());
            }

            String getFolderName() {
                return "*";
            }
        };
        public static final NameFolderSpec AnyFolder = new NameFolderSpec(null){

            public boolean implies(NameFolderSpec nfID) {
                return false;
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj != null && obj.getClass().equals(this.getClass());
            }

            String getFolderName() {
                return "-";
            }
        };
        private FolderID mFolderID;

        public NameFolderSpec(FolderID inFolderID) {
            this.mFolderID = inFolderID;
        }

        public boolean implies(NameFolderSpec nfID) {
            return AnyFolder.equals(nfID) || this.mFolderID.equals(nfID.mFolderID);
        }

        FolderID getFolderID() {
            return this.mFolderID;
        }

        String getFolderName() {
            return this.mFolderID.getFullPathString();
        }

        public String toString() {
            return "NameFolderSpec{mFolderID=" + this.mFolderID + "}";
        }
    }
}

