/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionItem;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class FolderAccessData
implements RPCSerializable,
Cloneable {
    private GroupID mOwnerID;
    private Hashtable mACLs = new Hashtable();

    public GroupID getOwnerID() {
        return this.mOwnerID;
    }

    public void setOwnerID(GroupID inOwnerID) {
        if (inOwnerID == null) {
            throw new NullPointerException();
        }
        this.mOwnerID = inOwnerID;
    }

    public FolderPermissionItem addACL(FolderPermissionItem inItem) {
        if (inItem == null || inItem.getGroupID() == null) {
            throw new NullPointerException();
        }
        return (FolderPermissionItem)this.mACLs.put(inItem.getGroupID(), inItem.clone());
    }

    public FolderPermissionItem getACL(GroupID inGroupID) {
        if (inGroupID == null) {
            throw new NullPointerException();
        }
        FolderPermissionItem item = (FolderPermissionItem)this.mACLs.get(inGroupID);
        return (FolderPermissionItem)(item == null ? null : item.clone());
    }

    public FolderPermissionItem removeACL(GroupID inGroupID) {
        return (FolderPermissionItem)this.mACLs.remove(inGroupID);
    }

    public FolderPermissionItem[] getAllACLs() {
        FolderPermissionItem[] value = this.mACLs.values().toArray(new FolderPermissionItem[this.mACLs.size()]);
        for (int i = 0; i < value.length; ++i) {
            value[i] = (FolderPermissionItem)value[i].clone();
        }
        return value;
    }

    public void clearACLs() {
        this.mACLs.clear();
    }

    public GroupIDSet getACLGroups() {
        return new GroupIDSet(this.mACLs.keySet());
    }

    public Object clone() {
        try {
            FolderAccessData returnValue = (FolderAccessData)super.clone();
            returnValue.mACLs = new Hashtable(this.mACLs.size());
            returnValue.addAllACLs(this.getAllACLs());
            return returnValue;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    private void addAllACLs(FolderPermissionItem[] inAllACLs) {
        for (int i = 0; i < inAllACLs.length; ++i) {
            this.addACL(inAllACLs[i]);
        }
    }

    public boolean equalsIgnoreEmptyItems(FolderAccessData inData) {
        if (this.mOwnerID == null ? inData.mOwnerID == null : this.mOwnerID.equals(inData.mOwnerID)) {
            return this.getAllNonEmptyItems().equals(inData.getAllNonEmptyItems());
        }
        return false;
    }

    private HashSet getAllNonEmptyItems() {
        HashSet<FolderPermissionItem> thisSet = new HashSet<FolderPermissionItem>();
        Iterator values = this.mACLs.values().iterator();
        while (values.hasNext()) {
            FolderPermissionItem item = (FolderPermissionItem)values.next();
            if (item.isEmpty()) continue;
            thisSet.add(item);
        }
        return thisSet;
    }

    public int hashCode() {
        int returnValue = this.mACLs.hashCode();
        if (this.mOwnerID != null) {
            returnValue ^= this.mOwnerID.hashCode();
        }
        return returnValue;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FolderAccessData)) {
            return false;
        }
        FolderAccessData oData = (FolderAccessData)obj;
        return (this.mOwnerID == null ? oData.mOwnerID == null : this.mOwnerID.equals(oData.mOwnerID)) && this.mACLs.equals(oData.mACLs);
    }

    public String toString() {
        return "FolderAccessData{mOwnerID=" + this.mOwnerID + ", mACLs=" + this.mACLs + "}";
    }
}

