/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetUpdateListener;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateNotAcceptedException;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionAction;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionItem;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionListener;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionNameElements;
import com.raplix.rolloutexpress.systemmodel.userdb.GrantedPermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentPermissionData;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserFolderPermissions;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.Util;
import com.raplix.util.enum.NoSuchEnumException;
import com.raplix.util.logger.Logger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FolderAccessControlManagerImpl
implements FolderAccessControlManager,
HostSetUpdateListener {
    private UserDBSubsystem mSubsystem;
    private LinkedList mListeners = new LinkedList();

    public FolderAccessControlManagerImpl(UserDBSubsystem inSubsystem) {
        this.mSubsystem = inSubsystem;
    }

    public void save(FolderID inFolderID, FolderAccessData inFolderAccessData, boolean isNew) throws PersistenceManagerException, UserDBException {
        boolean suppliedPermsAreDifferent;
        RemotePermission[] dbPerms = this.getPermissionsFor(inFolderID);
        FolderAccessData currentPerms = (FolderAccessData)this.toFolderAccessDataMap(dbPerms).get(inFolderID);
        FolderID parentID = this.getFolderParentID(inFolderID);
        if (isNew) {
            if (currentPerms != null) {
                throw new UserDBException("userdb.FOLDER_PERM_EXIST", inFolderID.toString());
            }
            dbPerms = this.getPermissionsFor(parentID);
            currentPerms = (FolderAccessData)this.toFolderAccessDataMap(dbPerms).get(parentID);
            AccessController.checkPermission(new FolderPermission(parentID, "write"));
        } else if (currentPerms == null) {
            throw new UserDBException("userdb.FOLDER_PERM_NOT_FOUND", inFolderID.toString());
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("CurrentPerms:" + currentPerms + ":supplied:" + inFolderAccessData, this);
        }
        boolean bl = suppliedPermsAreDifferent = !currentPerms.equalsIgnoreEmptyItems(inFolderAccessData);
        if (isNew) {
            if (suppliedPermsAreDifferent) {
                AccessController.checkPermission(new FolderPermission(parentID, "owner"));
                this.createFolderPermissions(inFolderID, inFolderAccessData);
            } else {
                this.createFolderPermissions(inFolderID, currentPerms);
            }
        } else if (suppliedPermsAreDifferent) {
            AccessController.checkPermission(new FolderPermission(inFolderID, "owner"));
            this.updateFolderPermissions(inFolderID, inFolderAccessData, dbPerms);
        }
    }

    protected FolderID getFolderParentID(FolderID inFolderID) throws UserDBException, PersistenceManagerException {
        try {
            return inFolderID.getByIDQuery().selectSummaryView().getParentFolderID();
        }
        catch (RPCException e) {
            throw new UserDBException(e);
        }
    }

    public FolderAccessData get(FolderID inFolderID) throws PersistenceManagerException, UserDBException {
        FolderAccessData accessData = this.getFolderAccessData(inFolderID);
        if (accessData == null) {
            throw new UserDBException("userdb.FOLDER_PERM_NOT_FOUND", inFolderID.toString());
        }
        return accessData;
    }

    public Map get(FolderIDSet inFolderIDSet) throws PersistenceManagerException, UserDBException {
        RemotePermission[] perms = this.getPermissionsFor(inFolderIDSet);
        Map map = this.toFolderAccessDataMap(perms);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("MAP:" + map, this);
        }
        return map;
    }

    public void delete(final FolderID inFolderID) throws PersistenceManagerException, UserDBException {
        AccessController.checkPermission(new FolderPermission(this.getFolderParentID(inFolderID), "write"));
        PersistenceManager.getInstance().getTransactionManager().transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object run() throws Exception {
                            GrantedPermissionTable.DEFAULT.deleteByPermPattern(FolderAccessControlManagerImpl.access$100(1.access$000(this.this$1)), (class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? (class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission = FolderAccessControlManagerImpl.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission")) : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName(), null);
                            PermissionTable.DEFAULT.deleteByPermPattern(FolderAccessControlManagerImpl.access$100(1.access$000(this.this$1)), (class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? (class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission = FolderAccessControlManagerImpl.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission")) : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName(), null);
                            FolderAccessControlManagerImpl.access$300(1.access$200(this.this$1), 1.access$000(this.this$1));
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    return FolderAccessControlManagerImpl.this.handlePrivilegedActionException(e);
                }
            }

            static /* synthetic */ FolderID access$000(1 x0) {
                return x0.inFolderID;
            }

            static /* synthetic */ FolderAccessControlManagerImpl access$200(1 x0) {
                return x0.FolderAccessControlManagerImpl.this;
            }
        });
    }

    public UserFolderPermissions getUserPermissions(FolderID inFolderID, UserID inUserID) throws PersistenceManagerException, UserDBException {
        Permission[] perms = null;
        try {
            perms = this.mSubsystem.getLocalUserDBAdmin().getPermissionManager().getPermissionsByUser(inUserID);
        }
        catch (RPCException e) {
            throw new UserDBException(e);
        }
        FolderPermissionAction action = null;
        boolean isOwner = false;
        boolean isWrite = false;
        boolean isAutorun = false;
        boolean isCheckin = false;
        boolean isExecuteAll = false;
        boolean isDeleteHistory = false;
        HostSetIDSet executeHostsetIDSet = new HostSetIDSet();
        HostSetIDSet delHistoryHostsetIDSet = new HostSetIDSet();
        FolderPermission.NameFolderSpec thisFolderSpec = FolderPermission.getFolderSpec(new FolderPermissionNameElements(inFolderID));
        for (int i = 0; i < perms.length; ++i) {
            FolderPermissionNameElements permName;
            Permission perm = perms[i];
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Handling perm:" + perm.getName(), this);
            }
            if (!(class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? FolderAccessControlManagerImpl.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission") : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName().equals(perm.getClassName()) || !FolderPermission.getFolderSpec(permName = new FolderPermissionNameElements(perm.getName())).implies(thisFolderSpec)) continue;
            action = FolderPermissionAction.FACTORY.get(perm.getActions());
            if (action.implies(FolderPermissionAction.EXECUTE)) {
                if (permName.isTargetPerm() && permName.isTargetHostSet()) {
                    if (permName.isHostSetAll()) {
                        isExecuteAll = true;
                    } else {
                        executeHostsetIDSet.add(permName.getHostSetID());
                    }
                } else if (Logger.isErrorEnabled(this)) {
                    Logger.error("Unrecognized permission name:" + perm.getName(), this);
                }
            }
            if (action.implies(FolderPermissionAction.DELETE_HISTORY)) {
                if (permName.isTargetPerm() && permName.isTargetHostSet()) {
                    if (permName.isHostSetAll()) {
                        isDeleteHistory = true;
                    } else {
                        delHistoryHostsetIDSet.add(permName.getHostSetID());
                    }
                } else if (Logger.isErrorEnabled(this)) {
                    Logger.error("Unrecognized permission name:" + perm.getName(), this);
                }
            }
            if (!isOwner) {
                isOwner = action.implies(FolderPermissionAction.OWNER);
            }
            if (!isWrite) {
                isWrite = action.implies(FolderPermissionAction.WRITE);
            }
            if (!isAutorun) {
                isAutorun = action.implies(FolderPermissionAction.AUTORUN);
            }
            if (isCheckin) continue;
            isCheckin = action.implies(FolderPermissionAction.CHECKIN);
        }
        if (isExecuteAll) {
            executeHostsetIDSet.clear();
        }
        if (isDeleteHistory) {
            delHistoryHostsetIDSet.clear();
        }
        UserFolderPermissions userFolderPermissions = new UserFolderPermissions(inFolderID, inUserID, isWrite, isAutorun, isCheckin, isOwner, executeHostsetIDSet, isExecuteAll, delHistoryHostsetIDSet, isDeleteHistory);
        return userFolderPermissions;
    }

    public UserFolderPermissions getUserPermissions(FolderID inFolderID) throws PersistenceManagerException, UserDBException {
        try {
            UserID currentUserID = this.mSubsystem.getLocalSessionManager().getCurrentUserID();
            if (currentUserID == null) {
                throw new UserDBException("userdb.FPERM_NO_CURRENT_USER");
            }
            return this.getUserPermissions(inFolderID, currentUserID);
        }
        catch (RPCException e) {
            throw new UserDBException(e);
        }
    }

    void addListener(FolderPermissionListener inListener) {
        this.mListeners.add(inListener);
    }

    void removeListener(FolderPermissionListener inListener) {
        this.mListeners.remove(inListener);
    }

    private void notifyCreate(FolderID inFolderID) {
        Iterator iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            FolderPermissionListener folderPermissionListener = (FolderPermissionListener)iterator.next();
            folderPermissionListener.folderPermsCreated(inFolderID);
        }
    }

    private void notifyUpdate(FolderID inFolderID) {
        Iterator iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            FolderPermissionListener folderPermissionListener = (FolderPermissionListener)iterator.next();
            folderPermissionListener.folderPermsUpdated(inFolderID);
        }
    }

    private void notifyDelete(FolderID inFolderID) {
        Iterator iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            FolderPermissionListener folderPermissionListener = (FolderPermissionListener)iterator.next();
            folderPermissionListener.folderPermsDeleted(inFolderID);
        }
    }

    private RemotePermission[] getPermissionsFor(FolderID inFolderID) throws UserDBException {
        FolderIDSet idSet = new FolderIDSet();
        idSet.add(inFolderID);
        return this.getPermissionsFor(idSet);
    }

    private RemotePermission[] getPermissionsFor(FolderIDSet inFolderIDSet) throws UserDBException {
        FolderID[] folderIDs = inFolderIDSet.toIDArray();
        String[] namePatterns = new String[folderIDs.length];
        for (int i = 0; i < folderIDs.length; ++i) {
            namePatterns[i] = FolderAccessControlManagerImpl.getNamePattern(folderIDs[i]);
        }
        RemotePermission[] perms = PermissionTable.DEFAULT.executeSelectByMultipleNames(namePatterns, FolderPermission.class.getName());
        return perms;
    }

    private FolderAccessData getFolderAccessData(FolderID inFolderID) throws PersistenceManagerException, UserDBException {
        FolderIDSet set = new FolderIDSet();
        set.add(inFolderID);
        Map map = this.get(set);
        FolderAccessData accessData = (FolderAccessData)map.get(inFolderID);
        return accessData;
    }

    private Map toFolderAccessDataMap(RemotePermission[] inPerms) throws PersistenceManagerException, UserDBException {
        PermissionID[] pIDs = new PermissionID[inPerms.length];
        for (int i = 0; i < pIDs.length; ++i) {
            pIDs[i] = inPerms[i].getPermissionID();
        }
        HashMap groupIDMap = GrantedPermissionTable.DEFAULT.getGrantedGroups(pIDs);
        FolderAccessData data = null;
        HashMap<FolderID, FolderAccessData> folderPerms = new HashMap<FolderID, FolderAccessData>();
        for (int i = 0; i < inPerms.length; ++i) {
            RemotePermission perm = inPerms[i];
            FolderPermissionNameElements permName = new FolderPermissionNameElements(perm.getName());
            FolderID permFolderID = permName.getFolderID();
            if (permFolderID == null) continue;
            data = (FolderAccessData)folderPerms.get(permFolderID);
            if (data == null) {
                data = new FolderAccessData();
                folderPerms.put(permFolderID, data);
            }
            GroupIDSet grantedGroups = (GroupIDSet)groupIDMap.get(perm.getPermissionID());
            Object[] groups = null;
            if (grantedGroups == null) continue;
            groups = grantedGroups.toIDArray();
            FolderPermissionAction action = null;
            try {
                action = FolderPermissionAction.FACTORY.get(perm.getActions());
            }
            catch (NoSuchEnumException e) {
                throw new UserDBException("userdb.ILLEGAL_FPERM_ACTION", perm.getActions());
            }
            if (FolderPermissionAction.OWNER.equals(action)) {
                if (groups.length != 1) {
                    throw new UserDBException(new ROXMessage("userdb.FOLDER_PERM_ILLEGAL_OWNER", permFolderID.toString(), Util.getStringFromArray(groups, ",")), null, 1);
                }
                data.setOwnerID(groups[0]);
                continue;
            }
            if (FolderPermissionAction.WRITE.equals(action) || FolderPermissionAction.CHECKIN.equals(action) || FolderPermissionAction.AUTORUN.equals(action) || FolderPermissionAction.EXECUTE.equals(action) || FolderPermissionAction.DELETE_HISTORY.equals(action)) {
                FolderAccessControlManagerImpl.setFolderPermissionItem(data, (GroupID[])groups, action, permName);
                continue;
            }
            throw new UserDBException("userdb.ILLEGAL_FPERM_ACTION", action.toString());
        }
        return folderPerms;
    }

    private void updateFolderPermissions(final FolderID inFolderID, FolderAccessData inSuppliedPerms, RemotePermission[] inCurrentPerms) throws PersistenceManagerException, UserDBException {
        final HashMap saveMap = this.toPermissionSaveMap(inFolderID, inSuppliedPerms, inCurrentPerms);
        PersistenceManager.getInstance().getTransactionManager().transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object run() throws Exception {
                            FolderAccessControlManagerImpl.access$700(3.access$600(this.this$1), 3.access$500(this.this$1));
                            GrantedPermissionTable.DEFAULT.deleteByPermPattern(FolderAccessControlManagerImpl.access$100(3.access$800(this.this$1)), (class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? (class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission = FolderAccessControlManagerImpl.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission")) : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName(), null);
                            FolderAccessControlManagerImpl.access$900(3.access$600(this.this$1), 3.access$500(this.this$1));
                            FolderAccessControlManagerImpl.access$1000(3.access$600(this.this$1), 3.access$800(this.this$1));
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    return FolderAccessControlManagerImpl.this.handlePrivilegedActionException(e);
                }
            }

            static /* synthetic */ HashMap access$500(3 x0) {
                return x0.saveMap;
            }

            static /* synthetic */ FolderAccessControlManagerImpl access$600(3 x0) {
                return x0.FolderAccessControlManagerImpl.this;
            }

            static /* synthetic */ FolderID access$800(3 x0) {
                return x0.inFolderID;
            }
        });
    }

    private void createFolderPermissions(final FolderID inFolderID, FolderAccessData inFolderAccessData) throws PersistenceManagerException, UserDBException {
        final HashMap saveMap = this.toPermissionSaveMap(inFolderID, inFolderAccessData, null);
        PersistenceManager.getInstance().getTransactionManager().transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object run() throws Exception {
                            FolderAccessControlManagerImpl.access$700(5.access$1200(this.this$1), 5.access$1100(this.this$1));
                            FolderAccessControlManagerImpl.access$900(5.access$1200(this.this$1), 5.access$1100(this.this$1));
                            FolderAccessControlManagerImpl.access$1400(5.access$1200(this.this$1), 5.access$1300(this.this$1));
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    return FolderAccessControlManagerImpl.this.handlePrivilegedActionException(e);
                }
            }

            static /* synthetic */ HashMap access$1100(5 x0) {
                return x0.saveMap;
            }

            static /* synthetic */ FolderAccessControlManagerImpl access$1200(5 x0) {
                return x0.FolderAccessControlManagerImpl.this;
            }

            static /* synthetic */ FolderID access$1300(5 x0) {
                return x0.inFolderID;
            }
        });
    }

    private Object handlePrivilegedActionException(PrivilegedActionException e) throws PersistenceManagerException {
        Throwable ex = e.getCause();
        if (ex instanceof PersistenceManagerException) {
            throw (PersistenceManagerException)ex;
        }
        throw new RuntimeException(ex);
    }

    private void createPermissions(HashMap saveMap) throws PersistenceManagerException {
        Set perms = saveMap.keySet();
        Iterator iterator = perms.iterator();
        while (iterator.hasNext()) {
            PermissionKey permissionKey = (PermissionKey)iterator.next();
            PermissionAndGroup pag = (PermissionAndGroup)saveMap.get(permissionKey);
            if (pag.getPermissionID() != null) continue;
            PersistentPermissionData pData = new PersistentPermissionData(null);
            pData.setClassName((class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? FolderAccessControlManagerImpl.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission") : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName());
            pData.setName(pag.getName());
            pData.setActions(pag.getAction());
            pData.save();
            pag.setPermissionID(pData.getPermissionID());
        }
    }

    private void insertGrants(HashMap inSaveMap) throws PersistenceManagerException {
        Iterator iterator = inSaveMap.values().iterator();
        while (iterator.hasNext()) {
            PermissionAndGroup pag = (PermissionAndGroup)iterator.next();
            GroupID[] groupIDs = pag.getGroupIDs();
            if (groupIDs.length <= 0) continue;
            GrantedPermissionTable.DEFAULT.insert(groupIDs, pag.getPermissionID());
        }
    }

    private HashMap toPermissionSaveMap(FolderID inFolderID, FolderAccessData inData, RemotePermission[] inDBPerms) throws PersistenceManagerException, UserDBException {
        HashMap perms = new HashMap();
        String folderPermName = FolderPermissionNameElements.getName(inFolderID);
        try {
            this.addPermission(perms, folderPermName, "owner", inData.getOwnerID(), true);
            this.addPermission(perms, folderPermName, "write", null, false);
            this.addPermission(perms, folderPermName, "checkin", null, false);
            this.addPermission(perms, folderPermName, "autorun", null, false);
            GroupID[] groupIDs = inData.getACLGroups().toIDArray();
            for (int i = 0; i < groupIDs.length; ++i) {
                GroupID groupID = groupIDs[i];
                FolderPermissionItem item = inData.getACL(groupID);
                this.addPermission(perms, folderPermName, "write", groupID, item.isWrite());
                this.addPermission(perms, folderPermName, "checkin", groupID, !item.isWrite() && item.isCheckin());
                this.addPermission(perms, folderPermName, "autorun", groupID, !item.isWrite() && item.isAutoRun());
                if (item.isExecuteAllHosts()) {
                    this.addPermission(perms, FolderPermissionNameElements.getNameAllHostSets(inFolderID), "execute", groupID, true);
                } else if (item.getExecute() != null) {
                    if (!item.getExecute().getByIDQuery().selectExists()) {
                        throw new UserDBException("userdb.HOSTSET_DOESNT_EXIST", item.getExecute().toString());
                    }
                    this.addPermission(perms, FolderPermissionNameElements.getName(inFolderID, item.getExecute()), "execute", groupID, true);
                }
                if (item.isDeleteHistoryAllHosts()) {
                    this.addPermission(perms, FolderPermissionNameElements.getNameAllHostSets(inFolderID), "delete-history", groupID, true);
                    continue;
                }
                if (item.getDeleteHistory() == null) continue;
                if (!item.getDeleteHistory().getByIDQuery().selectExists()) {
                    throw new UserDBException("userdb.HOSTSET_DOESNT_EXIST", item.getDeleteHistory().toString());
                }
                this.addPermission(perms, FolderPermissionNameElements.getName(inFolderID, item.getDeleteHistory()), "delete-history", groupID, true);
            }
        }
        catch (RPCException e) {
            throw new UserDBException(e);
        }
        if (inDBPerms != null) {
            for (int i = 0; i < inDBPerms.length; ++i) {
                RemotePermission dbPerm = inDBPerms[i];
                PermissionAndGroup pag = (PermissionAndGroup)perms.get(new PermissionKey(dbPerm.getName(), dbPerm.getActions()));
                if (pag == null) continue;
                pag.setPermissionID(dbPerm.getPermissionID());
            }
        }
        return perms;
    }

    private void addPermission(HashMap inPerms, String permName, String action, GroupID inGroupID, boolean inAddGroup) {
        PermissionKey key = new PermissionKey(permName, action);
        PermissionAndGroup perm = (PermissionAndGroup)inPerms.get(key);
        if (perm == null) {
            perm = new PermissionAndGroup(permName, action);
            inPerms.put(key, perm);
        }
        if (inAddGroup) {
            perm.addGroup(inGroupID);
        }
    }

    private static String getNamePattern(FolderID inFolderID) {
        return FolderPermissionNameElements.getName(inFolderID) + '%';
    }

    private static void setFolderPermissionItem(FolderAccessData inData, GroupID[] inGroups, FolderPermissionAction inAction, FolderPermissionNameElements inName) {
        for (int i = 0; i < inGroups.length; ++i) {
            GroupID groupID = inGroups[i];
            FolderPermissionItem item = inData.getACL(groupID);
            if (item == null) {
                item = new FolderPermissionItem(groupID);
            }
            if (FolderPermissionAction.WRITE.equals(inAction)) {
                item.setWrite(true);
            } else if (FolderPermissionAction.AUTORUN.equals(inAction)) {
                item.setAutoRun(true);
            } else if (FolderPermissionAction.CHECKIN.equals(inAction)) {
                item.setCheckin(true);
            } else if (FolderPermissionAction.EXECUTE.equals(inAction)) {
                if (inName.isTargetHostSet()) {
                    if (inName.isHostSetAll()) {
                        item.setExecuteAllHosts(true);
                    } else {
                        item.setExecute(inName.getHostSetID());
                    }
                }
            } else if (FolderPermissionAction.DELETE_HISTORY.equals(inAction) && inName.isTargetHostSet()) {
                if (inName.isHostSetAll()) {
                    item.setDeleteHistoryAllHosts(true);
                } else {
                    item.setDeleteHistory(inName.getHostSetID());
                }
            }
            inData.addACL(item);
        }
    }

    public void hostSetAdded(HostSetID hostSetID) {
    }

    public void hostSetDeleted(HostSetID hostSetID) throws UpdateNotAcceptedException {
        String hostSetName;
        block8: {
            hostSetName = hostSetID.toString();
            try {
                hostSetName = hostSetID.getByIDQuery().selectSummaryView().getName();
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) break block8;
                Logger.error("Unable to resolve hostset name", e, this);
            }
        }
        try {
            PermissionTable pTable = new PermissionTable("p");
            GrantedPermissionTable gTable = new GrantedPermissionTable("g");
            final String namePattern = "folder:%:hostset:" + hostSetID;
            Permission[] perms = pTable.executeSelectByCriteria(namePattern, FolderPermission.class.getName(), null, GrantedPermissionTable.exists(gTable.selectGroupsByPermission(pTable.ID)));
            if (perms != null && perms.length > 0) {
                FolderIDSet folderIDSet = FolderPermissionNameElements.extractFolderIDs(perms);
                String folderNames = FolderAccessControlManagerImpl.toString(folderIDSet);
                throw new UpdateNotAcceptedException(new ROXMessage("userdb.HOSTSET_HAS_FPERMS_GRANTED", hostSetName, folderNames));
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PermissionTable.DEFAULT.deleteByPermPattern(namePattern, (class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? (class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission = FolderAccessControlManagerImpl.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission")) : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName(), null);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.handlePrivilegedActionException(e);
            }
        }
        catch (PersistenceManagerException e) {
            throw new UpdateNotAcceptedException(new ROXMessage("userdb.ERR_HOSTSET_FPERMS_GRANTED_CHECK", hostSetName), (Throwable)e);
        }
        catch (UserDBException e) {
            throw new UpdateNotAcceptedException(new ROXMessage("userdb.ERR_HOSTSET_FPERMS_GRANTED_CHECK", hostSetName), (Throwable)e);
        }
    }

    static String toString(FolderIDSet inFolderIDSet) {
        String folderNames;
        block4: {
            folderNames = inFolderIDSet.toString();
            try {
                SummaryFolder[] folders = inFolderIDSet.getByIDsQuery().selectSummaryView();
                if (folders != null && folders.length > 0) {
                    StringBuffer sb = new StringBuffer();
                    String sep = ", ";
                    for (int i = 0; i < folders.length; ++i) {
                        sb.append(folders[i].getFullPathString()).append(", ");
                    }
                    sb.setLength(sb.length() - ", ".length());
                    folderNames = sb.toString();
                }
            }
            catch (Exception e) {
                if (!Logger.isWarnEnabled(FolderAccessControlManagerImpl.class)) break block4;
                Logger.warn("Error resolving folderIDs:" + folderNames, e, FolderAccessControlManagerImpl.class);
            }
        }
        return folderNames;
    }

    static /* synthetic */ String access$100(FolderID x0) {
        return FolderAccessControlManagerImpl.getNamePattern(x0);
    }

    static /* synthetic */ void access$300(FolderAccessControlManagerImpl x0, FolderID x1) {
        x0.notifyDelete(x1);
    }

    static /* synthetic */ void access$700(FolderAccessControlManagerImpl x0, HashMap x1) throws PersistenceManagerException {
        x0.createPermissions(x1);
    }

    static /* synthetic */ void access$900(FolderAccessControlManagerImpl x0, HashMap x1) throws PersistenceManagerException {
        x0.insertGrants(x1);
    }

    static /* synthetic */ void access$1000(FolderAccessControlManagerImpl x0, FolderID x1) {
        x0.notifyUpdate(x1);
    }

    static /* synthetic */ void access$1400(FolderAccessControlManagerImpl x0, FolderID x1) {
        x0.notifyCreate(x1);
    }

    private static class PermissionAndGroup {
        private GroupIDSet mGroupIDSet = new GroupIDSet();
        private String mName;
        private String mAction;
        private PermissionID mPermissionID;

        public PermissionAndGroup(String name, String action) {
            this.mName = name;
            this.mAction = action;
        }

        public void addGroup(GroupID gid) {
            this.mGroupIDSet.add(gid);
        }

        public String getName() {
            return this.mName;
        }

        public String getAction() {
            return this.mAction;
        }

        public GroupID[] getGroupIDs() {
            return this.mGroupIDSet.toIDArray();
        }

        public PermissionID getPermissionID() {
            return this.mPermissionID;
        }

        public void setPermissionID(PermissionID inPermissionID) {
            this.mPermissionID = inPermissionID;
        }
    }

    private static class PermissionKey {
        private String mName;
        private String mAction;

        public PermissionKey(String inName, String inAction) {
            this.mName = inName;
            this.mAction = inAction;
        }

        public String getName() {
            return this.mName;
        }

        public String getAction() {
            return this.mAction;
        }

        public int hashCode() {
            return this.mName.hashCode() ^ this.mAction.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof PermissionKey) {
                PermissionKey pk = (PermissionKey)obj;
                return this.mName.equals(pk.mName) && this.mAction.equals(pk.mAction);
            }
            return false;
        }
    }
}

