/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.systemmodel.userdb.HashException;
import com.raplix.rolloutexpress.systemmodel.userdb.HashedString;
import com.raplix.rolloutexpress.systemmodel.userdb.StringHasher;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestStringHasher
implements StringHasher {
    private static final String MSG_UNKNOWN_ENCODING = "userdb.dsh.UNKNOWN_ENCODING";
    private static final String MSG_INVALID_ALGORITHM = "userdb.dsh.INVALID_ALGORITHM";
    private static final ThreadLocal sMessageDigest = new ThreadLocal();
    public static final String DEFAULT_ALGORITHM = "MD5";
    private String mAlgorithm;
    private static final String ENCODING = "UTF-8";
    private static final char[] BYTE_TO_CHAR_MAP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestStringHasher(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest.getInstance(algorithm);
        this.mAlgorithm = algorithm;
    }

    public DigestStringHasher() throws NoSuchAlgorithmException {
        this(DEFAULT_ALGORITHM);
    }

    private MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        MessageDigest messageDigest = (MessageDigest)sMessageDigest.get();
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(this.mAlgorithm);
            sMessageDigest.set(messageDigest);
        }
        return messageDigest;
    }

    public HashedString hash(String name, String string) throws HashException {
        try {
            MessageDigest md = this.getMessageDigest();
            StringBuffer buf = new StringBuffer();
            buf.append(name);
            buf.append(":");
            buf.append(string);
            byte[] bytes = md.digest(buf.toString().getBytes(ENCODING));
            return new HashedString(this.bytesToString(bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new HashException(MSG_UNKNOWN_ENCODING, (Throwable)e, ENCODING);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HashException(MSG_INVALID_ALGORITHM, (Throwable)e, this.mAlgorithm);
        }
    }

    private String bytesToString(byte[] bytes) {
        int bytesLength = bytes.length;
        int stringLength = bytesLength * 2;
        StringBuffer buf = new StringBuffer(stringLength);
        for (int j = 0; j < bytesLength; ++j) {
            byte b = bytes[j];
            byte bHigh = (byte)((b & 0xF0) >> 4);
            buf.append(BYTE_TO_CHAR_MAP[bHigh]);
            byte bLow = (byte)(b & 0xF);
            buf.append(BYTE_TO_CHAR_MAP[bLow]);
        }
        String string = buf.toString();
        return string;
    }
}

