/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.userdb.AuthenticationException;
import com.raplix.rolloutexpress.systemmodel.userdb.Authenticator;
import com.raplix.rolloutexpress.systemmodel.userdb.HashedString;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserManager;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBCallback;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.ObjectUtil;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

class DefaultAuthenticator
implements Authenticator {
    private UserDBSubsystem mUserDBSubsystem;

    DefaultAuthenticator(UserDBSubsystem userDBSubsystem) {
        this.setUserDBSubsystem(userDBSubsystem);
    }

    private UserDBSubsystem getUserDBSubsystem() {
        return this.mUserDBSubsystem;
    }

    private void setUserDBSubsystem(UserDBSubsystem userManager) {
        this.mUserDBSubsystem = userManager;
    }

    public UserID authenticate(final String username, String password) throws AuthenticationException {
        User user = null;
        try {
            user = (User)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RPCException, UserDBException {
                    return DefaultAuthenticator.this.getUserDBSubsystem().getLocalUserDBAdmin().getUserManager().getUser(username);
                }
            });
            if (user == null || !user.getActive()) {
                throw new AuthenticationException("userdb.da.UNKNOWN_USER");
            }
            String loginConfig = null;
            LoginConfiguration config = this.mUserDBSubsystem.getLoginConfigForName(user.getLoginConfiguration());
            if (config != null) {
                loginConfig = config.getName();
            }
            if (RemoteUserManager.ADMIN_USERID.equals(user.getUserID())) {
                loginConfig = "internal";
            }
            if (loginConfig == null) {
                throw new AuthenticationException("userdb.da.UNKNOWN_USER");
            }
            boolean doesPasswordMatch = false;
            if (user.getPassword() != null && password != null) {
                HashedString supplied = this.getUserDBSubsystem().hash(username, password);
                doesPasswordMatch = ObjectUtil.equals(user.getPassword(), supplied);
            }
            Handler handler = new Handler(username, password, doesPasswordMatch);
            LoginContext lContext = new LoginContext(loginConfig, handler);
            lContext.login();
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof UserDBException) {
                this.throwLoginFailed("userdb.da.UNKNOWN_USER", e.getCause());
            }
            this.throwLoginFailed("userdb.da.UNEXPECTED_ERROR", e.getCause());
        }
        catch (LoginException e) {
            if (e.getCause() instanceof AuthenticationException) {
                throw (AuthenticationException)e.getCause();
            }
            this.throwLoginFailed("userdb.da.UNKNOWN_USER", e);
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (UserDBException e) {
            this.throwLoginFailed("userdb.da.UNEXPECTED_ERROR", e);
        }
        return user.getUserID();
    }

    private void throwLoginFailed(String messageCode, Throwable cause) throws AuthenticationException {
        if (Logger.isInfoEnabled(this)) {
            Logger.info("LoginFailed:", cause, this);
        }
        throw new AuthenticationException(new ROXMessage(messageCode), cause, 0);
    }

    private static class Handler
    implements CallbackHandler {
        private String mUserName;
        private String mPassword;
        private boolean mPasswordMatch;

        public Handler(String inUserName, String inPassword, boolean inPassMatch) {
            this.mUserName = inUserName;
            this.mPassword = inPassword;
            this.mPasswordMatch = inPassMatch;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback callback = callbacks[i];
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.mUserName);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.mPassword.toCharArray());
                    continue;
                }
                if (callback instanceof UserDBCallback) {
                    ((UserDBCallback)callback).setPasswordMatch(this.mPasswordMatch);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

