/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.util.platform.common.PlatformUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

class CipherServices {
    private static final String SUN_PROVIDER = "com.sun.crypto.provider.SunJCE";
    private static final String IBM_PROVIDER = "com.ibm.crypto.provider.IBMJCE";
    private static int MIN_KEY = 32;
    private static int MAX_KEY = 126;
    private static int KEY_RANGE = MAX_KEY - MIN_KEY + 1;
    private Cipher mCipher;
    private boolean mIsEncrypt;
    private static boolean sProviderInitialized = false;
    private static final byte[] SALT = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
    private static final int ITERATION = 17;
    private static final int RADIX = 36;
    private int mBlockSize;

    public byte[] process(byte[] data) throws UserDBException {
        try {
            return this.mCipher.doFinal(data);
        }
        catch (IllegalStateException e) {
            throw new UserDBException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new UserDBException(e);
        }
        catch (BadPaddingException e) {
            throw new UserDBException(e);
        }
    }

    public String process(String data) throws UserDBException {
        try {
            if (this.mIsEncrypt) {
                return this.toString(this.process(data.getBytes("UTF-8")));
            }
            return new String(this.process(this.toByteArray(data)), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UserDBException(e);
        }
    }

    public String toString(byte[] data) {
        BigInteger big = new BigInteger(data);
        return big.toString(36);
    }

    public byte[] toByteArray(String string) {
        BigInteger big = new BigInteger(string, 36);
        byte[] ret = big.toByteArray();
        if (ret.length % this.mBlockSize != 0) {
            ret = this.pad(ret);
        }
        return ret;
    }

    private byte[] pad(byte[] inBytes) {
        int x;
        int paddingLength = this.mBlockSize - inBytes.length % this.mBlockSize;
        int padding = inBytes[0] < 0 ? -1 : 0;
        byte[] ret = new byte[paddingLength + inBytes.length];
        for (x = 0; x < paddingLength; ++x) {
            ret[x] = padding;
        }
        for (x = 0; x < inBytes.length; ++x) {
            ret[x + paddingLength] = inBytes[x];
        }
        return ret;
    }

    CipherServices(char[] key, boolean isEncrypt) throws UserDBException {
        try {
            CipherServices.init();
            PBEParameterSpec paramSpec = new PBEParameterSpec(SALT, 17);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(CipherServices.normalizeKey(key));
            SecretKey secretKey = null;
            this.mIsEncrypt = isEncrypt;
            int mode = isEncrypt ? 1 : 2;
            secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pbeKeySpec);
            this.mCipher = Cipher.getInstance("PBEWithMD5AndDES");
            this.mCipher.init(mode, (Key)secretKey, paramSpec);
            this.mBlockSize = this.mCipher.getBlockSize();
        }
        catch (InvalidKeySpecException e) {
            throw new UserDBException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UserDBException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new UserDBException(e);
        }
        catch (InvalidKeyException e) {
            throw new UserDBException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new UserDBException(e);
        }
        catch (IllegalAccessException e) {
            throw new UserDBException(e);
        }
        catch (InstantiationException e) {
            throw new UserDBException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UserDBException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (!sProviderInitialized) {
            Class clazz = CipherServices.class;
            synchronized (clazz) {
                if (!sProviderInitialized) {
                    Security.addProvider((Provider)Class.forName(PlatformUtil.isAix() ? IBM_PROVIDER : SUN_PROVIDER).newInstance());
                    sProviderInitialized = true;
                }
            }
        }
    }

    private static char[] normalizeKey(char[] key) {
        StringBuffer buf = new StringBuffer(key.length);
        block0: for (int i = 0; i < key.length; ++i) {
            int ch = key[i];
            if ((ch -= MIN_KEY) < 0) {
                ch += 65535;
            }
            while (true) {
                buf.append((char)(ch % KEY_RANGE + MIN_KEY));
                if (ch < KEY_RANGE) continue block0;
                ch /= KEY_RANGE;
            }
        }
        int bufLen = buf.length();
        char[] result = new char[bufLen];
        buf.getChars(0, bufLen, result, 0);
        return result;
    }
}

