/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.PMSQLException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupServicesImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.Messages;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionServicesImpl;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserServicesImpl;
import com.raplix.util.Validate;
import java.util.HashMap;

class AdminServicesManager
implements Messages {
    private static final String MSG_PERSISTENCE_ERROR = "userdb.PERSISTENCE_ERROR";
    private GroupServicesImpl mGroupServices;
    private PermissionServicesImpl mPermissionServices;
    private UserServicesImpl mUserServices;
    private TransactionManager mTransactionManager;
    private static final HashMap MESSAGE_MAP = AdminServicesManager.initMessageMap();
    private UserDBSubsystem mUserDBSubsystem;
    private static final int MAX_NAME_LENGTH = 32;

    AdminServicesManager(PersistenceManager pm, UserDBSubsystem subsystem) throws ClassMapException {
        this.setUserDBSubsystem(subsystem);
        this.setTransactionManager(pm.getTransactionManager());
        this.setGroupServices(new GroupServicesImpl(this));
        this.setPermissionServices(new PermissionServicesImpl(this));
        this.setUserServices(new UserServicesImpl(this));
    }

    public GroupServicesImpl getGroupServices() {
        return this.mGroupServices;
    }

    private void setGroupServices(GroupServicesImpl groupServices) {
        this.mGroupServices = groupServices;
    }

    public PermissionServicesImpl getPermissionServices() {
        return this.mPermissionServices;
    }

    private void setPermissionServices(PermissionServicesImpl permissionServices) {
        this.mPermissionServices = permissionServices;
    }

    public UserServicesImpl getUserServices() {
        return this.mUserServices;
    }

    private void setUserServices(UserServicesImpl userServices) {
        this.mUserServices = userServices;
    }

    private TransactionManager getTransactionManager() {
        return this.mTransactionManager;
    }

    private void setTransactionManager(TransactionManager transactionManager) {
        this.mTransactionManager = transactionManager;
    }

    public Object transact(Transaction tr) throws UserDBException {
        try {
            return this.getTransactionManager().transact(tr);
        }
        catch (PersistenceManagerException e) {
            throw AdminServicesManager.toUserDBException(e);
        }
    }

    private static HashMap initMessageMap() {
        HashMap<String, ROXMessage> map = new HashMap<String, ROXMessage>();
        map.put("ERROR:  Cannot insert a duplicate key into unique index rox_user_c_username_key\n", MSG_UNIQUE_USERNAME_ERROR);
        map.put("ERROR:  Cannot insert a duplicate key into unique index rox_group_c_name_key\n", MSG_UNIQUE_GROUPNAME_ERROR);
        map.put("ERROR:  ExecReplace: rejected due to CHECK constraint cyclic_groups\n", MSG_CHECK_CYCLICGROUPS_ERROR);
        return map;
    }

    public static UserDBException toUserDBException(Throwable e) {
        String sqlMessage;
        ROXMessage message;
        if (e instanceof PMSQLException && (message = (ROXMessage)MESSAGE_MAP.get(sqlMessage = e.getMessage())) != null) {
            return new UserDBException(message, e, 0);
        }
        return new UserDBException(MSG_PERSISTENCE_ERROR, e);
    }

    public AccessControlManager getAccessControlManager() {
        return this.getUserDBSubsystem().getAccessControlManager();
    }

    public UserDBSubsystem getUserDBSubsystem() {
        return this.mUserDBSubsystem;
    }

    public void setUserDBSubsystem(UserDBSubsystem userDBSubsystem) {
        this.mUserDBSubsystem = userDBSubsystem;
    }

    public boolean isValidName(String name, int maxAts) {
        if (name == null) {
            return false;
        }
        int len = name.length();
        if (len == 0 || len > 32) {
            return false;
        }
        if (!Validate.isValidFirstCharForName(name.charAt(0))) {
            return false;
        }
        int atCount = 0;
        block4: for (int i = 1; i < len; ++i) {
            char ch = name.charAt(i);
            switch (ch) {
                case '@': {
                    if (++atCount <= maxAts) continue block4;
                    return false;
                }
                case ' ': {
                    return false;
                }
                default: {
                    if (Validate.isValidNameChar(ch)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }
}

