/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.userdb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.AccessControlNotAvailable;
import com.raplix.rolloutexpress.net.rpc.AccessControlProvider;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.systemmodel.userdb.ContextedROXPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.RemotePermission;
import com.raplix.rolloutexpress.systemmodel.userdb.Session;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.TaskPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.ArrayEdit;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import com.raplix.util.string.StringUtil;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.sql.SQLPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Vector;
import javax.security.auth.AuthPermission;

public class AccessControlManager {
    private static final String MSG_CONTEXT_ERROR = "userdb.acm.CONTEXT_ERROR";
    private static final String MSG_UNABLE_TO_REGISTER_ROX_PERMISSION = "userdb.acm.UNABLE_TO_REGISTER_ROX_PERMISSION";
    private static final String MSG_NOT_A_PERMISSION = "userdb.acm.NOT_A_PERMISSION";
    private static final String MSG_NOT_A_ROX_PERMISSION = "userdb.acm.NOT_A_ROX_PERMISSION";
    private static final String MSG_NO_SUCH_CLASS = "userdb.acm.NO_SUCH_CLASS";
    private static final String MSG_INVALID_CONSTRUCTOR = "userdb.acm.INVALID_CONSTRUCTOR";
    private static final String MSG_NO_PUBLIC_CONSTRUCTOR = "userdb.acm.NO_PUBLIC_CONSTRUCTOR";
    private static final String MSG_CONSTRUCTION_ERROR = "userdb.acm.CONSTRUCTION_ERROR";
    private static final String MSG_CONTEXT_INFO_REQUIRED = "userdb.acm.CONTEXT_INFO_REQUIRED";
    private Map mContextCache = Collections.synchronizedMap(new HashMap());
    private RPCManager mRPCManager;
    private static final java.security.Permission[] DEFAULT_PERMISSIONS = new java.security.Permission[]{new FilePermission("<<ALL FILES>>", "read,write,execute,delete"), new NetPermission("*"), new PropertyPermission("*", "read,write"), new ReflectPermission("suppressAccessChecks"), new RuntimePermission("*"), new SecurityPermission("*"), new SerializablePermission("*"), new SocketPermission("*", "accept,connect,listen"), new SQLPermission("setLog"), new AuthPermission("createLoginContext.*")};
    private Vector mDefaultPermissions = new Vector();
    private static final Class[] DEFAULT_PARAMS = new Class[]{String.class, String.class};
    private static final Class[] CONTEXT_PARAMS = new Class[]{String.class, String.class, Application.class};
    private static CodeSource INTERNAL_CODESOURCE = new CodeSource(null, (Certificate[])null);
    private SessionTable mSessionTable;
    private PermissionManager mPermissionManager;
    private Application mContext;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager;

    AccessControlManager(SessionTable sessionTable, PermissionManager permissionManager, RPCManager rpcManager, Application context) throws RPCException {
        this.setSessionTable(sessionTable);
        this.setPermissionManager(permissionManager);
        this.setContext(context);
        this.setRPCManager(rpcManager);
        this.initDefaultPermissions();
        if (rpcManager != null) {
            rpcManager.registerAccessControlProvider(new Provider());
        }
    }

    private void setRPCManager(RPCManager rpcManager) {
        this.mRPCManager = rpcManager;
    }

    private RPCManager getRPCManager() {
        return this.mRPCManager;
    }

    private AccessControlNotAvailable newAccessControlNotAvailable(Exception e) {
        if (Logger.isErrorEnabled(this)) {
            Logger.error("error", e, this);
        }
        return new AccessControlNotAvailable(MSG_CONTEXT_ERROR, (Throwable)e);
    }

    private void initDefaultPermissions() {
        for (int i = 0; i < DEFAULT_PERMISSIONS.length; ++i) {
            this.registerDefaultPermission(DEFAULT_PERMISSIONS[i]);
        }
    }

    public void registerDefaultPermission(java.security.Permission perm) {
        if (perm instanceof ROXPermission) {
            String message = AccessControlManager.toText(MSG_UNABLE_TO_REGISTER_ROX_PERMISSION, perm);
            throw new IllegalArgumentException(message);
        }
        this.mDefaultPermissions.addElement(perm);
    }

    private Enumeration getDefaultPermissions() {
        return this.mDefaultPermissions.elements();
    }

    public AccessControlContext getCurrentUserAccessControlContext() throws UserDBException, RPCException {
        return this.getAccessControlContext(this.getCurrentUserID());
    }

    public AccessControlContext getAccessControlContext(UserID userID) throws UserDBException, RPCException {
        AccessControlContext result = (AccessControlContext)this.mContextCache.get(userID);
        if (result == null) {
            result = this.createAccessControlContext(userID);
            this.mContextCache.put(userID, result);
        }
        return result;
    }

    public AccessControlContext addToCurrent(PermissionCollection inCollection) {
        AccessControlContext ctx = new AccessControlContext(AccessController.getContext(), new Combiner(inCollection));
        ctx = (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AccessController.getContext();
            }
        }, ctx);
        return ctx;
    }

    private AccessControlContext createAccessControlContext(UserID userID) throws UserDBException, RPCException {
        Permissions perms = this.getPermissions(userID);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("permissions for " + userID + ":" + perms, this);
        }
        this.addDefaultPermissions(perms);
        ProtectionDomain[] domains = new ProtectionDomain[]{AccessControlManager.getProtectionDomain(perms)};
        return new AccessControlContext(domains);
    }

    private void addDefaultPermissions(Permissions perms) {
        Enumeration defaultPerms = this.getDefaultPermissions();
        while (defaultPerms.hasMoreElements()) {
            perms.add((java.security.Permission)defaultPerms.nextElement());
        }
    }

    private UserID getCurrentUserID() {
        Session session = this.getSessionTable().getCurrentSession();
        if (session != null) {
            return session.getUserID();
        }
        return null;
    }

    private Permissions getPermissions(UserID userID) throws UserDBException, RPCException {
        return AccessControlManager.toJavaPermissions(this.getPermissionsByUser(userID), this.getContext());
    }

    public static Permissions toJavaPermissions(Permission[] perms, Application ctx) {
        Permissions result = new Permissions();
        for (int i = 0; i < perms.length; ++i) {
            try {
                result.add(AccessControlManager.toJavaPermission(perms[i], ctx));
                continue;
            }
            catch (UserDBException e) {
                if (!Logger.isErrorEnabled(class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager == null ? AccessControlManager.class$("com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager") : class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager)) continue;
                Logger.error("unable to create permission", e, class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager == null ? AccessControlManager.class$("com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager") : class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager);
                continue;
            }
            catch (RPCException e) {
                if (!Logger.isErrorEnabled(class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager == null ? AccessControlManager.class$("com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager") : class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager)) continue;
                Logger.error("unable to create permission", e, class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager == null ? AccessControlManager.class$("com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager") : class$com$raplix$rolloutexpress$systemmodel$userdb$AccessControlManager);
            }
        }
        return result;
    }

    private static java.security.Permission toJavaPermission(Permission perm, Application ctx) throws UserDBException, RPCException {
        return AccessControlManager.toJavaPermission(perm.getClassName(), perm.getName(), perm.getActions(), ctx);
    }

    public static java.security.Permission toJavaPermission(String className, String name, String actions, Application ctx) throws UserDBException {
        try {
            Object[] args;
            Class[] params;
            Class<?> pc;
            if (StringUtil.isEmpty(className)) {
                throw new UserDBException(MSG_NOT_A_PERMISSION, className);
            }
            if (!java.security.Permission.class.isAssignableFrom(pc = Class.forName(className))) {
                throw new UserDBException(MSG_NOT_A_PERMISSION, className);
            }
            if (!ROXPermission.class.isAssignableFrom(pc)) {
                throw new UserDBException(MSG_NOT_A_ROX_PERMISSION, className);
            }
            if (ContextedROXPermission.class.isAssignableFrom(pc)) {
                params = CONTEXT_PARAMS;
                args = new Object[]{name, actions, ctx};
            } else {
                params = DEFAULT_PARAMS;
                args = new Object[]{name, actions};
            }
            Object result = pc.getConstructor(params).newInstance(args);
            return (java.security.Permission)result;
        }
        catch (ClassNotFoundException e) {
            throw new UserDBException(MSG_NO_SUCH_CLASS, (Throwable)e, className);
        }
        catch (NoSuchMethodException e) {
            throw new UserDBException(MSG_INVALID_CONSTRUCTOR, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UserDBException(MSG_NO_PUBLIC_CONSTRUCTOR, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new UserDBException(MSG_NO_PUBLIC_CONSTRUCTOR, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new UserDBException(MSG_CONSTRUCTION_ERROR, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UserDBException(MSG_CONSTRUCTION_ERROR, e.getTargetException());
        }
        catch (ExceptionInInitializerError e) {
            throw new UserDBException(MSG_CONSTRUCTION_ERROR, e.getException());
        }
    }

    private Permission[] getPermissionsByUser(UserID userID) throws UserDBException, RPCException {
        Object[] perms = this.getPermissionManager().getPermissionsByUser(userID);
        if (userID != null) {
            RemotePermission taskPerm = (RemotePermission)this.getPermissionManager().newPermission();
            taskPerm.setClassName(TaskPermission.class.getName());
            taskPerm.setName(TaskPermission.getPermissionName(userID));
            perms = (RemotePermission[])ArrayEdit.add(perms, taskPerm);
        }
        return perms;
    }

    private static ProtectionDomain getProtectionDomain(PermissionCollection perms) {
        return new ProtectionDomain(INTERNAL_CODESOURCE, perms);
    }

    private SessionTable getSessionTable() {
        return this.mSessionTable;
    }

    private void setSessionTable(SessionTable sessionTable) {
        this.mSessionTable = sessionTable;
    }

    private PermissionManager getPermissionManager() {
        return this.mPermissionManager;
    }

    private void setPermissionManager(PermissionManager permissionManager) {
        this.mPermissionManager = permissionManager;
    }

    private Application getContext() {
        return this.mContext;
    }

    private void setContext(Application context) {
        this.mContext = context;
    }

    private static String toText(String messageKey, Object arg) {
        return MessageManager.messageAsString(messageKey, new Object[]{arg});
    }

    void invalidate() {
        this.mContextCache.clear();
    }

    private static class Combiner
    implements DomainCombiner {
        private PermissionCollection mPermsToAdd;

        Combiner(PermissionCollection permsToAdd) {
            this.mPermsToAdd = permsToAdd;
            this.mPermsToAdd.setReadOnly();
        }

        public ProtectionDomain[] combine(ProtectionDomain[] current, ProtectionDomain[] assigned) {
            int i;
            if (assigned == null) {
                return current;
            }
            int curLen = current == null ? 0 : current.length;
            int assignedLen = assigned.length;
            ArrayList<ProtectionDomain> results = new ArrayList<ProtectionDomain>(curLen + assignedLen);
            for (i = 0; i < assignedLen; ++i) {
                results.add(this.addPermsToDomain(assigned[i]));
            }
            for (i = 0; i < curLen; ++i) {
                ProtectionDomain cur = current[i];
                boolean alreadyExists = false;
                for (int j = 0; j < assignedLen; ++j) {
                    if (cur != assigned[j]) continue;
                    alreadyExists = true;
                    break;
                }
                if (alreadyExists) continue;
                results.add(cur);
            }
            return results.toArray(new ProtectionDomain[results.size()]);
        }

        private ProtectionDomain addPermsToDomain(ProtectionDomain pd) {
            if (pd.getCodeSource() == INTERNAL_CODESOURCE) {
                Permissions perms = null;
                Enumeration<java.security.Permission> e = this.mPermsToAdd.elements();
                while (e.hasMoreElements()) {
                    java.security.Permission perm = e.nextElement();
                    if (pd.implies(perm)) continue;
                    if (perms == null) {
                        perms = new Permissions();
                    }
                    perms.add(perm);
                }
                if (perms != null) {
                    e = pd.getPermissions().elements();
                    while (e.hasMoreElements()) {
                        perms.add(e.nextElement());
                    }
                    pd = AccessControlManager.getProtectionDomain(perms);
                }
            }
            return pd;
        }
    }

    private class Provider
    implements AccessControlProvider {
        private Provider() {
        }

        public AccessControlContext provideAccessControl(boolean sessionValidationRequired, String invocationTargetName) throws AccessControlNotAvailable {
            try {
                if (sessionValidationRequired && null == AccessControlManager.this.getCurrentUserID() && AccessControlManager.this.getRPCManager() != null && AccessControlManager.this.getRPCManager().getInvokerTransportInfo().isServerSide()) {
                    throw new AccessControlNotAvailable(new ROXMessage(AccessControlManager.MSG_CONTEXT_INFO_REQUIRED, new Object[]{invocationTargetName}));
                }
                return AccessControlManager.this.getCurrentUserAccessControlContext();
            }
            catch (UserDBException e) {
                throw AccessControlManager.this.newAccessControlNotAvailable(e);
            }
            catch (RPCException e) {
                throw AccessControlManager.this.newAccessControlNotAvailable(e);
            }
        }
    }
}

