/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefImplTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import org.w3c.dom.Element;

public class SystemServiceItem
extends PluginItem {
    static final String ELEMENT_NAME = "systemService";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private String mName;
    private String mDescription;

    private SystemServiceItem() {
    }

    SystemServiceItem(Element element) {
        this.setName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setDescription(XMLUtil.getAttribute(element, DESCRIPTION_ATTR));
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        SystemServiceRef systemServiceRef = new SystemServiceRef();
        try {
            SingleSystemServiceRefQuery query = SingleSystemServiceRefQuery.byName(plugin.getName() + Plugin.NAME_SEPARATOR + this.mName);
            systemServiceRef = query.select();
        }
        catch (NoResultsFoundException e) {
            systemServiceRef = new SystemServiceRef(plugin.getID());
        }
        systemServiceRef.setSimpleName(this.mName);
        if (this.mDescription != null) {
            systemServiceRef.setDescription(this.mDescription);
        }
        return systemServiceRef;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(SystemServiceRefImplTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mName;
    }
}

