/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SingleExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SinglePluginQuery;

public class SystemPluginConstants {
    public static final String SYSTEM_PLUGIN_NAME = "system";
    public static final String SYSTEM_FOLDER_PATH = "/system/";
    public static final String AUTOGEN_FOLDER_PATH = "/system/autogen/";
    public static final String MINIPLAN_FOLDER_PATH = "/system/miniplan/";
    public static final String ALL_PLATFORMS_NAME = "system" + Plugin.NAME_SEPARATOR + "any";
    public static final String ALL_AIX_NAME = "system" + Plugin.NAME_SEPARATOR + "AIX - any version";
    public static final String AIX_5_3_NAME = "system" + Plugin.NAME_SEPARATOR + "AIX 5.3";
    public static final String AIX_5_2_NAME = "system" + Plugin.NAME_SEPARATOR + "AIX 5.2";
    public static final String AIX_5_NAME = "system" + Plugin.NAME_SEPARATOR + "AIX 5.1";
    public static final String AIX_4_NAME = "system" + Plugin.NAME_SEPARATOR + "AIX 4.3.3";
    public static final String ALL_SUNOS_NAME = "system" + Plugin.NAME_SEPARATOR + "Solaris - any version";
    public static final String SUNOS_6_NAME = "system" + Plugin.NAME_SEPARATOR + "Solaris 6";
    public static final String SUNOS_7_NAME = "system" + Plugin.NAME_SEPARATOR + "Solaris 7";
    public static final String SUNOS_8_NAME = "system" + Plugin.NAME_SEPARATOR + "Solaris 8";
    public static final String SUNOS_9_NAME = "system" + Plugin.NAME_SEPARATOR + "Solaris 9";
    public static final String SUNOS_10_NAME = "system" + Plugin.NAME_SEPARATOR + "Solaris 10";
    public static final String WIN_2K_NAME = "system" + Plugin.NAME_SEPARATOR + "Windows 2000 Server";
    public static final String WIN_2K3_NAME = "system" + Plugin.NAME_SEPARATOR + "Windows Server 2003";
    public static final String ALL_WIN_NAME = "system" + Plugin.NAME_SEPARATOR + "Windows - any version";
    public static final String ALL_LINUX_NAME = "system" + Plugin.NAME_SEPARATOR + "Linux - any version";
    public static final String ALL_REDHAT_NAME = "system" + Plugin.NAME_SEPARATOR + "Red Hat Linux - any version";
    public static final String REDHAT_ENIGMA_NAME = "system" + Plugin.NAME_SEPARATOR + "Red Hat Linux 7.2";
    public static final String REDHAT_VALHALLA_NAME = "system" + Plugin.NAME_SEPARATOR + "Red Hat Linux 7.3";
    public static final String REDHAT_PSYCHE_NAME = "system" + Plugin.NAME_SEPARATOR + "Red Hat Linux 8.0";
    public static final String REDHAT_PENSACOLA_NAME = "system" + Plugin.NAME_SEPARATOR + "Red Hat Linux Adv Server 2.1";
    public static final String REDHAT_TAROON_NAME = "system" + Plugin.NAME_SEPARATOR + "Red Hat Linux Adv Server 3.0";
    public static final String REDHAT_NAHANT_NAME = "system" + Plugin.NAME_SEPARATOR + "Red Hat Linux Adv Server 4.0";
    public static final String ALL_SUSE_NAME = "system" + Plugin.NAME_SEPARATOR + "SuSE Linux - any version";
    public static final String SUSE_SLES8_NAME = "system" + Plugin.NAME_SEPARATOR + "SuSE Linux Enterprise 8";
    public static final String SUSE_SLES9_NAME = "system" + Plugin.NAME_SEPARATOR + "SuSE Linux Enterprise 9";
    public static final String ALL_HPUX_NAME = "system" + Plugin.NAME_SEPARATOR + "HP-UX - any version";
    public static final String HPUX_11i_v1_NAME = "system" + Plugin.NAME_SEPARATOR + "HP-UX 11i v1";
    public static final String DEFAULT_HOST_TYPE_NAME = "system" + Plugin.NAME_SEPARATOR + "crhost";
    public static final String PREP_HOSTS_PLAN_NAME = "prepHostsPlan";
    private static SystemPluginConstants sInstance;
    public final PluginID SYSTEM_PLUGIN_ID;
    public final FolderID SYSTEM_FOLDER_ID;
    public final FolderID AUTOGEN_FOLDER_ID;
    public final FolderID MINIPLAN_FOLDER_ID;
    public final HostSetID ALL_PLATFORMS_ID;
    public final HostSetID ALL_AIX_ID;
    public final HostSetID AIX_5_3_ID;
    public final HostSetID AIX_5_2_ID;
    public final HostSetID AIX_5_ID;
    public final HostSetID AIX_4_ID;
    public final HostSetID ALL_SUNOS_ID;
    public final HostSetID SUNOS_6_ID;
    public final HostSetID SUNOS_7_ID;
    public final HostSetID SUNOS_8_ID;
    public final HostSetID SUNOS_9_ID;
    public final HostSetID SUNOS_10_ID;
    public final HostSetID WIN_2K_ID;
    public final HostSetID WIN_2K3_ID;
    public final HostSetID ALL_WIN_ID;
    public final HostSetID ALL_LINUX_ID;
    public final HostSetID ALL_REDHAT_ID;
    public final HostSetID REDHAT_ENIGMA_ID;
    public final HostSetID REDHAT_VALHALLA_ID;
    public final HostSetID REDHAT_PSYCHE_ID;
    public final HostSetID REDHAT_PENSACOLA_ID;
    public final HostSetID REDHAT_TAROON_ID;
    public final HostSetID REDHAT_NAHANT_ID;
    public final HostSetID ALL_SUSE_ID;
    public final HostSetID SUSE_SLES8_ID;
    public final HostSetID SUSE_SLES9_ID;
    public final HostSetID ALL_HPUX_ID;
    public final HostSetID HPUX_11i_v1_ID;
    public final HostTypeID DEFAULT_HOST_TYPE_ID;
    public final ExecutionPlanID PREP_HOSTS_PLAN_ID;
    private final HostSetIDSet ALL_PLATFORM_IDS = new HostSetIDSet();

    public static SystemPluginConstants getInstance() throws PersistenceManagerException, RPCException {
        if (sInstance == null) {
            sInstance = new SystemPluginConstants();
        }
        return sInstance;
    }

    private SystemPluginConstants() throws PersistenceManagerException, RPCException {
        ValueHolder values = (ValueHolder)this.transact(new PluginConstantsContextTx());
        this.SYSTEM_PLUGIN_ID = values.SYSTEM_PLUGIN_ID;
        this.SYSTEM_FOLDER_ID = values.SYSTEM_FOLDER_ID;
        this.AUTOGEN_FOLDER_ID = values.AUTOGEN_FOLDER_ID;
        this.MINIPLAN_FOLDER_ID = values.MINIPLAN_FOLDER_ID;
        this.ALL_PLATFORMS_ID = this.newPlatformID(values.ALL_PLATFORMS_ID);
        this.ALL_AIX_ID = this.newPlatformID(values.ALL_AIX_ID);
        this.AIX_5_3_ID = this.newPlatformID(values.AIX_5_3_ID);
        this.AIX_5_2_ID = this.newPlatformID(values.AIX_5_2_ID);
        this.AIX_5_ID = this.newPlatformID(values.AIX_5_ID);
        this.AIX_4_ID = this.newPlatformID(values.AIX_4_ID);
        this.ALL_SUNOS_ID = this.newPlatformID(values.ALL_SUNOS_ID);
        this.SUNOS_6_ID = this.newPlatformID(values.SUNOS_6_ID);
        this.SUNOS_7_ID = this.newPlatformID(values.SUNOS_7_ID);
        this.SUNOS_8_ID = this.newPlatformID(values.SUNOS_8_ID);
        this.SUNOS_9_ID = this.newPlatformID(values.SUNOS_9_ID);
        this.SUNOS_10_ID = this.newPlatformID(values.SUNOS_10_ID);
        this.WIN_2K_ID = this.newPlatformID(values.WIN_2K_ID);
        this.WIN_2K3_ID = this.newPlatformID(values.WIN_2K3_ID);
        this.ALL_WIN_ID = this.newPlatformID(values.ALL_WIN_ID);
        this.ALL_LINUX_ID = this.newPlatformID(values.ALL_LINUX_ID);
        this.ALL_REDHAT_ID = this.newPlatformID(values.ALL_REDHAT_ID);
        this.REDHAT_ENIGMA_ID = this.newPlatformID(values.REDHAT_ENIGMA_ID);
        this.REDHAT_VALHALLA_ID = this.newPlatformID(values.REDHAT_VALHALLA_ID);
        this.REDHAT_PSYCHE_ID = this.newPlatformID(values.REDHAT_PSYCHE_ID);
        this.REDHAT_PENSACOLA_ID = this.newPlatformID(values.REDHAT_PENSACOLA_ID);
        this.REDHAT_TAROON_ID = this.newPlatformID(values.REDHAT_TAROON_ID);
        this.REDHAT_NAHANT_ID = this.newPlatformID(values.REDHAT_NAHANT_ID);
        this.ALL_SUSE_ID = this.newPlatformID(values.ALL_SUSE_ID);
        this.SUSE_SLES8_ID = this.newPlatformID(values.SUSE_SLES8_ID);
        this.SUSE_SLES9_ID = this.newPlatformID(values.SUSE_SLES9_ID);
        this.ALL_HPUX_ID = this.newPlatformID(values.ALL_HPUX_ID);
        this.HPUX_11i_v1_ID = this.newPlatformID(values.HPUX_11i_ID);
        this.DEFAULT_HOST_TYPE_ID = values.DEFAULT_HOST_TYPE_ID;
        this.PREP_HOSTS_PLAN_ID = values.PREP_HOSTS_PLAN_ID;
    }

    private HostSetID newPlatformID(HostSetID id) {
        this.ALL_PLATFORM_IDS.add(id);
        return id;
    }

    public boolean isPlatformID(HostSetID hostSetID) {
        return hostSetID != null && this.ALL_PLATFORM_IDS.contains(hostSetID);
    }

    private Object transact(RPCTransaction tx) throws RPCException, PersistenceManagerException {
        return PersistentServicesInit.transact(tx);
    }

    private static class ValueHolder
    extends PersistContext {
        PluginID SYSTEM_PLUGIN_ID;
        FolderID SYSTEM_FOLDER_ID;
        FolderID AUTOGEN_FOLDER_ID;
        FolderID MINIPLAN_FOLDER_ID;
        HostSetID ALL_PLATFORMS_ID;
        HostSetID ALL_AIX_ID;
        HostSetID AIX_5_3_ID;
        HostSetID AIX_5_2_ID;
        HostSetID AIX_5_ID;
        HostSetID AIX_4_ID;
        HostSetID ALL_SUNOS_ID;
        HostSetID SUNOS_6_ID;
        HostSetID SUNOS_7_ID;
        HostSetID SUNOS_8_ID;
        HostSetID SUNOS_9_ID;
        HostSetID SUNOS_10_ID;
        HostSetID WIN_2K3_ID;
        HostSetID WIN_2K_ID;
        HostSetID ALL_WIN_ID;
        HostSetID ALL_LINUX_ID;
        HostSetID ALL_REDHAT_ID;
        HostSetID REDHAT_ENIGMA_ID;
        HostSetID REDHAT_VALHALLA_ID;
        HostSetID REDHAT_PSYCHE_ID;
        HostSetID REDHAT_PENSACOLA_ID;
        HostSetID REDHAT_TAROON_ID;
        HostSetID REDHAT_NAHANT_ID;
        HostSetID ALL_SUSE_ID;
        HostSetID SUSE_SLES8_ID;
        HostSetID SUSE_SLES9_ID;
        HostSetID ALL_HPUX_ID;
        HostSetID HPUX_11i_ID;
        HostTypeID DEFAULT_HOST_TYPE_ID;
        ExecutionPlanID PREP_HOSTS_PLAN_ID;

        private ValueHolder() {
        }
    }

    private static class PluginConstantsContextTx
    extends RPCTransaction {
        private PluginConstantsContextTx() {
            super(false);
        }

        public PersistContext executeMS() throws PersistenceManagerException {
            ValueHolder values = new ValueHolder();
            try {
                values.SYSTEM_PLUGIN_ID = SinglePluginQuery.byName(SystemPluginConstants.SYSTEM_PLUGIN_NAME).selectSummaryView().getID();
                values.SYSTEM_FOLDER_ID = SingleFolderQuery.byPath(SystemPluginConstants.SYSTEM_FOLDER_PATH).selectSummaryView().getID();
                values.AUTOGEN_FOLDER_ID = SingleFolderQuery.byPath(SystemPluginConstants.AUTOGEN_FOLDER_PATH).selectSummaryView().getID();
                values.MINIPLAN_FOLDER_ID = SingleFolderQuery.byPath(SystemPluginConstants.MINIPLAN_FOLDER_PATH).selectSummaryView().getID();
                values.ALL_PLATFORMS_ID = SingleHostSetQuery.byName(ALL_PLATFORMS_NAME).selectSummaryView().getID();
                values.ALL_AIX_ID = SingleHostSetQuery.byName(ALL_AIX_NAME).selectSummaryView().getID();
                values.AIX_5_3_ID = SingleHostSetQuery.byName(AIX_5_3_NAME).selectSummaryView().getID();
                values.AIX_5_2_ID = SingleHostSetQuery.byName(AIX_5_2_NAME).selectSummaryView().getID();
                values.AIX_5_ID = SingleHostSetQuery.byName(AIX_5_NAME).selectSummaryView().getID();
                values.AIX_4_ID = SingleHostSetQuery.byName(AIX_4_NAME).selectSummaryView().getID();
                values.ALL_SUNOS_ID = SingleHostSetQuery.byName(ALL_SUNOS_NAME).selectSummaryView().getID();
                values.SUNOS_6_ID = SingleHostSetQuery.byName(SUNOS_6_NAME).selectSummaryView().getID();
                values.SUNOS_7_ID = SingleHostSetQuery.byName(SUNOS_7_NAME).selectSummaryView().getID();
                values.SUNOS_8_ID = SingleHostSetQuery.byName(SUNOS_8_NAME).selectSummaryView().getID();
                values.SUNOS_9_ID = SingleHostSetQuery.byName(SUNOS_9_NAME).selectSummaryView().getID();
                values.SUNOS_10_ID = SingleHostSetQuery.byName(SUNOS_10_NAME).selectSummaryView().getID();
                values.WIN_2K_ID = SingleHostSetQuery.byName(WIN_2K_NAME).selectSummaryView().getID();
                values.WIN_2K3_ID = SingleHostSetQuery.byName(WIN_2K3_NAME).selectSummaryView().getID();
                values.ALL_WIN_ID = SingleHostSetQuery.byName(ALL_WIN_NAME).selectSummaryView().getID();
                values.ALL_LINUX_ID = SingleHostSetQuery.byName(ALL_LINUX_NAME).selectSummaryView().getID();
                values.ALL_REDHAT_ID = SingleHostSetQuery.byName(ALL_REDHAT_NAME).selectSummaryView().getID();
                values.REDHAT_ENIGMA_ID = SingleHostSetQuery.byName(REDHAT_ENIGMA_NAME).selectSummaryView().getID();
                values.REDHAT_VALHALLA_ID = SingleHostSetQuery.byName(REDHAT_VALHALLA_NAME).selectSummaryView().getID();
                values.REDHAT_PSYCHE_ID = SingleHostSetQuery.byName(REDHAT_PSYCHE_NAME).selectSummaryView().getID();
                values.REDHAT_PENSACOLA_ID = SingleHostSetQuery.byName(REDHAT_PENSACOLA_NAME).selectSummaryView().getID();
                values.REDHAT_TAROON_ID = SingleHostSetQuery.byName(REDHAT_TAROON_NAME).selectSummaryView().getID();
                values.REDHAT_NAHANT_ID = SingleHostSetQuery.byName(REDHAT_NAHANT_NAME).selectSummaryView().getID();
                values.ALL_SUSE_ID = SingleHostSetQuery.byName(ALL_SUSE_NAME).selectSummaryView().getID();
                values.SUSE_SLES8_ID = SingleHostSetQuery.byName(SUSE_SLES8_NAME).selectSummaryView().getID();
                values.SUSE_SLES9_ID = SingleHostSetQuery.byName(SUSE_SLES9_NAME).selectSummaryView().getID();
                values.ALL_HPUX_ID = SingleHostSetQuery.byName(ALL_HPUX_NAME).selectSummaryView().getID();
                values.HPUX_11i_ID = SingleHostSetQuery.byName(HPUX_11i_v1_NAME).selectSummaryView().getID();
                values.DEFAULT_HOST_TYPE_ID = SingleHostTypeQuery.byName(DEFAULT_HOST_TYPE_NAME).selectSummaryView().getID();
                values.PREP_HOSTS_PLAN_ID = SingleExecutionPlanQuery.byName(values.SYSTEM_FOLDER_ID, SystemPluginConstants.PREP_HOSTS_PLAN_NAME, null).selectSummaryView().getID();
            }
            catch (RPCException e) {
                throw new PersistenceManagerException(e);
            }
            return values;
        }
    }
}

