/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInMode;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceTypeAndOptions;
import com.raplix.rolloutexpress.resource.checkInJob.StatusMonitor;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.CheckInStatus;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Failed;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Succeeded;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.EntryVisitor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.plugindb.ResourceCheckInMode;
import com.raplix.rolloutexpress.systemmodel.plugindb.ResourceType;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.file.FileUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.Replace;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Element;

public class ResourceItem
extends PluginItem {
    private String mName;
    private String mJarPath;
    private boolean mMajorVersion;
    private boolean mConfig;
    private RsrcInfo mResource;
    private ResourceType mType;
    private ResourceCheckInMode mCheckInMode;
    private String mDescriptorJarPath;
    static final String ELEMENT_NAME = "resource";
    private static final String JAR_PATH_ATTR = "jarPath";
    private static final String MAJOR_VERSION_ATTR = "majorVersion";
    private static final String NAME_ATTR = "name";
    private static final String CONFIG_ATTR = "config";
    private static final String TYPE_ATTR = "type";
    private static final String CHECK_IN_MODE_ATTR = "checkInMode";
    private static final String DESCRIPTOR_PATH_ATTR = "descriptorPath";
    private static final ResourceType DEFAULT_TYPE = ResourceType.FILE_TYPE;
    private static final ResourceCheckInMode DEFAULT_CHECK_IN_MODE = ResourceCheckInMode.REPLACE;

    private static void cleanupFile(String fileName, boolean shouldThrow) throws PersistenceManagerException {
        block2: {
            try {
                FileUtil.ensureDeleted(fileName);
            }
            catch (IOException e) {
                if (!shouldThrow) break block2;
                throw PluginException.unexpectedError(e);
            }
        }
    }

    private ResourceItem() {
    }

    ResourceItem(Element element, PluginDescriptor descriptor) throws PluginException {
        this.setDescriptor(descriptor);
        this.setJarPath(XMLUtil.getAttribute(element, JAR_PATH_ATTR));
        this.setMajorVersion(XMLUtil.getBooleanAttribute(element, MAJOR_VERSION_ATTR, false));
        this.setConfig(XMLUtil.getBooleanAttribute(element, CONFIG_ATTR, false));
        this.setName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setType((ResourceType)XMLUtil.getEnumAttribute(element, TYPE_ATTR, ResourceType.FACTORY, DEFAULT_TYPE));
        this.setCheckInMode((ResourceCheckInMode)XMLUtil.getEnumAttribute(element, CHECK_IN_MODE_ATTR, ResourceCheckInMode.FACTORY, DEFAULT_CHECK_IN_MODE));
        String descriptorJarPath = XMLUtil.getAttribute(element, DESCRIPTOR_PATH_ATTR);
        if (descriptorJarPath != null) {
            this.setDescriptorJarPath(descriptorJarPath);
        }
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        if (name != null) {
            this.mName = name;
        }
    }

    RsrcInfo getResource() {
        return this.mResource;
    }

    public InputStream getInputStream() throws PluginException {
        return this.mDescriptor.getEntryInputStream(this.getJarPath());
    }

    private String getJarPath() {
        return this.mJarPath;
    }

    private void setJarPath(String jarPath) throws PluginException {
        this.mDescriptor.getJarEntry(jarPath);
        this.mJarPath = jarPath;
        this.mName = jarPath;
    }

    public boolean getMajorVersion() {
        return this.mMajorVersion;
    }

    private void setMajorVersion(boolean majorVersion) {
        this.mMajorVersion = majorVersion;
    }

    public boolean getConfig() {
        return this.mConfig;
    }

    private void setConfig(boolean config) {
        this.mConfig = config;
    }

    public ResourceType getType() {
        return this.mType;
    }

    private void setType(ResourceType type) {
        this.mType = type;
    }

    public ResourceCheckInMode getCheckInMode() {
        return this.mCheckInMode;
    }

    private void setCheckInMode(ResourceCheckInMode checkInMode) {
        this.mCheckInMode = checkInMode;
    }

    public InputStream getDescriptorInputStream() throws PluginException {
        ByteArrayInputStream descriptorStream = null;
        String descriptorJarPath = this.getDescriptorJarPath();
        if (descriptorJarPath != null) {
            descriptorStream = this.mDescriptor.getEntryInputStream(descriptorJarPath);
        }
        return descriptorStream;
    }

    public String getDescriptorJarPath() {
        return this.mDescriptorJarPath;
    }

    private void setDescriptorJarPath(String descriptorJarPath) throws PluginException {
        this.mDescriptor.getJarEntry(descriptorJarPath);
        this.mDescriptorJarPath = descriptorJarPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException {
        File descriptorFile;
        block22: {
            Application theApp = PluginDBSubsystem.getInstance().getApplication();
            String tempDir = theApp.getTmpDirAbsPath() + File.separator;
            descriptorFile = null;
            File checkInFile = null;
            try {
                try {
                    RsrcInfo rsrcInfo;
                    checkInFile = this.createTempCheckinFile(tempDir);
                    if (this.mType.equals(ResourceType.DIRECTORY_TYPE)) {
                        if (!checkInFile.isDirectory()) {
                            throw PluginException.resourceTypeMismatch(plugin.getName(), plugin.getVersionNumber().getAsString(), this.mName, ResourceType.DIRECTORY_TYPE.toString(), ResourceType.FILE_TYPE.toString());
                        }
                    } else if (checkInFile.isDirectory()) {
                        throw PluginException.resourceTypeMismatch(plugin.getName(), plugin.getVersionNumber().getAsString(), this.mName, ResourceType.FILE_TYPE.toString(), ResourceType.DIRECTORY_TYPE.toString());
                    }
                    PermOptions permOptions = PlatformPermissionFactory.getInstance().getDefaultSysCompOptions();
                    HostID hostID = Host.MASTER_SERVER_ID;
                    if (!hostID.getByIDQuery().selectExists()) {
                        hostID = null;
                    }
                    String typeName = this.getType().getTypeName();
                    CheckInMode checkInMode = this.getCheckInMode().getCheckInMode();
                    String descriptorJarPath = this.getDescriptorJarPath();
                    if (descriptorJarPath != null) {
                        descriptorFile = new File(tempDir + checkInFile.getName() + "_descriptor.xml");
                        FileOutputStream out = null;
                        try {
                            out = new FileOutputStream(descriptorFile.getPath());
                            CopyUtil.copyBinary(this.getDescriptorInputStream(), out);
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                        permOptions.setResourceDescriptorPath(descriptorFile.getPath());
                    }
                    ResourceTypeAndOptions typeAndOptions = ResourceTypeAndOptions.makeCheckIn(typeName, checkInFile, hostID, permOptions, checkInMode);
                    String resourceName = this.mName;
                    ResourceSpec spec = new ResourceSpec(resourceName);
                    VersionedSaveContext context = new VersionedSaveContext();
                    context.setSaveAsNewMajor(this.mMajorVersion);
                    HostSetID platform = SingleHostSetQuery.byName(SystemPluginConstants.ALL_PLATFORMS_NAME).selectSummaryView().getID();
                    StatusMonitor rsrcMon = theApp.getResourceSubsystem().beginCheckIn(typeAndOptions, null, this.mConfig, spec, RedundancyCheckMode.NO_REDUNDANCY_CHECK, context, platform, false, false, plugin.getID());
                    CheckInStatus status = rsrcMon.getStatus();
                    if (status instanceof Failed) {
                        Failed rsrcMonFailed = (Failed)status;
                        throw PluginException.unexpectedError(rsrcMonFailed.getException());
                    }
                    if (!(status instanceof Succeeded)) {
                        throw PluginException.unexpectedError(new RaplixException("rsrc.DATA_LOAD_FAILED", new String[]{resourceName}));
                    }
                    this.mResource = rsrcInfo = ((Succeeded)status).getRsrcInfo();
                    Object var20_25 = null;
                    if (checkInFile == null) break block22;
                }
                catch (IOException e) {
                    throw PluginException.unexpectedError(e);
                }
                catch (ResourceException e) {
                    throw PluginException.unexpectedError(e);
                }
                catch (RPCException e) {
                    throw PluginException.unexpectedError(e);
                }
                catch (UnsupportedSubsystemException e) {
                    throw PluginException.unexpectedError(e);
                }
            }
            catch (Throwable throwable) {
                Object var20_26 = null;
                if (checkInFile != null) {
                    ResourceItem.cleanupFile(checkInFile.getPath(), false);
                }
                if (descriptorFile == null) throw throwable;
                ResourceItem.cleanupFile(descriptorFile.getPath(), false);
                throw throwable;
            }
            ResourceItem.cleanupFile(checkInFile.getPath(), false);
        }
        if (descriptorFile == null) return null;
        ResourceItem.cleanupFile(descriptorFile.getPath(), false);
        return null;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(ResourceTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempCheckinFile(String tempDir) throws PersistenceManagerException {
        String jarPath = this.getJarPath();
        File file = new File(jarPath);
        String rootFileName = tempDir + file.getName();
        boolean success = false;
        try {
            ResourceItem.cleanupFile(rootFileName, true);
            this.mDescriptor.visitAllEntriesUnder(jarPath, new JarEntryVisitor(rootFileName));
            success = true;
        }
        finally {
            if (!success) {
                ResourceItem.cleanupFile(rootFileName, false);
            }
        }
        return new File(rootFileName);
    }

    final class JarEntryVisitor
    implements EntryVisitor {
        private String mRoot;

        JarEntryVisitor(String root) {
            this.mRoot = root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(String entryPath, InputStream in) throws PluginException, IOException {
            String fullSubFileName = this.mRoot + File.separator + entryPath.substring(ResourceItem.this.getJarPath().length());
            fullSubFileName = Replace.replace(fullSubFileName, PluginDescriptor.UNIVERSAL_FILE_SEPARATOR, File.separator);
            File tempFile = new File(fullSubFileName);
            File parentFile = tempFile.getParentFile();
            this.attemptCreateDirs(parentFile);
            if (in != null) {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(tempFile.getPath());
                    CopyUtil.copyBinary(in, out);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            } else {
                this.attemptCreateDirs(tempFile);
            }
        }

        private void attemptCreateDirs(File file) throws PluginException {
            if (!file.isDirectory() && !file.mkdirs()) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Unexpected error while importing plugin.  Unable to create directory: " + file.getAbsolutePath() + " for resource: " + ResourceItem.this.mName, this);
                }
                throw PluginException.unexpectedError();
            }
        }
    }
}

