/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginUIDescriptor
implements RPCSerializable {
    private static final String PLUGIN_UI_SCHEMA = "pluginUI.xsd";
    static final String ELEMENT_NAME = "plugin";
    private static final String MENU_ITEM_ATTR = "menuItem";
    private static final String TOOL_TIP_ATTR = "toolTip";
    private static final String ICON_ELEMENT = "icon";
    private static final String JAR_PATH_ATTR = "jarPath";
    private static final String SCHEMA_VERSION_ATTR = "schemaVersion";
    private String mMenuItem;
    private String mToolTip;
    private String mIcon;
    private String mSchemaVersion;
    private transient PluginDescriptor mParent;

    private PluginUIDescriptor() {
    }

    public PluginUIDescriptor(InputStream in, PluginDescriptor parent) throws SystemModelParseException, PersistenceManagerException {
        this.setParentDescriptor(parent);
        this.readFromXML(new InputSource(in));
    }

    private void readFromXML(InputSource inputSource) throws SystemModelParseException, PersistenceManagerException {
        Element topElement = this.parseInputSource(inputSource, true);
        this.parseGUIAttrs(topElement);
    }

    private Element parseInputSource(InputSource input, boolean reportErrors) throws SystemModelParseException, PersistenceManagerException {
        DOMParser parser = XMLUtil.obtainParser(reportErrors, PLUGIN_UI_SCHEMA, "plg.ui.");
        try {
            parser.parse(input);
            return parser.getDocument().getDocumentElement();
        }
        catch (IOException e) {
            throw PluginDescriptor.newParseError(e, "plg.ui.");
        }
        catch (SAXException e) {
            throw PluginDescriptor.newParseError(e, "plg.ui.");
        }
    }

    private void parseGUIAttrs(Element guiElement) throws PluginException {
        this.mMenuItem = XMLUtil.getAttribute(guiElement, MENU_ITEM_ATTR);
        this.mToolTip = XMLUtil.getAttribute(guiElement, TOOL_TIP_ATTR);
        Element[] list = XMLUtil.getChildren(guiElement, ICON_ELEMENT);
        if (list.length > 0) {
            this.mIcon = XMLUtil.getAttribute(list[0], JAR_PATH_ATTR);
            this.mParent.getJarEntry(this.mIcon);
        }
        this.mSchemaVersion = XMLUtil.getAttribute(guiElement, SCHEMA_VERSION_ATTR);
    }

    void setParentDescriptor(PluginDescriptor descriptor) {
        this.mParent = descriptor;
    }

    public String getMenuItem() {
        return this.mMenuItem;
    }

    public String getToolTip() {
        return this.mToolTip;
    }

    public InputStream getIcon() throws PluginException {
        if (this.mIcon == null) {
            return null;
        }
        return this.mParent.getEntryInputStream(this.mIcon);
    }

    public String getSchemaVersion() {
        return this.mSchemaVersion;
    }
}

