/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermissionBase;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class PluginMemberWritePermission
extends ROXPermissionBase
implements ROXPermission {
    public static final String ALL_PLUGINS_NAME = "*";
    public static final PluginMemberWritePermission ALL_PLUGINS_PERM = new PluginMemberWritePermission("*", null);
    private boolean mIsAllPlugins;

    public PluginMemberWritePermission(PluginID pID) {
        this(pID.toString(), null);
    }

    public PluginMemberWritePermission(String name, String actions) {
        super(name);
        this.setIsAllPlugins(name.equals(ALL_PLUGINS_NAME));
    }

    public boolean implies(Permission perm) {
        if (perm == null || !(perm instanceof PluginMemberWritePermission)) {
            return false;
        }
        if (this.getIsAllPlugins()) {
            return true;
        }
        PluginMemberWritePermission other = (PluginMemberWritePermission)perm;
        return this.getName().equals(other.getName());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other instanceof PluginMemberWritePermission) {
            PluginMemberWritePermission perm = (PluginMemberWritePermission)other;
            return this.getName().equals(perm.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    protected ROXMessage getMessageMS() {
        String pluginName = this.getName();
        if (!this.getIsAllPlugins()) {
            PluginID pID = new PluginID(pluginName);
            try {
                pluginName = pID.getByIDQuery().selectSummaryView().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ROXMessage("plg.NO_PERMISSION", new Object[]{pluginName});
    }

    public PermissionCollection newPermissionCollection() {
        return new Collection();
    }

    private boolean getIsAllPlugins() {
        return this.mIsAllPlugins;
    }

    private void setIsAllPlugins(boolean isAllPlugins) {
        this.mIsAllPlugins = isAllPlugins;
    }

    private static class Collection
    extends PermissionCollection {
        private HashSet mPluginNameSet = new HashSet();
        private Vector mPerms = new Vector();
        private boolean mIsAllPlugins;

        private Collection() {
        }

        public synchronized void add(Permission perm) {
            if (this.isReadOnly()) {
                throw new SecurityException();
            }
            if (perm == null) {
                throw new NullPointerException();
            }
            PluginMemberWritePermission pmwPerm = (PluginMemberWritePermission)perm;
            if (this.getIsAllPlugins()) {
                return;
            }
            if (pmwPerm.getIsAllPlugins()) {
                this.setIsAllPlugins();
            } else if (this.mPluginNameSet.add(pmwPerm.getName())) {
                this.mPerms.add(perm);
            }
        }

        public synchronized boolean implies(Permission perm) {
            if (perm == null || !(perm instanceof PluginMemberWritePermission)) {
                return false;
            }
            if (this.getIsAllPlugins()) {
                return true;
            }
            PluginMemberWritePermission other = (PluginMemberWritePermission)perm;
            return this.mPluginNameSet.contains(other.getName());
        }

        public Enumeration elements() {
            return this.mPerms.elements();
        }

        private boolean getIsAllPlugins() {
            return this.mIsAllPlugins;
        }

        private void setIsAllPlugins() {
            this.mIsAllPlugins = true;
            this.mPluginNameSet.clear();
            this.mPerms.clear();
            this.mPerms.add(ALL_PLUGINS_PERM);
        }
    }
}

