/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.plugindb.ComponentItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.FolderItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.HostSearchItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.HostSetItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.HostTypeItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PlanItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import org.w3c.dom.Element;

public abstract class PluginItem
implements RPCSerializable,
Cloneable {
    protected transient PluginDescriptor mDescriptor;

    static void validatePluginOwnership(PluginImpl plugin, PluginID objectPluginID, String objectType, String objectName) throws PersistenceManagerException {
        if (!plugin.getID().equals(objectPluginID)) {
            throw PluginException.notObjectOwnerError(plugin.getName(), plugin.getVersionNumber().getAsString(), objectType, objectName);
        }
    }

    PluginItem() {
    }

    void setDescriptor(PluginDescriptor descriptor) {
        this.mDescriptor = descriptor;
    }

    static PluginItem readFromXML(Element itemElement, PluginDescriptor descriptor) throws PluginException {
        String itemType = itemElement.getNodeName();
        if (itemType.equals("folder")) {
            return new FolderItem(itemElement);
        }
        if (itemType.equals("hostType")) {
            return new HostTypeItem(itemElement);
        }
        if (itemType.equals("hostSet")) {
            return new HostSetItem(itemElement);
        }
        if (itemType.equals("hostSearch")) {
            return new HostSearchItem(itemElement);
        }
        if (itemType.equals("component")) {
            return new ComponentItem(itemElement, descriptor);
        }
        if (itemType.equals("plan")) {
            return new PlanItem(itemElement, descriptor);
        }
        return null;
    }

    PluginMember generateFromXMLWrapper(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        try {
            return this.generateFromXML(plugin);
        }
        catch (PersistenceManagerException e) {
            throw PluginException.objectCreationError(this.getObjectType(), this.getObjectIdentifier(), e);
        }
    }

    abstract PluginMember generateFromXML(PluginImpl var1) throws PersistenceManagerException, RPCException;

    abstract String getObjectType();

    abstract String getObjectIdentifier();
}

