/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSession;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionInfo;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionStatus;
import com.raplix.util.logger.Logger;

public class PluginImportSessionID
extends ObjectID {
    private static PluginImportSessionIDFactory idFactory = new PluginImportSessionIDFactory();

    public static PluginImportSessionID generateID() {
        return (PluginImportSessionID)idFactory.generateObjectID();
    }

    public PluginImportSessionID(String inID) {
        super(inID);
    }

    public void cancel() throws RPCException, PersistenceManagerException {
        Plugin.transactRPC(new RPCTransaction(false){

            protected PersistContext executeMS() throws PersistenceManagerException {
                PluginImportSessionID.this.trCancelMS();
                return null;
            }
        });
    }

    private void trCancelMS() throws PersistenceManagerException {
        PluginDBSubsystem.getInstance().cancelDelete(this);
    }

    public PluginImportSessionInfo getInfo() throws RPCException, PersistenceManagerException {
        PluginImportSessionInfoCtx result = (PluginImportSessionInfoCtx)Plugin.transactRPC(new RPCTransaction(false){

            protected PersistContext executeMS() throws PersistenceManagerException {
                return PluginImportSessionID.this.trGetInfoMS();
            }
        });
        return result.getInfo();
    }

    private PluginImportSessionInfoCtx trGetInfoMS() throws PersistenceManagerException {
        PluginImportSession session = PluginDBSubsystem.getInstance().getSession(this);
        if (session == null) {
            throw PluginException.unexpectedError();
        }
        PluginImportSessionInfo info = session.getInfo();
        return new PluginImportSessionInfoCtx(info);
    }

    public PluginID join() throws PersistenceManagerException, RPCException {
        PluginIDCtx result = (PluginIDCtx)Plugin.transactRPC(new RPCTransaction(false){

            protected PersistContext executeMS() throws PersistenceManagerException {
                return PluginImportSessionID.this.trJoinMS();
            }
        });
        return result.getID();
    }

    private PluginIDCtx trJoinMS() throws PersistenceManagerException {
        try {
            PluginImportSession session = PluginDBSubsystem.getInstance().getSession(this);
            if (session == null) {
                throw PluginException.unexpectedError();
            }
            PluginImportSessionInfo info = session.waitUntilDone();
            PluginImportSessionStatus status = info.getStatus();
            if (status.equals(PluginImportSessionStatus.FAILED)) {
                throw info.getException();
            }
            if (status.equals(PluginImportSessionStatus.ABORTED)) {
                return new PluginIDCtx(null);
            }
            PluginID pluginID = this.getInfo().getPluginID();
            return new PluginIDCtx(pluginID);
        }
        catch (RPCException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unexpected RPC error in PluginImportSessionID.join", e, this);
            }
            throw PluginException.unexpectedError(e);
        }
        catch (InterruptedException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unexpected error in PluginImportSessionID.join", e, this);
            }
            throw PluginException.unexpectedError(e);
        }
    }

    private static final class PluginIDCtx
    extends PersistContext {
        private PluginID mID;

        public PluginIDCtx(PluginID ID2) {
            this.setID(ID2);
        }

        public PluginID getID() {
            return this.mID;
        }

        private void setID(PluginID ID2) {
            this.mID = ID2;
        }
    }

    private static final class PluginImportSessionInfoCtx
    extends PersistContext {
        private PluginImportSessionInfo mInfo;

        public PluginImportSessionInfoCtx(PluginImportSessionInfo info) {
            this.setInfo(info);
        }

        public PluginImportSessionInfo getInfo() {
            return this.mInfo;
        }

        private void setInfo(PluginImportSessionInfo info) {
            this.mInfo = info;
        }
    }

    public static class PluginImportSessionIDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new PluginImportSessionID(inID);
        }
    }
}

