/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireWriteLockTransaction;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionInfo;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionStatus;
import com.raplix.rolloutexpress.systemmodel.plugindb.SinglePluginQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.RunnableContext;

class PluginImportSession
extends RunnableContext {
    private PluginImportSessionID mSessionID;
    private PluginImportSessionInfo mInfo;
    private PluginDescriptor mPluginDescriptor;

    public PluginImportSession(PluginImportSessionID inID, PluginDescriptor inDescriptor, Context inContext) {
        super("PluginImportSession(" + inID + ")", inContext);
        this.mSessionID = inID;
        this.mPluginDescriptor = inDescriptor;
        this.mInfo = new PluginImportSessionInfo(this.mSessionID, PluginImportSessionStatus.NOT_STARTED, this.getTaskOwner(), null, null);
    }

    public PluginImportSessionID getID() {
        return this.mSessionID;
    }

    public PluginImportSessionInfo getInfo() {
        return this.mInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void safeRun() {
        block30: {
            TransactionManager tm = PersistenceManager.getInstance().getTransactionManager();
            PluginID pluginID = (PluginID)tm.transact(new AcquireWriteLockTransaction(){

                public Object execute() throws PersistenceManagerException {
                    return PluginImportSession.this.trSafeRun();
                }

                public ROXMessage getLockDescription() {
                    return new ROXMessage("plg.OPERATION_RUNNING", (Object[])new String[0], 3000);
                }
            });
            this.setInfo(this.mSessionID, PluginImportSessionStatus.COMPLETE, pluginID, null);
            Object var4_5 = null;
            try {
                if (this.mInfo.getStatus().equals(PluginImportSessionStatus.COMPLETE)) {
                    PluginImpl.cleanUpSuccessfulImportMS(this.mPluginDescriptor);
                } else {
                    PluginImpl.cleanUpFailedImportMS(this.mPluginDescriptor);
                }
            }
            catch (Throwable t2) {
                if (!Logger.isErrorEnabled(this)) break block30;
                Logger.error("Unexpected error while cleaning up import", t2, this);
            }
        }
        this.mPluginDescriptor = null;
        PluginImportSession pluginImportSession = this;
        synchronized (pluginImportSession) {
            this.notifyAll();
            PluginDBSubsystem.getInstance().subsystemTaskComplete(this.getName());
        }
        {
            catch (PersistenceManagerException e) {
                block31: {
                    if (e.getIsInterrupted()) {
                        this.setInfo(this.mSessionID, PluginImportSessionStatus.ABORTED, null, e);
                    } else {
                        this.setInfo(this.mSessionID, PluginImportSessionStatus.FAILED, null, e);
                    }
                    Object var4_6 = null;
                    try {
                        if (this.mInfo.getStatus().equals(PluginImportSessionStatus.COMPLETE)) {
                            PluginImpl.cleanUpSuccessfulImportMS(this.mPluginDescriptor);
                        } else {
                            PluginImpl.cleanUpFailedImportMS(this.mPluginDescriptor);
                        }
                    }
                    catch (Throwable t2) {
                        if (!Logger.isErrorEnabled(this)) break block31;
                        Logger.error("Unexpected error while cleaning up import", t2, this);
                    }
                }
                this.mPluginDescriptor = null;
                PluginImportSession pluginImportSession2 = this;
                synchronized (pluginImportSession2) {
                    this.notifyAll();
                    PluginDBSubsystem.getInstance().subsystemTaskComplete(this.getName());
                }
            }
            catch (Throwable t) {
                block32: {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Unexpected error while importing plugin", t, this);
                    }
                    this.setInfo(this.mSessionID, PluginImportSessionStatus.FAILED, null, PluginException.unexpectedError(t));
                    Object var4_7 = null;
                    try {
                        if (this.mInfo.getStatus().equals(PluginImportSessionStatus.COMPLETE)) {
                            PluginImpl.cleanUpSuccessfulImportMS(this.mPluginDescriptor);
                        } else {
                            PluginImpl.cleanUpFailedImportMS(this.mPluginDescriptor);
                        }
                    }
                    catch (Throwable t2) {
                        if (!Logger.isErrorEnabled(this)) break block32;
                        Logger.error("Unexpected error while cleaning up import", t2, this);
                    }
                }
                this.mPluginDescriptor = null;
                PluginImportSession pluginImportSession3 = this;
                synchronized (pluginImportSession3) {
                    this.notifyAll();
                    PluginDBSubsystem.getInstance().subsystemTaskComplete(this.getName());
                }
            }
        }
        catch (Throwable throwable) {
            block33: {
                Object var4_8 = null;
                try {
                    if (this.mInfo.getStatus().equals(PluginImportSessionStatus.COMPLETE)) {
                        PluginImpl.cleanUpSuccessfulImportMS(this.mPluginDescriptor);
                    } else {
                        PluginImpl.cleanUpFailedImportMS(this.mPluginDescriptor);
                    }
                }
                catch (Throwable t2) {
                    if (!Logger.isErrorEnabled(this)) break block33;
                    Logger.error("Unexpected error while cleaning up import", t2, this);
                }
            }
            this.mPluginDescriptor = null;
            PluginImportSession pluginImportSession4 = this;
            synchronized (pluginImportSession4) {
                this.notifyAll();
                PluginDBSubsystem.getInstance().subsystemTaskComplete(this.getName());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginID trSafeRun() throws PersistenceManagerException {
        try {
            PluginImportSession pluginImportSession = this;
            synchronized (pluginImportSession) {
                this.testImportFlow();
                this.setInfo(this.mSessionID, PluginImportSessionStatus.IMPORT_RUNNING, null, null);
            }
            return this.importPlugin();
        }
        catch (RPCException e) {
            throw PluginException.unexpectedError(e);
        }
    }

    protected void testImportFlow() throws PersistenceManagerException {
        try {
            super.testFlow();
        }
        catch (InterruptedException e) {
            throw new PersistenceManagerException(e);
        }
    }

    synchronized PluginImportSessionInfo waitUntilDone() throws InterruptedException {
        PluginImportSessionInfo info = this.getInfo();
        while (!info.getStatus().done()) {
            this.wait();
            info = this.getInfo();
        }
        return info;
    }

    synchronized void setInfo(PluginImportSessionID sessionID, PluginImportSessionStatus status, PluginID pluginID, PersistenceManagerException exception) {
        this.mInfo = new PluginImportSessionInfo(sessionID, status, this.getTaskOwner(), pluginID, exception);
    }

    private PluginID importPlugin() throws PersistenceManagerException, RPCException {
        Plugin plugin = null;
        VersionNumber expectedPreviousVersion = this.mPluginDescriptor.getPreviousVersion();
        VersionNumber expectedNextVersion = this.mPluginDescriptor.getVersion();
        boolean pluginExists = true;
        try {
            SinglePluginQuery query = SinglePluginQuery.byName(this.mPluginDescriptor.getName());
            plugin = query.select();
        }
        catch (NoResultsFoundException e) {
            pluginExists = false;
        }
        if (expectedPreviousVersion == null) {
            if (pluginExists) {
                throw PluginException.pluginExists(this.mPluginDescriptor.getName(), expectedNextVersion.getAsString());
            }
            plugin = new Plugin();
        } else {
            if (!pluginExists || !plugin.getVersionNumber().equals(expectedPreviousVersion)) {
                throw PluginException.invalidPreviousPluginVersion(this.mPluginDescriptor.getName(), expectedNextVersion.getAsString(), expectedPreviousVersion.getAsString());
            }
            if (!expectedNextVersion.isGreaterThan(expectedPreviousVersion)) {
                throw PluginException.invalidPluginVersion(this.mPluginDescriptor.getName(), expectedNextVersion.getAsString(), expectedPreviousVersion.getAsString(), expectedPreviousVersion.getAsString());
            }
        }
        plugin.readFromDescriptor(this.mPluginDescriptor, this);
        return plugin.getID();
    }

    public synchronized void cancel() {
        PluginDBSubsystem.checkTaskPermission(this.getTaskOwner());
        if (this.getInfo().getStatus().abortable()) {
            this.setInfo(this.mSessionID, PluginImportSessionStatus.ABORT_REQUESTED, null, null);
            this.abort();
        }
    }

    public UserID getTaskOwner() {
        return PluginDBSubsystem.getInstance().getTaskOwner(this.getName());
    }
}

