/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQuery;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.resource.MultiRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceIDSet;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.repopaths.FilenameEscape;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.MultiFolderQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDependency;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDependencyLinkTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginIDSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSession;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginSQLOps;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginUIDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.SinglePluginQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.util.collections.TypedSet;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.file.FileInfo;
import com.raplix.util.file.FileUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.Replace;
import com.raplix.util.unicode.Encoding;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import com.raplix.util.unicode.UnicodeOutputStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PluginImpl
extends PersistentBean
implements Cloneable {
    static String README_FILE = "readMe.txt";
    static String SERVER_PLUGIN_JAR_FILE = "server.jar";
    static String CUSTOM_PAGE_FILE = "shortcuts.html";
    static String ICON_FILE = "icon.gif";
    static String CERTIFICATE_FILE = "plugin.crt";
    static String JAR_FILE_SUFFIX = ".jar";
    static String PLUGINS_DIRECTORY = "plugins";
    private transient SummaryPlugin mSummaryView;
    private String mName;
    private String mDescription;
    private String mMenuOrder = Plugin.DEFAULT_MENU_ORDER;
    private String mVendor;
    private String mMenuItem;
    private String mToolTip;
    private VersionNumber mVersionNumber;
    private int mVersion;
    private String mReadMeText;
    private String mServerPluginJARPath;
    private String mIconPath;
    private String mCustomPagePath;
    private Certificate mCertificate;
    private String mCertificateType;
    private ComponentIDSet mComponentIDSet;
    private ExecutionPlanIDSet mExecutionPlanIDSet;
    private HostSearchIDSet mHostSearchIDSet;
    private HostSetIDSet mHostSetIDSet;
    private HostTypeIDSet mHostTypeIDSet;
    private ComponentTypeRefIDSet mComponentTypeRefIDSet;
    private SystemServiceRefIDSet mSystemServiceRefIDSet;
    private PluginIDSet mDependenciesIDSet;
    private FolderIDSet mFolderIDSet;
    private ResourceIDSet mResourceIDSet;
    private boolean mExternalDataLoaded = false;

    static String getDataDirRoot() {
        return PluginDBSubsystem.getInstance().getApplication().getDataDirAbsPath() + File.separator;
    }

    static String getRepoRoot() {
        return PluginImpl.getDataDirRoot() + PLUGINS_DIRECTORY + File.separator;
    }

    static String getRepoRoot(String name) {
        return PluginImpl.getRepoRoot() + FilenameEscape.escapeUnicode(name) + File.separator;
    }

    static String getRepoRoot(String name, VersionNumber version) {
        return PluginImpl.getRepoRoot(name) + version.getAsString() + File.separator;
    }

    static String getRelativeToDataDir(String fileName) {
        if (fileName == null) {
            return null;
        }
        fileName = Replace.replace(fileName, PluginImpl.getDataDirRoot(), "");
        fileName = Replace.replace(fileName, File.pathSeparator, "/");
        return fileName;
    }

    private static String getJARName(VersionNumber version) {
        return version.getAsString() + JAR_FILE_SUFFIX;
    }

    static void cleanUpFailedImportMS(PluginDescriptor pd) throws PersistenceManagerException, RPCException, IOException {
        String jarToDelete = null;
        String dirToDelete = null;
        try {
            SummaryPlugin plugin = SinglePluginQuery.byName(pd.getName()).selectSummaryView();
            if (!plugin.getVersionNumber().equals(pd.getVersion())) {
                jarToDelete = PluginImpl.getRepoRoot(pd.getName()) + PluginImpl.getJARName(pd.getVersion());
                dirToDelete = PluginImpl.getRepoRoot(pd.getName(), pd.getVersion());
            }
        }
        catch (AccessControlException e) {
        }
        catch (NoResultsFoundException e) {
            dirToDelete = PluginImpl.getRepoRoot(pd.getName());
        }
        if (jarToDelete != null) {
            FileUtil.ensureDeleted(jarToDelete);
        }
        if (dirToDelete != null) {
            FileUtil.ensureDeleted(dirToDelete);
        }
    }

    static void cleanUpSuccessfulImportMS(PluginDescriptor pd) throws IOException {
        VersionNumber previous = pd.getPreviousVersion();
        if (previous != null) {
            String root = PluginImpl.getRepoRoot(pd.getName(), previous);
            FileUtil.ensureDeleted(root);
        }
    }

    private PluginIDSet resolveDependencies(PluginDescriptor pd) throws PersistenceManagerException, RPCException {
        boolean isReimport;
        PluginDependency[] dependencies = pd.getDependencyList();
        PluginIDSet set = new PluginIDSet();
        PluginIDSet myDependants = null;
        boolean bl = isReimport = pd.getPreviousVersion() != null;
        if (isReimport) {
            myDependants = this.getID().getDependentChildren(new HashMap());
        }
        for (int i = 0; i < dependencies.length; ++i) {
            PluginDependency dep = dependencies[i];
            Object pluginID = null;
            SummaryPlugin plugin = null;
            try {
                SinglePluginQuery query = SinglePluginQuery.byName(dep.getName());
                plugin = query.selectSummaryView();
            }
            catch (NoResultsFoundException e) {
                throw PluginException.invalidDependency(pd.getName(), pd.getVersion().getAsString(), dep.getName(), dep.getVersion().getAsString());
            }
            if (plugin.getVersionNumber().getSingleVersionNumber() < dep.getVersion().getSingleVersionNumber()) {
                throw PluginException.invalidDependency(pd.getName(), pd.getVersion().getAsString(), dep.getName(), dep.getVersion().getAsString());
            }
            if (isReimport && myDependants.contains(plugin.getID())) {
                throw PluginException.circularDependency(pd.getName(), pd.getVersion().getAsString(), dep.getName(), dep.getVersion().getAsString());
            }
            set.add(plugin.getID());
        }
        return set;
    }

    private PluginImpl() {
    }

    static PluginImpl create() {
        PluginImpl result = new PluginImpl();
        result.resetExternalData(true);
        return result;
    }

    void readFromDescriptor(PluginDescriptor pd, PluginImportSession session) throws PersistenceManagerException, RPCException {
        session.testImportFlow();
        this.setName(pd.getName());
        String description = pd.getDescription();
        if (description != null) {
            this.setDescription(description);
        }
        this.setVendor(pd.getVendor());
        this.setVersionNumber(pd.getVersion());
        PluginUIDescriptor puid = pd.getGUIDescriptor();
        if (puid != null) {
            String menuItem = puid.getMenuItem();
            this.setMenuItem(menuItem);
            String toolTip = puid.getToolTip();
            if (toolTip != null) {
                this.setToolTip(toolTip);
            }
        }
        PluginDBSubsystem pluginDBSubystem = PluginDBSubsystem.getInstance();
        boolean isAutoLoading = pluginDBSubystem.isAutoLoading();
        if (pd.getPreviousVersion() != null) {
            boolean shouldValidateOnReimport;
            try {
                shouldValidateOnReimport = pluginDBSubystem.getConfigValidateCertOnReimport();
            }
            catch (ConfigurationException ce) {
                shouldValidateOnReimport = true;
            }
            if (shouldValidateOnReimport) {
                this.checkCertValidForReimport(pd, isAutoLoading);
            }
        } else {
            boolean shouldValidateOnNewimport;
            try {
                shouldValidateOnNewimport = pluginDBSubystem.getConfigValidateCertOnNewimport();
            }
            catch (ConfigurationException ce) {
                shouldValidateOnNewimport = true;
            }
            if (shouldValidateOnNewimport) {
                this.checkCertValidForNewimport(pd, isAutoLoading);
            }
        }
        this.mCertificate = pd.getCertificate();
        if (this.mCertificate != null) {
            this.setCertificateType(this.mCertificate.getType());
        }
        PluginIDSet set = this.resolveDependencies(pd);
        set.addAll((Collection)this.mDependenciesIDSet);
        this.setDependencies(set);
        PluginImportContext context = new PluginImportContext(pd, session);
        this.save(context);
    }

    private void createObjectsMS(PluginDescriptor pd, PluginImportSession session) throws PersistenceManagerException {
        PluginItem[] items = pd.getItemList();
        try {
            Plugin plugin = new Plugin(this);
            for (int i = 0; i < items.length; ++i) {
                session.testImportFlow();
                items[i].generateFromXMLWrapper(this);
                PluginSQLOps.DEFAULT.getClassMap().removeCacheObject(this.getID());
            }
        }
        catch (RPCException e) {
            throw PluginException.unexpectedError(e);
        }
    }

    private void deployFilesMS(PluginDescriptor pd, PluginImportSession session) throws PersistenceManagerException {
        try {
            String repoRoot = PluginImpl.getRepoRoot();
            FileUtil.ensureDirPresent(repoRoot);
            repoRoot = PluginImpl.getRepoRoot(pd.getName());
            FileUtil.ensureDirPresent(repoRoot);
            repoRoot = PluginImpl.getRepoRoot(pd.getName(), pd.getVersion());
            FileUtil.ensureDeleted(repoRoot);
            FileUtil.ensureDirPresent(repoRoot);
            String previousRepoRoot = null;
            if (pd.getPreviousVersion() != null) {
                previousRepoRoot = PluginImpl.getRepoRoot(pd.getName(), pd.getPreviousVersion());
            }
            repoRoot = PluginImpl.getRepoRoot(pd.getName());
            String jar = PluginImpl.getJARName(pd.getVersion());
            this.attemptDeployFile(session, jar, repoRoot, null, pd.getByteArrayInputStream(), false, false);
            repoRoot = PluginImpl.getRepoRoot(pd.getName(), pd.getVersion());
            String readMeFile = this.attemptDeployFile(session, README_FILE, repoRoot, previousRepoRoot, pd.getReadMe(), true, false);
            if (readMeFile != null) {
                this.mReadMeText = new String(CopyUtil.readText(readMeFile));
            }
            ByteArrayInputStream bis = null;
            if (this.mCertificate != null) {
                bis = new ByteArrayInputStream(this.mCertificate.getEncoded());
            }
            this.attemptDeployFile(session, CERTIFICATE_FILE, repoRoot, previousRepoRoot, bis, false, false);
            String serverJarFile = this.attemptDeployFile(session, SERVER_PLUGIN_JAR_FILE, repoRoot, previousRepoRoot, pd.getServerPluginJAR(), false, false);
            this.mServerPluginJARPath = PluginImpl.getRelativeToDataDir(serverJarFile);
            PluginUIDescriptor uiDescriptor = pd.getGUIDescriptor();
            InputStream iconStream = null;
            if (uiDescriptor != null) {
                iconStream = uiDescriptor.getIcon();
            }
            String iconFile = this.attemptDeployFile(session, ICON_FILE, repoRoot, previousRepoRoot, iconStream, false, false);
            this.mIconPath = PluginImpl.getRelativeToDataDir(iconFile);
            String customPageFile = this.attemptDeployFile(session, CUSTOM_PAGE_FILE, repoRoot, previousRepoRoot, pd.getGUIInputStream(), false, true);
            this.mCustomPagePath = PluginImpl.getRelativeToDataDir(customPageFile);
        }
        catch (IOException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("IO error while deploying files during import.", e, this);
            }
            throw PluginException.unexpectedError(e);
        }
        catch (CertificateException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Certificate error while deploying files during import.", e, this);
            }
            throw PluginException.unexpectedError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String attemptDeployFile(PluginImportSession session, String fileName, String repoRoot, String previousRepoRoot, InputStream in, boolean encodeUTF8, boolean transformStream) throws IOException, PersistenceManagerException {
        if (session != null) {
            session.testImportFlow();
        }
        boolean successful = false;
        String fullFileName = repoRoot + fileName;
        if (in == null) {
            String fullPreviousFileName;
            FileInfo info;
            if (previousRepoRoot != null && (info = new FileInfo(fullPreviousFileName = previousRepoRoot + fileName)).exists()) {
                CopyUtil.copyBinary(fullPreviousFileName, fullFileName);
                successful = true;
            }
        } else {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(fullFileName);
                if (transformStream) {
                    PluginDBSubsystem.getInstance().transform(this.getID(), in, out);
                } else if (encodeUTF8) {
                    CopyUtil.copyText(new UnicodeInputStreamReader(in), new UnicodeOutputStreamWriter((OutputStream)out, Encoding.UTF8.getName()));
                } else {
                    CopyUtil.copyBinary(in, out);
                }
                successful = true;
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                in.close();
                if (out != null) {
                    out.flush();
                    out.close();
                }
                throw throwable;
            }
            in.close();
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        PluginSQLOps.DEFAULT.getClassMap().removeCacheObject(this.getID());
        if (successful) {
            return fullFileName;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCertValidForReimport(PluginDescriptor pd, boolean isAutoLoading) throws PersistenceManagerException {
        if (this.mCertificate == null) return;
        if (pd.getCertificate() instanceof X509Certificate && this.mCertificate instanceof X509Certificate) {
            Principal newPluginCertPrincipal = ((X509Certificate)pd.getCertificate()).getSubjectDN();
            Principal prevPluginCertPrincipal = ((X509Certificate)this.mCertificate).getSubjectDN();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Comparing Certificates:new:" + newPluginCertPrincipal + ":previous" + prevPluginCertPrincipal, this);
            }
            if (!((Object)newPluginCertPrincipal).equals(prevPluginCertPrincipal)) {
                throw PluginException.certificateSubjectDNMismatch(pd.getName(), pd.getVersion().getAsString(), newPluginCertPrincipal.getName(), prevPluginCertPrincipal.getName());
            }
            Certificate[] prevCertChain = this.getPrevPluginCertChain(pd);
            if (!(prevCertChain != null && prevCertChain.length != 1 || pd.getCertificateChain() != null && pd.getCertificateChain().length != 1)) {
                return;
            }
            Set cacertCerts = this.getJavaCacertCerts();
            Certificate prevPluginRootCert = prevCertChain[prevCertChain.length - 1];
            Certificate[] newPluginCertChain = pd.getCertificateChain();
            if (newPluginCertChain == null || newPluginCertChain.length == 1) {
                String previousCertSubjectDN = "";
                previousCertSubjectDN = prevPluginRootCert instanceof X509Certificate ? ((X509Certificate)prevPluginRootCert).getSubjectDN().getName() : prevPluginRootCert.getPublicKey().toString();
                throw PluginException.certificateSelfSignedMismatch(pd.getName(), pd.getVersion().getAsString(), previousCertSubjectDN);
            }
            Certificate newPluginRootCert = newPluginCertChain[newPluginCertChain.length - 1];
            if (this.isRootCASigned(cacertCerts, newPluginRootCert)) return;
            String newPluginRootSubjectDN = "";
            newPluginRootSubjectDN = newPluginRootCert instanceof X509Certificate ? ((X509Certificate)newPluginRootCert).getSubjectDN().getName() : newPluginRootCert.getPublicKey().toString();
            if (!isAutoLoading) throw PluginException.certificateCACertMismatch(pd.getName(), pd.getVersion().getAsString(), newPluginRootSubjectDN);
            if (!Logger.isErrorEnabled(this)) return;
            Logger.error(new ROXMessage("plg.CERTIFICATE_CA_CERT_MISMATCH", new Object[]{pd.getName(), pd.getVersion().getAsString(), newPluginRootSubjectDN}).getMessageString(), this);
            return;
        } else {
            if (this.mCertificate == null || this.mCertificate.equals(pd.getCertificate())) return;
            throw PluginException.certificateMismatch(pd.getName(), pd.getVersion().getAsString());
        }
    }

    private void checkCertValidForNewimport(PluginDescriptor pd, boolean isAutoLoading) throws PersistenceManagerException {
        Certificate newPluginRootCert;
        Certificate[] newPluginCertChain = pd.getCertificateChain();
        if (newPluginCertChain == null || newPluginCertChain.length == 1) {
            return;
        }
        Set cacertCerts = this.getJavaCacertCerts();
        if (!this.isRootCASigned(cacertCerts, newPluginRootCert = newPluginCertChain[newPluginCertChain.length - 1])) {
            if (isAutoLoading) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(new ROXMessage("plg.CERTIFICATE_SS_CERT_MISMATCH", new Object[]{pd.getName(), pd.getVersion().getAsString()}).getMessageString(), this);
                }
            } else {
                throw PluginException.invalidSelfSignedCert(pd.getName(), pd.getVersion().getAsString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Certificate[] getPrevPluginCertChain(PluginDescriptor pd) throws PersistenceManagerException {
        Certificate[] certificateArray;
        String jarToRead = PluginImpl.getRepoRoot(pd.getName()) + PluginImpl.getJARName(pd.getPreviousVersion());
        FileInputStream pluginStream = null;
        try {
            try {
                pluginStream = new FileInputStream(jarToRead);
                PluginDescriptor prevDesc = new PluginDescriptor(pluginStream, false);
                certificateArray = prevDesc.getCertificateChain();
                Object var7_7 = null;
            }
            catch (FileNotFoundException fe) {
                throw PluginException.unexpectedError(fe);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (pluginStream == null) throw throwable;
                ((InputStream)pluginStream).close();
                throw throwable;
            }
            catch (IOException ignore) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignore) {
            // empty catch block
            return certificateArray;
        }
        if (pluginStream == null) return certificateArray;
        ((InputStream)pluginStream).close();
        return certificateArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getJavaCacertCerts() throws PersistenceManagerException {
        Set<TrustAnchor> set;
        FileInputStream is = null;
        try {
            try {
                String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
                is = new FileInputStream(filename);
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                String cacertPassword = null;
                try {
                    cacertPassword = PluginDBSubsystem.getInstance().getConfigCacertKeyStorePass();
                }
                catch (ConfigurationException ce) {
                    throw PluginException.unexpectedError(ce);
                }
                keystore.load(is, cacertPassword == null ? null : cacertPassword.toCharArray());
                PKIXParameters params = new PKIXParameters(keystore);
                set = params.getTrustAnchors();
                Object var8_9 = null;
                if (is == null) return set;
            }
            catch (Exception e) {
                throw PluginException.unexpectedError(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ignore) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignore) {
            // empty catch block
            return set;
        }
        is.close();
        return set;
    }

    private boolean isRootCASigned(Set cacertCerts, Certificate inPluginRootCert) {
        boolean isRootCASigned = false;
        Iterator i = cacertCerts.iterator();
        while (i.hasNext()) {
            TrustAnchor ta = (TrustAnchor)i.next();
            if (!ta.getTrustedCert().equals(inPluginRootCert)) continue;
            isRootCASigned = true;
            break;
        }
        return isRootCASigned;
    }

    String getName() {
        return this.mName;
    }

    String getDescription() {
        return this.mDescription;
    }

    String getVendor() {
        return this.mVendor;
    }

    VersionNumber getVersionNumber() {
        return this.mVersionNumber;
    }

    int getVersion() {
        if (this.mVersionNumber != null) {
            return this.mVersionNumber.getSingleVersionNumber();
        }
        return 0;
    }

    String getMenuItem() {
        return this.mMenuItem;
    }

    String getMenuOrder() {
        return this.mMenuOrder;
    }

    String getToolTip() {
        return this.mToolTip;
    }

    String getReadMeText() {
        return this.mReadMeText;
    }

    String getServerPluginJARPath() {
        return this.mServerPluginJARPath;
    }

    String getCustomPagePath() {
        return this.mCustomPagePath;
    }

    String getIconPath() {
        return this.mIconPath;
    }

    String getCertificateType() {
        return this.mCertificateType;
    }

    Certificate getCertificate() {
        return this.mCertificate;
    }

    private void setName(String name) {
        this.mName = name;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    private void setVendor(String vendor) {
        this.mVendor = vendor;
    }

    private void setVersion(int version) {
        this.mVersionNumber = new VersionNumber(version);
    }

    private void setVersionNumber(VersionNumber versionNumber) {
        this.mVersionNumber = versionNumber;
    }

    private void setMenuItem(String menuItem) {
        this.mMenuItem = menuItem;
    }

    void setMenuOrder(String menuOrder) {
        if (menuOrder != null) {
            this.mMenuOrder = menuOrder;
        }
    }

    private void setToolTip(String toolTip) {
        this.mToolTip = toolTip;
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    void setDependencies(PluginIDSet set) {
        this.mDependenciesIDSet = set;
    }

    void setCertificateType(String type) {
        this.mCertificateType = type;
    }

    ComponentIDSet getComponents() {
        return (ComponentIDSet)this.mComponentIDSet.clone();
    }

    void addComponent(ComponentID id) {
        this.mComponentIDSet.add(id);
    }

    ExecutionPlanIDSet getPlans() {
        return (ExecutionPlanIDSet)this.mExecutionPlanIDSet.clone();
    }

    void addPlan(ExecutionPlanID id) {
        this.mExecutionPlanIDSet.add(id);
    }

    FolderIDSet getFolders() {
        return (FolderIDSet)this.mFolderIDSet.clone();
    }

    void addFolder(FolderID id) {
        this.mFolderIDSet.add(id);
    }

    HostSearchIDSet getHostSearches() {
        return (HostSearchIDSet)this.mHostSearchIDSet.clone();
    }

    void addHostSearch(HostSearchID id) {
        this.mHostSearchIDSet.add(id);
    }

    HostSetIDSet getHostSets() {
        return (HostSetIDSet)this.mHostSetIDSet.clone();
    }

    void addHostSet(HostSetID id) {
        this.mHostSetIDSet.add(id);
    }

    HostTypeIDSet getHostTypes() {
        return (HostTypeIDSet)this.mHostTypeIDSet.clone();
    }

    void addHostType(HostTypeID id) {
        this.mHostTypeIDSet.add(id);
    }

    ComponentTypeRefIDSet getComponentTypes() {
        return (ComponentTypeRefIDSet)this.mComponentTypeRefIDSet.clone();
    }

    void addComponentType(ComponentTypeRefID id) {
        this.mComponentTypeRefIDSet.add(id);
    }

    SystemServiceRefIDSet getSystemServices() {
        return (SystemServiceRefIDSet)this.mSystemServiceRefIDSet.clone();
    }

    void addSystemService(SystemServiceRefID id) {
        this.mSystemServiceRefIDSet.add(id);
    }

    ResourceIDSet getResources() {
        return (ResourceIDSet)this.mResourceIDSet.clone();
    }

    void addResource(ResourceID id) {
        this.mResourceIDSet.add(id);
    }

    PluginIDSet getDependencies() {
        return (PluginIDSet)this.mDependenciesIDSet.clone();
    }

    protected Visibility getVisibility() {
        return super.getVisibility();
    }

    PluginID getID() {
        return (PluginID)this.getObjectID();
    }

    protected Object clone() {
        try {
            PluginImpl result = (PluginImpl)super.clone();
            result.mSummaryView = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void save(PersistContext context) throws PersistenceManagerException, RPCException {
        this.validate();
        this.saveRPC(context);
    }

    protected void saveMS(final PersistContext context) throws PersistenceManagerException {
        PluginImpl.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                PluginImpl.this.trSaveMS(context);
                return null;
            }
        });
    }

    private void enablePermsAndCreateObjectsMS(final PluginDescriptor pd, final PluginImportSession session) throws PersistenceManagerException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws PersistenceManagerException {
                PluginImpl.this.createObjectsMS(pd, session);
                return null;
            }
        };
        this.getID().runWithMemberWritePermissionMS(action);
    }

    private void trSaveMS(PersistContext context) throws PersistenceManagerException {
        boolean deleteOldLinks = this.getID() != null;
        super.saveMS(null);
        PluginDependencyLinkTable.DEFAULT.resetLinks(this.getDependencies().toIDArray(), this.getID(), deleteOldLinks);
        PluginSQLOps.DEFAULT.getClassMap().removeCacheObject(this.getID());
        if (context != null) {
            PluginImportContext importContext = (PluginImportContext)context;
            PluginDescriptor pd = importContext.getDescriptor();
            PluginImportSession session = importContext.getSession();
            this.enablePermsAndCreateObjectsMS(pd, session);
            this.deployFilesMS(pd, session);
            session.testImportFlow();
            PluginDBSubsystem.getInstance().pluginAdded(this.getID());
        } else {
            PluginDBSubsystem.getInstance().pluginEdited(this.getID());
        }
    }

    void validate() throws PluginException {
        Plugin.validateMenuOrder(this.mMenuOrder);
    }

    Plugin getCompleteViewMS() throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new Plugin(this);
    }

    SummaryPlugin getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummaryPlugin(this);
        }
        return this.mSummaryView;
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        if (this.getID() != null) {
            Link[] dependencies = PluginDependencyLinkTable.DEFAULT.getByChildID(this.getID());
            this.setExternalDataMS(Arrays.asList(dependencies));
        } else {
            this.resetExternalData(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRepoDataMS() throws PersistenceManagerException {
        try {
            String root = PluginImpl.getRepoRoot(this.mName, this.mVersionNumber);
            String fileName = root + README_FILE;
            FileInfo info = new FileInfo(fileName);
            if (info.exists()) {
                this.mReadMeText = new String(CopyUtil.readText(fileName));
            }
            if ((info = new FileInfo(fileName = root + CERTIFICATE_FILE)).exists()) {
                FileInputStream certFileStream = new FileInputStream(fileName);
                try {
                    CertificateFactory cf = CertificateFactory.getInstance(this.mCertificateType);
                    this.mCertificate = cf.generateCertificate(certFileStream);
                }
                finally {
                    certFileStream.close();
                }
            }
            if ((info = new FileInfo(fileName = root + SERVER_PLUGIN_JAR_FILE)).exists()) {
                this.mServerPluginJARPath = PluginImpl.getRelativeToDataDir(fileName);
            }
            if ((info = new FileInfo(fileName = root + CUSTOM_PAGE_FILE)).exists()) {
                this.mCustomPagePath = PluginImpl.getRelativeToDataDir(fileName);
            }
            if ((info = new FileInfo(fileName = root + ICON_FILE)).exists()) {
                this.mIconPath = PluginImpl.getRelativeToDataDir(fileName);
            }
        }
        catch (IOException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("IO error while reading files", e, this);
            }
            throw PluginException.unexpectedError(e);
        }
        catch (CertificateException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Certificate error while reading files", e, this);
            }
            throw PluginException.unexpectedError(e);
        }
    }

    static void loadExternalDataMS(List plugins) throws PersistenceManagerException {
        int size = plugins.size();
        if (size == 0) {
            return;
        }
        PluginIDSet idSet = new PluginIDSet();
        for (int i = 0; i < size; ++i) {
            PluginImpl plugin = (PluginImpl)plugins.get(i);
            if (plugin.isExternalDataLoaded()) continue;
            idSet.add(plugin.getID());
        }
        if (idSet.isEmpty()) {
            return;
        }
        ObjectID[] pluginIDs = idSet.toIDArray();
        Map dependenciesMap = PluginDependencyLinkTable.DEFAULT.mapLinksByChildIDs(pluginIDs);
        for (int i = 0; i < size; ++i) {
            PluginImpl plugin = (PluginImpl)plugins.get(i);
            if (plugin.isExternalDataLoaded()) continue;
            List dependencies = (List)dependenciesMap.get(plugin.getID());
            plugin.setExternalDataMS(dependencies);
        }
    }

    private synchronized void setExternalDataMS(List dependencyList) throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        this.resetExternalData(false);
        Link.addParentIDs(this.mDependenciesIDSet, dependencyList);
        this.loadRepoDataMS();
        this.fillIDSets();
        this.setExternalDataLoaded();
    }

    private boolean isExternalDataLoaded() {
        return this.mExternalDataLoaded;
    }

    private void resetExternalData(boolean isLoadComplete) {
        this.mDependenciesIDSet = new PluginIDSet();
        this.mComponentIDSet = new ComponentIDSet();
        this.mComponentTypeRefIDSet = new ComponentTypeRefIDSet();
        this.mExecutionPlanIDSet = new ExecutionPlanIDSet();
        this.mFolderIDSet = new FolderIDSet();
        this.mHostSearchIDSet = new HostSearchIDSet();
        this.mHostSetIDSet = new HostSetIDSet();
        this.mHostTypeIDSet = new HostTypeIDSet();
        this.mSystemServiceRefIDSet = new SystemServiceRefIDSet();
        this.mResourceIDSet = new ResourceIDSet();
        if (isLoadComplete) {
            this.setExternalDataLoaded();
        }
    }

    private void setExternalDataLoaded() {
        this.mExternalDataLoaded = true;
    }

    private void fillIDSets() throws PersistenceManagerException {
        try {
            MultiHostSearchQuery hostSearchQuery = MultiHostSearchQuery.all();
            HostSearchImplTable t = HostSearchImplTable.DEFAULT;
            this.fillIDSet(hostSearchQuery, t, t.PluginID, this.mHostSearchIDSet);
            MultiHostSetQuery hostSetQuery = MultiHostSetQuery.all();
            HostSetImplTable t2 = HostSetImplTable.DEFAULT;
            this.fillIDSet(hostSetQuery, t2, t2.PluginID, this.mHostSetIDSet);
            MultiHostTypeQuery hostTypeQuery = MultiHostTypeQuery.all();
            HostTypeImplTable t3 = HostTypeImplTable.DEFAULT;
            this.fillIDSet(hostTypeQuery, t3, t3.PluginID, this.mHostTypeIDSet);
            MultiFolderQuery folderQuery = MultiFolderQuery.all();
            FolderImplTable t4 = FolderImplTable.DEFAULT;
            this.fillIDSet(folderQuery, t4, t4.PluginID, this.mFolderIDSet);
            MultiExecutionPlanQuery planQuery = MultiExecutionPlanQuery.all();
            ExecutionPlanImplTable t5 = ExecutionPlanImplTable.DEFAULT;
            this.fillIDSet(planQuery, t5, t5.PluginID, this.mExecutionPlanIDSet);
            MultiComponentQuery componentQuery = MultiComponentQuery.all();
            ComponentImplTable t6 = ComponentImplTable.DEFAULT;
            this.fillIDSet(componentQuery, t6, t6.PluginID, this.mComponentIDSet);
            MultiComponentTypeRefQuery componentTypeQuery = MultiComponentTypeRefQuery.all();
            ComponentTypeRefImplTable t7 = ComponentTypeRefImplTable.DEFAULT;
            this.fillIDSet(componentTypeQuery, t7, t7.PluginID, this.mComponentTypeRefIDSet);
            MultiSystemServiceRefQuery systemServiceQuery = MultiSystemServiceRefQuery.all();
            SystemServiceRefImplTable t8 = SystemServiceRefImplTable.DEFAULT;
            this.fillIDSet(systemServiceQuery, t8, t8.PluginID, this.mSystemServiceRefIDSet);
            MultiRsrcInfoQuery resourceQuery = MultiRsrcInfoQuery.all();
            ResourceTable t9 = ResourceTable.DEFAULT;
            this.fillIDSet(resourceQuery, t9, t9.PluginID, this.mResourceIDSet);
        }
        catch (RPCException e) {
            throw PluginException.unexpectedError(e);
        }
    }

    private void fillIDSet(MultiSelectableObjectQuery query, Table t, final IDColumn column, TypedSet set) throws PersistenceManagerException, RPCException {
        query.addFilter(new ObjectFilter(){

            public void addFilterCondition(QueryContext ctx) {
                Table t = ctx.getFirstTable();
                ctx.addAndWhereCondition(Table.equals(column, PluginImpl.this.getID()));
            }
        });
        if (query instanceof MultiStandardObjectQuery) {
            ((MultiStandardObjectQuery)((Object)query)).setVisibilityFilter(null);
        }
        query.setObjectOrder(null);
        HasObjectID[] objs = query.selectObjects();
        for (int i = 0; i < objs.length; ++i) {
            set.add(objs[i].getObjectID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createRepoFromDescriptorMS(PluginDescriptor desc) throws PersistenceManagerException, IOException {
        block13: {
            if (!this.getVersionNumber().equals(desc.getVersion())) {
                throw PluginException.invalidCreateRepoState(this.getName());
            }
            if (desc.getGUIDescriptor() != null) {
                throw PluginException.invalidCreateRepoState(this.getName());
            }
            if (this.repoExists(this.getName(), this.getVersionNumber())) {
                throw PluginException.invalidCreateRepoState(this.getName());
            }
            if (desc.getPreviousVersion() != null && !this.repoExists(this.getName(), desc.getPreviousVersion())) {
                throw PluginException.invalidCreateRepoState(this.getName());
            }
            boolean success = false;
            try {
                this.deployFilesMS(desc, null);
                success = true;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var4_4 = null;
                    try {
                        if (success) {
                            PluginImpl.cleanUpSuccessfulImportMS(desc);
                        } else {
                            PluginImpl.cleanUpFailedImportMS(desc);
                        }
                    }
                    catch (Exception e) {
                        if (!Logger.isErrorEnabled(this)) break block14;
                        Logger.error("unexpected error while cleaning up after repo migration", e, this);
                    }
                }
                throw throwable;
            }
            try {
                if (success) {
                    PluginImpl.cleanUpSuccessfulImportMS(desc);
                    break block13;
                }
                PluginImpl.cleanUpFailedImportMS(desc);
            }
            catch (Exception e) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("unexpected error while cleaning up after repo migration", e, this);
                }
            }
        }
    }

    private boolean repoExists(String name, VersionNumber version) throws IOException {
        String repoRoot = PluginImpl.getRepoRoot(name);
        String jarName = PluginImpl.getJARName(version);
        FileInfo repoRootFI = new FileInfo(repoRoot + jarName);
        return repoRootFI.exists();
    }

    private static final class PluginImportContext
    extends PersistContext {
        private PluginDescriptor mDescriptor;
        private PluginImportSession mSession;

        public PluginImportContext(PluginDescriptor descriptor, PluginImportSession session) {
            this.mDescriptor = descriptor;
            this.mSession = session;
        }

        public PluginDescriptor getDescriptor() {
            return this.mDescriptor;
        }

        public PluginImportSession getSession() {
            return this.mSession;
        }
    }
}

