/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PostTransactionException;
import com.raplix.rolloutexpress.persist.PreCommitException;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectByNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.resource.MultiRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.RsrcInfoOrder;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.folderdb.MultiFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanOrder;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDependencyLinkTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginIDSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImplTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMemberWritePermission;
import com.raplix.rolloutexpress.systemmodel.plugindb.SinglePluginQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager;
import com.raplix.util.file.FileUtil;
import com.raplix.util.logger.Logger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class PluginID
extends ObjectID {
    private static final IDFactory ID_FACTORY = new IDFactory();

    public static PluginID generateID() {
        return (PluginID)ID_FACTORY.generateObjectID();
    }

    private PluginID() {
    }

    public PluginID(String key) {
        super(key);
    }

    public SinglePluginQuery getByIDQuery() {
        return new SinglePluginQuery(this);
    }

    void runWithMemberWritePermissionMS(PrivilegedExceptionAction action) throws PersistenceManagerException {
        AccessControlManager acm;
        try {
            acm = PluginDBSubsystem.getInstance().getApplication().getUserDBSubsystem().getAccessControlManager();
        }
        catch (UnsupportedSubsystemException e) {
            throw PluginException.unexpectedError(e);
        }
        Permissions perms = new Permissions();
        perms.add(new PluginMemberWritePermission(this));
        AccessControlContext acc = acm.addToCurrent(perms);
        try {
            AccessController.doPrivileged(action, acc);
        }
        catch (PrivilegedActionException e) {
            Exception nested = e.getException();
            if (nested instanceof PersistenceManagerException) {
                throw (PersistenceManagerException)nested;
            }
            throw (RuntimeException)nested;
        }
    }

    public void findDependentObjects(final DeleteSessionContext inContext, final DeleteSessionDependentContainer inDependentContainer, final DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws PersistenceManagerException {
                PluginID.this.peaFindDependentObjects(inContext, inDependentContainer, inPostDependentContainer);
                return null;
            }
        };
        this.runWithMemberWritePermissionMS(action);
    }

    private void peaFindDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            Plugin plugin = this.getByIDQuery().select();
            PluginID toBeDeletedID = plugin.getID();
            if (toBeDeletedID.equals(SystemPluginConstants.getInstance().SYSTEM_PLUGIN_ID)) {
                throw new ObjectNotDeletableException(new ROXMessage("pm.CANNOT_DELETE_OBJECT"));
            }
            HashMap cache = new HashMap();
            PluginIDSet dependentChildren = this.getDependentChildren(cache);
            Iterator it = dependentChildren.iterator();
            while (it.hasNext()) {
                PluginID childID = (PluginID)it.next();
                if (inContext.objectWillBeDeletedPriorTo(childID, this)) continue;
                SummaryPlugin child = childID.getByIDQuery().selectSummaryView();
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), (UsingObject[])new SummaryPlugin[]{child});
            }
            HasObjectID[] objs = plugin.getSystemServices().getByIDsQuery().selectObjects();
            inDependentContainer.addAllDependentObjects(objs);
            SummaryComponent[] comps = plugin.getComponents().getByIDsQuery().select();
            ComponentTypeRef[] compTypes = plugin.getComponentTypes().getByIDsQuery().select();
            this.addDependentComponentsAndTypes(inContext, inDependentContainer, comps, compTypes);
            MultiRsrcInfoQuery rsrcQuery = plugin.getResources().getByIDsQuery();
            rsrcQuery.setObjectOrder(RsrcInfoOrder.BY_VERSION_DESC);
            objs = rsrcQuery.selectObjects();
            inDependentContainer.addAllDependentObjects(objs);
            MultiExecutionPlanQuery planQuery = plugin.getPlans().getByIDsQuery();
            planQuery.setObjectOrder(ExecutionPlanOrder.BY_VERSION_DESC);
            objs = planQuery.selectObjects();
            inDependentContainer.addAllDependentObjects(objs);
            objs = plugin.getFolders().getByIDsQuery().selectObjects();
            for (int i = 0; i < objs.length; ++i) {
                SummaryFolder parentFolder;
                inDependentContainer.addDependentObject(objs[i]);
                SummaryFolder childFolder = (SummaryFolder)objs[i];
                while ((parentFolder = this.deletableFolder(childFolder, inContext)) != null) {
                    inDependentContainer.addDependentObject(parentFolder);
                    childFolder = parentFolder;
                }
            }
            objs = plugin.getHostSets().getByIDsQuery().selectObjects();
            inDependentContainer.addAllDependentObjects(objs);
            objs = plugin.getHostSearches().getByIDsQuery().selectObjects();
            inDependentContainer.addAllDependentObjects(objs);
            objs = plugin.getHostTypes().getByIDsQuery().selectObjects();
            inDependentContainer.addAllDependentObjects(objs);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        PluginIDSet idset = new PluginIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        SummaryPlugin plugin = null;
        try {
            plugin = this.getByIDQuery().selectSummaryView();
        }
        catch (RPCException e) {
            throw PluginException.unexpectedError(e);
        }
        PluginDependencyLinkTable.DEFAULT.removeByChildID(this);
        super.deleteMS(context);
        PluginDeleteRollback pluginDeleteRollback = new PluginDeleteRollback(plugin.getName());
        PersistenceManager.getInstance().getTransactionManager().registerTopLevelTransactionListener(pluginDeleteRollback);
        PluginDBSubsystem.getInstance().pluginDeleted(this);
    }

    PluginIDSet getDependentChildren(HashMap cache) throws PersistenceManagerException {
        PluginIDSet result = (PluginIDSet)cache.get(this);
        if (result == null) {
            result = new PluginIDSet();
            Link[] dependentChildren = PluginDependencyLinkTable.DEFAULT.getByParentID(this);
            for (int i = 0; i < dependentChildren.length; ++i) {
                PluginID child = (PluginID)dependentChildren[i].getChildObjectID();
                result.add(child);
                result.addAll((Collection)child.getDependentChildren(cache));
            }
            cache.put(this, result);
        }
        return result;
    }

    private SummaryFolder deletableFolder(SummaryFolder childFolder, DeleteSessionContext context) throws PersistenceManagerException {
        FolderID parentID = childFolder.getParentFolderID();
        if (parentID.equals(FolderID.ROOT_FOLDER_ID)) {
            return null;
        }
        SummaryFolder parentFolder = null;
        try {
            parentFolder = parentID.getByIDQuery().selectSummaryView();
            if (parentFolder.getPluginID() != null) {
                return null;
            }
            FullPathFilter filter = new FullPathFilter(parentID, null, false);
            MultiComponentQuery compQ = MultiComponentQuery.all();
            compQ.setFullPathFilter(filter);
            if (compQ.selectExists()) {
                return null;
            }
            MultiExecutionPlanQuery planQ = MultiExecutionPlanQuery.all();
            planQ.setFullPathFilter(filter);
            if (planQ.selectExists()) {
                return null;
            }
            MultiFolderQuery folderQ = MultiFolderQuery.all();
            folderQ.setPathFilter(filter);
            SummaryFolder[] folders = folderQ.selectSummaryView();
            for (int i = 0; i < folders.length; ++i) {
                if (context.objectWillBeDeletedPriorTo(folders[i].getID(), this)) continue;
                return null;
            }
        }
        catch (RPCException e) {
            throw PluginException.unexpectedError(e);
        }
        return parentFolder;
    }

    private void addDependentComponentsAndTypes(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, SummaryComponent[] comps, ComponentTypeRef[] compTypes) throws PersistenceManagerException, RPCException {
        int i;
        HashMap<ComponentID, SummaryComponent> compsMap = new HashMap<ComponentID, SummaryComponent>();
        HashMap<ComponentTypeRefID, ComponentTypeRef> compTypesMap = new HashMap<ComponentTypeRefID, ComponentTypeRef>();
        for (i = 0; i < compTypes.length; ++i) {
            compTypesMap.put(compTypes[i].getID(), compTypes[i]);
        }
        for (i = 0; i < comps.length; ++i) {
            compsMap.put(comps[i].getID(), comps[i]);
        }
        HashMap compDependentsMap = this.getComponentDependents(compsMap);
        HashMap compTypeDependentsMap = this.getComponentTypeDependents(compTypesMap, compsMap);
        while (!compTypesMap.isEmpty() || !compsMap.isEmpty()) {
            boolean objectRemoved = false;
            HashSet<ComponentID> noDeleteComps = new HashSet<ComponentID>();
            ComponentTypeRef[] currentCompTypes = compTypesMap.values().toArray(new ComponentTypeRef[0]);
            for (int i2 = 0; i2 < currentCompTypes.length; ++i2) {
                ComponentTypeRef ctr = currentCompTypes[i2];
                boolean deletable = true;
                HashSet set = (HashSet)compTypeDependentsMap.get(ctr.getID());
                if (set != null) {
                    Iterator it = set.iterator();
                    while (it.hasNext() && deletable) {
                        ComponentID cID = (ComponentID)it.next();
                        if (inContext.objectWillBeDeletedPriorTo(cID, this)) continue;
                        deletable = false;
                    }
                }
                if (deletable) {
                    inDependentContainer.addDependentObject(ctr);
                    compTypesMap.remove(ctr.getID());
                    objectRemoved = true;
                    continue;
                }
                SummaryComponent comp = SingleComponentQuery.byRef(currentCompTypes[i2].getComponentRef()).selectSummaryView();
                noDeleteComps.add(comp.getID());
            }
            SummaryComponent[] currentComps = compsMap.values().toArray(new SummaryComponent[0]);
            for (int i3 = 0; i3 < currentComps.length; ++i3) {
                SummaryComponent comp = currentComps[i3];
                boolean deletable = true;
                if (!noDeleteComps.contains(comp.getID())) {
                    HashSet set = (HashSet)compDependentsMap.get(comp.getID());
                    if (set != null) {
                        Iterator it = set.iterator();
                        while (it.hasNext() && deletable) {
                            ComponentID cID = (ComponentID)it.next();
                            if (inContext.objectWillBeDeletedPriorTo(cID, this)) continue;
                            deletable = false;
                        }
                    }
                } else {
                    deletable = false;
                }
                if (!deletable) continue;
                inDependentContainer.addDependentObject(comp);
                compsMap.remove(comp.getID());
                objectRemoved = true;
            }
            if (objectRemoved) continue;
            throw PluginException.unexpectedError();
        }
    }

    private HashMap getComponentTypeDependents(HashMap compTypesMap, HashMap compsMap) throws PersistenceManagerException {
        HashMap<ComponentTypeRefID, HashSet<ComponentID>> map = new HashMap<ComponentTypeRefID, HashSet<ComponentID>>();
        ObjectID[] compTypeIDs = compTypesMap.keySet().toArray(new ComponentTypeRefID[0]);
        Link[] compLinks = CompTypeRefToComponentLinkTable.DEFAULT.getByParentIDs(compTypeIDs);
        for (int i = 0; i < compLinks.length; ++i) {
            ComponentTypeRefID ctID = (ComponentTypeRefID)compLinks[i].getParentObjectID();
            ComponentID cID = (ComponentID)compLinks[i].getChildObjectID();
            if (!compsMap.containsKey(cID)) continue;
            HashSet<ComponentID> set = (HashSet<ComponentID>)map.get(ctID);
            if (set == null) {
                set = new HashSet<ComponentID>();
                map.put(ctID, set);
            }
            set.add(cID);
        }
        return map;
    }

    private HashMap getComponentDependents(HashMap compsMap) throws PersistenceManagerException, RPCException {
        HashMap map = new HashMap();
        SummaryComponent[] comps = compsMap.values().toArray(new SummaryComponent[0]);
        for (int i = 0; i < comps.length; ++i) {
            ComponentID compID = comps[i].getID();
            HashSet<ComponentID> dependents = new HashSet<ComponentID>();
            Link[] containerLinks = ComponentToComponentLinkTable.DEFAULT.getByChildID(compID);
            for (int j = 0; j < containerLinks.length; ++j) {
                ComponentID containerID = (ComponentID)containerLinks[j].getParentObjectID();
                if (!compsMap.containsKey(containerID)) continue;
                dependents.add(containerID);
            }
            if (compID.equals(comps[i].getRootID())) {
                SummaryComponent[] otherVersions = compID.getAllVersionsQuery().selectSummaryView();
                for (int j = 0; j < otherVersions.length; ++j) {
                    if (otherVersions[j].getID().equals(compID)) continue;
                    dependents.add(otherVersions[j].getID());
                }
            }
            map.put(compID, dependents);
        }
        return map;
    }

    public Comparator getDeletionComparator() {
        return new PluginDeletionComparator();
    }

    class PluginDeleteRollback
    implements TopLevelTransactionListener {
        private String mPluginName;

        PluginDeleteRollback(String pluginName) {
            this.mPluginName = pluginName;
        }

        public void aboutToComplete(boolean isCommitable) throws PreCommitException {
        }

        public void transactionComplete(boolean isCommitted) throws PostTransactionException {
            try {
                if (isCommitted) {
                    String pluginDir = PluginImpl.getRepoRoot(this.mPluginName);
                    FileUtil.ensureDeleted(pluginDir);
                }
            }
            catch (Throwable t) {
                throw new PostTransactionException(t);
            }
        }
    }

    private static final class PluginDeletionComparator
    implements Comparator {
        private HashMap mCache = new HashMap();

        private PluginDeletionComparator() {
        }

        public boolean equals(Object o) {
            return o instanceof PluginDeletionComparator;
        }

        public int compare(Object lhs, Object rhs) {
            PluginIDSet lhsDependents;
            PluginID rhsID;
            block4: {
                PluginID lhsID = (PluginID)((HasObjectID)lhs).getObjectID();
                if (lhsID.equals(rhsID = (PluginID)((HasObjectID)rhs).getObjectID())) {
                    return 0;
                }
                lhsDependents = null;
                try {
                    lhsDependents = lhsID.getDependentChildren(this.mCache);
                }
                catch (PersistenceManagerException e) {
                    if (!Logger.isErrorEnabled(this)) break block4;
                    Logger.error("Unexpected PersistenceManagerException in PluginDeletionComparator.compare", e, this);
                }
            }
            if (lhsDependents.contains(rhsID)) {
                return 1;
            }
            return -1;
        }
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new PluginID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            PluginImplTable t = PluginImplTable.DEFAULT;
            SingleObjectByNameCache cache = new SingleObjectByNameCache(objectCache, t.Name);
            classMap.addSingleObjectCache(cache);
        }
    }
}

