/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.plugindb.Messages;
import java.io.File;

public class PluginException
extends PersistenceManagerException
implements Messages {
    protected PluginException() {
    }

    public PluginException(Throwable t) {
        super(t);
    }

    public PluginException(ROXMessage message) {
        super(message);
    }

    public PluginException(ROXMessage message, Throwable t) {
        super(message, t);
    }

    static PluginException emptySearchCriteria(String name) {
        return PluginException.newValidationError("plg.EMPTY_SEARCH_CRITERIA", name);
    }

    static PluginException jarEntryNotFound(String name) {
        return PluginException.newValidationError("plg.JAR_ENTRY_NOT_FOUND", name);
    }

    static PluginException invalidJarFile() {
        return PluginException.newValidationError("plg.INVALID_JAR_FILE");
    }

    static PluginException malFormedEntryName(String name) {
        return PluginException.newValidationError("plg.MALFORMED_ENTRY_NAME", name);
    }

    static PluginException descriptorNotSigned() {
        return PluginException.newValidationError("plg.DESCRIPTOR_NOT_SIGNED");
    }

    static PluginException tooManyCertificates() {
        return PluginException.newValidationError("plg.TOO_MANY_CERTIFICATES");
    }

    static PluginException folderCreationError(String pluginName, String pluginVersion, String folderName) {
        return PluginException.newValidationError("plg.FOLDER_CREATE_ERROR", new String[]{pluginName, pluginVersion, folderName});
    }

    static PluginException objectDependencyError(String pluginName, String pluginVersion, String objectType, String objectName) {
        return PluginException.newValidationError("plg.OBJECT_DEPENDENCY_ERROR", new String[]{pluginName, pluginVersion, objectType, objectName});
    }

    static PluginException notObjectOwnerError(String pluginName, String pluginVersion, String objectType, String objectName) {
        return PluginException.newValidationError("plg.NOT_OBJECT_OWNER", new String[]{pluginName, pluginVersion, objectType, objectName});
    }

    static PluginException invalidPluginVersion(String name, String version, String currentVersion, String expectedPreviousVersion) {
        return PluginException.newValidationError("plg.INVALID_PLUGIN_VERSION", new String[]{name, version, currentVersion, expectedPreviousVersion});
    }

    static PluginException invalidPreviousPluginVersion(String name, String version, String expectedPreviousVersion) {
        return PluginException.newValidationError("plg.INVALID_PREVIOUS_PLUGIN_VERSION", new String[]{name, version, expectedPreviousVersion});
    }

    static PluginException invalidDependency(String name, String version, String depName, String depVersion) {
        return PluginException.newValidationError("plg.INVALID_DEPENDENCY", new String[]{name, version, depName, depVersion});
    }

    static PluginException circularDependency(String name, String version, String depName, String depVersion) {
        return PluginException.newValidationError("plg.CIRCULAR_DEPENDENCY", new String[]{name, version, depName, depVersion});
    }

    static PluginException invalidMenuOrder() {
        return PluginException.newValidationError("plg.INVALID_MENU_ORDER", new String[0]);
    }

    static PluginException pluginExists(String name, String version) {
        return PluginException.newValidationError("plg.PLUGIN_EXISTS", new String[]{name, version});
    }

    static PluginException invalidPluginDir(File dir) {
        return PluginException.newSystemError("plg.INVALID_PLUGIN_DIR", new String[]{dir.toString()});
    }

    static PluginException invalidPluginFilename(String file) {
        return PluginException.newSystemError("plg.INVALID_PLUGIN_FILE", new String[]{file});
    }

    static PluginException unmatchedPluginFilename(String eName, VersionNumber eVersion, String aName, VersionNumber aVersion) {
        return PluginException.newSystemError("plg.UNMATCHED_PLUGIN_FILE", new String[]{eName, eVersion.getAsString(), aName, aVersion.getAsString()});
    }

    static PluginException importInterrupted(String name, VersionNumber version) {
        return PluginException.newSystemError("plg.IMPORT_INTERRUPTED", new String[]{name, version.getAsString()});
    }

    static PluginException certificateMismatch(String name, String version) {
        return PluginException.newValidationError("plg.CERTIFICATE_MISMATCH", new String[]{name, version});
    }

    static PluginException certificateSubjectDNMismatch(String name, String version, String newCertSubjectDN, String prevCertSubjectDN) {
        return PluginException.newValidationError("plg.CERTIFICATE_SUBJECT_DN_MISMATCH", new String[]{name, version, newCertSubjectDN, prevCertSubjectDN});
    }

    static PluginException certificateCACertMismatch(String name, String version, String newCertRootSubjectDN) {
        return PluginException.newValidationError("plg.CERTIFICATE_CA_CERT_MISMATCH", new String[]{name, version, newCertRootSubjectDN});
    }

    static PluginException certificateSelfSignedMismatch(String name, String version, String prevCertRootSubjectDN) {
        return PluginException.newValidationError("plg.CERTIFICATE_SS_CERT_MISMATCH", new String[]{name, version, prevCertRootSubjectDN});
    }

    static PluginException invalidSelfSignedCert(String name, String version) {
        return PluginException.newValidationError("plg.CERTIFICATE_SS_CERT_MISMATCH", new String[]{name, version});
    }

    static PluginException componentResourceMismatch(String name, String version, String resourceName, String componentName) {
        return PluginException.newValidationError("plg.COMPONENT_RESOURCE_MISMATCH", new String[]{name, version, resourceName, componentName});
    }

    static PluginException componentResourceMismatch2(String name, String version, String componentName, String resourceName) {
        return PluginException.newValidationError("plg.COMPONENT_RESOURCE_MISMATCH2", new String[]{name, version, componentName, resourceName});
    }

    static PluginException objectCreationError(String objectType, String objectIdentifier, PersistenceManagerException e) {
        return PluginException.newValidationError("plg.OBJECT_CREATION_ERROR", new String[]{objectType, objectIdentifier}, e);
    }

    static PluginException invalidCreateRepoState(String name) {
        return PluginException.newSystemError("plg.INVALID_CREATE_REPO_STATE", new String[]{name});
    }

    static PluginException resourceTypeMismatch(String name, String version, String resourceName, String declaredType, String actualType) {
        return PluginException.newValidationError("plg.RESOURCE_TYPE_MISMATCH", new String[]{name, version, resourceName, declaredType, actualType});
    }

    static PluginException cacertPasswordReadError() {
        return PluginException.newValidationError("plg.INVALID_CACERT_PASSWORD_ERROR");
    }

    static PluginException unexpectedError() {
        return PluginException.newSystemError("plg.UNEXPECTED_ERROR", new String[0]);
    }

    static PluginException unexpectedError(Throwable t) {
        return PluginException.newSystemError("plg.UNEXPECTED_ERROR", new String[0], t);
    }

    static PluginException newSystemError(String code, String[] args) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 3000);
        return new PluginException(msg);
    }

    static PluginException newSystemError(String code, String[] args, Throwable t) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 3000);
        return new PluginException(msg, t);
    }

    static PluginException newValidationError(String code) {
        return PluginException.newValidationError(code, new String[0]);
    }

    static PluginException newValidationError(String code, String arg) {
        return PluginException.newValidationError(code, new String[]{arg});
    }

    static PluginException newValidationError(String code, String[] args) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new PluginException(msg);
    }

    static PluginException newValidationError(String code, Throwable t) {
        return PluginException.newValidationError(code, new String[0], t);
    }

    static PluginException newValidationError(String code, String[] args, Throwable t) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new PluginException(msg, t);
    }
}

