/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plugindb.EntryVisitor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDependency;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginUIDescriptor;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.Replace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginDescriptor
implements RPCSerializable {
    private static final String DESCRIPTOR_ENTRY = "plugin-descriptor.xml";
    private static final int BUFFER_SIZE = 4096;
    private byte[] mJarBytes;
    private static final String PLUGIN_SCHEMA = "plugin.xsd";
    static final String ELEMENT_NAME = "plugin";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String VENDOR_ATTR = "vendor";
    private static final String VERSION_ATTR = "version";
    private static final String PREVIOUS_VERSION_ATTR = "previousVersion";
    private static final String SCHEMA_VERSION_ATTR = "schemaVersion";
    private static final String README_ELEMENT = "readme";
    private static final String SERVER_PLUGIN_JAR_ELEMENT = "serverPluginJAR";
    private static final String GUI_ELEMENT = "gui";
    private static final String JAR_PATH_ATTR = "jarPath";
    private static final String DEPENDENCY_LIST_ELEMENT = "dependencyList";
    private static final String MEMBER_LIST_ELEMENT = "memberList";
    private String mName;
    private String mDescription;
    private String mVendor;
    private VersionNumber mVersion;
    private VersionNumber mPreviousVersion;
    private String mSchemaVersion;
    private transient Certificate mCertificate;
    private transient Certificate[] mCertificateChain;
    private String mReadMe;
    private String mServerPluginJAR;
    private String mGUIDescriptorFile;
    private PluginUIDescriptor mGUIDescriptor;
    private Vector mDependencyList = new Vector();
    private Vector mMemberList = new Vector();
    static String UNIVERSAL_FILE_SEPARATOR = "/";

    private PluginDescriptor() {
    }

    public PluginDescriptor(InputStream jarIn, boolean inVerify) throws PersistenceManagerException, SystemModelParseException {
        this.mJarBytes = this.copyJarData(jarIn, inVerify);
        this.getCertificate();
        this.readFromXML(new InputSource(this.getEntryInputStream(DESCRIPTOR_ENTRY)));
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public VersionNumber getVersion() {
        return this.mVersion;
    }

    public VersionNumber getPreviousVersion() {
        return this.mPreviousVersion;
    }

    public String getSchemaVersion() {
        return this.mSchemaVersion;
    }

    public Certificate getCertificate() throws PluginException {
        if (this.mCertificate == null) {
            this.mCertificate = this.getCertificateForEntry(DESCRIPTOR_ENTRY);
        }
        return this.mCertificate;
    }

    public Certificate[] getCertificateChain() throws PluginException {
        if (this.mCertificateChain == null) {
            this.mCertificateChain = this.getCertificateChain(DESCRIPTOR_ENTRY);
        }
        return this.mCertificateChain;
    }

    public InputStream getReadMe() throws PluginException {
        if (this.mReadMe == null) {
            return null;
        }
        return this.getEntryInputStream(this.mReadMe);
    }

    public InputStream getServerPluginJAR() throws PluginException {
        if (this.mServerPluginJAR == null) {
            return null;
        }
        return this.getEntryInputStream(this.mServerPluginJAR);
    }

    public InputStream getGUIInputStream() throws PluginException {
        if (this.mGUIDescriptorFile == null) {
            return null;
        }
        return this.getEntryInputStream(this.mGUIDescriptorFile);
    }

    public PluginUIDescriptor getGUIDescriptor() {
        if (this.mGUIDescriptor != null) {
            this.mGUIDescriptor.setParentDescriptor(this);
        }
        return this.mGUIDescriptor;
    }

    public PluginDependency[] getDependencyList() {
        return this.mDependencyList.toArray(new PluginDependency[0]);
    }

    public PluginItem[] getItemList() {
        Iterator members = this.mMemberList.iterator();
        while (members.hasNext()) {
            PluginItem item = (PluginItem)members.next();
            item.setDescriptor(this);
        }
        return this.mMemberList.toArray(new PluginItem[0]);
    }

    private void readFromXML(InputSource inputSource) throws SystemModelParseException, PersistenceManagerException {
        Element topElement = this.parseInputSource(inputSource, true);
        this.parsePluginAttrs(topElement);
        this.parseReadMe(topElement);
        this.parseServerPluginJar(topElement);
        this.parseGUI(topElement);
        this.parseDependencyList(topElement);
        this.parseMemberList(topElement);
        if (this.mGUIDescriptorFile != null) {
            this.mGUIDescriptor = new PluginUIDescriptor(this.getGUIInputStream(), this);
        }
    }

    private Element parseInputSource(InputSource input, boolean reportErrors) throws SystemModelParseException, PersistenceManagerException {
        DOMParser parser = XMLUtil.obtainParser(reportErrors, PLUGIN_SCHEMA, "plg.");
        try {
            parser.parse(input);
            return parser.getDocument().getDocumentElement();
        }
        catch (IOException e) {
            throw PluginDescriptor.newParseError(e, "plg.");
        }
        catch (SAXException e) {
            throw PluginDescriptor.newParseError(e, "plg.");
        }
    }

    private void parsePluginAttrs(Element pluginElem) throws SystemModelParseException, PersistenceManagerException {
        this.mName = XMLUtil.getAttribute(pluginElem, NAME_ATTR);
        this.mDescription = XMLUtil.getAttribute(pluginElem, DESCRIPTION_ATTR);
        this.mVendor = XMLUtil.getAttribute(pluginElem, VENDOR_ATTR);
        this.mVersion = new VersionNumber(XMLUtil.getAttribute(pluginElem, VERSION_ATTR));
        String previousVersion = XMLUtil.getAttribute(pluginElem, PREVIOUS_VERSION_ATTR);
        if (previousVersion != null) {
            this.mPreviousVersion = new VersionNumber(previousVersion);
        }
        this.mSchemaVersion = XMLUtil.getAttribute(pluginElem, SCHEMA_VERSION_ATTR);
    }

    private void parseReadMe(Element pluginElem) throws PluginException {
        Element[] list = XMLUtil.getChildren(pluginElem, README_ELEMENT);
        if (list.length > 0) {
            this.mReadMe = XMLUtil.getAttribute(list[0], JAR_PATH_ATTR);
            this.getJarEntry(this.mReadMe);
        }
    }

    private void parseServerPluginJar(Element pluginElem) throws PluginException {
        Element[] list = XMLUtil.getChildren(pluginElem, SERVER_PLUGIN_JAR_ELEMENT);
        if (list.length > 0) {
            this.mServerPluginJAR = XMLUtil.getAttribute(list[0], JAR_PATH_ATTR);
            this.getJarEntry(this.mServerPluginJAR);
        }
    }

    private void parseGUI(Element pluginElem) throws PluginException {
        Element[] list = XMLUtil.getChildren(pluginElem, GUI_ELEMENT);
        if (list.length > 0) {
            this.mGUIDescriptorFile = XMLUtil.getAttribute(list[0], JAR_PATH_ATTR);
            this.getJarEntry(this.mGUIDescriptorFile);
        }
    }

    private void parseDependencyList(Element pluginElem) throws SystemModelParseException, PersistenceManagerException {
        this.mDependencyList.clear();
        Element[] list = XMLUtil.getChildren(pluginElem, DEPENDENCY_LIST_ELEMENT);
        if (list.length > 0) {
            Element[] pluginRefs = XMLUtil.getChildren(list[0], "pluginRef");
            for (int i = 0; i < pluginRefs.length; ++i) {
                this.mDependencyList.add(new PluginDependency(pluginRefs[i]));
            }
        }
    }

    private void parseMemberList(Element pluginElem) throws PersistenceManagerException, PluginException {
        this.mMemberList.clear();
        Element[] list = XMLUtil.getChildren(pluginElem, MEMBER_LIST_ELEMENT);
        if (list.length > 0) {
            Element[] items = XMLUtil.getChildren(list[0]);
            for (int i = 0; i < items.length; ++i) {
                this.mMemberList.add(PluginItem.readFromXML(items[i], this));
            }
        }
    }

    void visitAllEntriesUnder(String entryName, EntryVisitor visitor) throws PluginException {
        if (entryName == null) {
            throw PluginException.malFormedEntryName(entryName);
        }
        try {
            JarEntry entry;
            JarInputStream in = this.getJarInputStream();
            entryName = Replace.replace(entryName, File.separatorChar, UNIVERSAL_FILE_SEPARATOR);
            while ((entry = in.getNextJarEntry()) != null) {
                String subEntryName = entry.getName();
                subEntryName = Replace.replace(subEntryName, File.separatorChar, UNIVERSAL_FILE_SEPARATOR);
                ByteArrayInputStream stream = null;
                if (!PluginDescriptor.entryNameContainedBy(subEntryName, entryName)) continue;
                if (!entry.isDirectory()) {
                    stream = new ByteArrayInputStream(CopyUtil.readBinary(in));
                }
                visitor.visit(subEntryName, stream);
            }
        }
        catch (IOException e) {
            throw PluginException.unexpectedError(e);
        }
    }

    ByteArrayInputStream getEntryInputStream(String entryName) throws PluginException {
        if (entryName == null) {
            throw PluginException.malFormedEntryName(entryName);
        }
        try {
            JarEntry entry;
            JarInputStream in = this.getJarInputStream();
            while ((entry = in.getNextJarEntry()) != null) {
                if (!PluginDescriptor.entryNamesEqual(entryName, entry.getName())) continue;
                return new ByteArrayInputStream(CopyUtil.readBinary(in));
            }
        }
        catch (IOException e) {
            throw PluginException.invalidJarFile();
        }
        throw PluginException.jarEntryNotFound(entryName);
    }

    private byte[] copyJarData(InputStream in, boolean inVerify) throws PluginException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            CopyUtil.copyBinary(in, bytesOut);
            bytesOut.flush();
            bytesOut.close();
            in.close();
        }
        catch (IOException e) {
            throw PluginException.invalidJarFile();
        }
        if (bytesOut.toByteArray().length == 0 && Logger.isErrorEnabled(this)) {
            Logger.error("Unable to read the input stream", this);
        }
        try {
            JarEntry entry;
            JarInputStream jis = new JarInputStream((InputStream)new ByteArrayInputStream(bytesOut.toByteArray()), inVerify);
            if (jis.getManifest() == null) {
                throw PluginException.invalidJarFile();
            }
            OutputStream nullSink = new OutputStream(){

                public void write(int b) {
                }
            };
            while ((entry = jis.getNextJarEntry()) != null) {
                CopyUtil.copyBinary(jis, nullSink);
                jis.closeEntry();
            }
            jis.close();
        }
        catch (IOException io) {
            throw PluginException.invalidJarFile();
        }
        return bytesOut.toByteArray();
    }

    private JarInputStream getJarInputStream() throws IOException {
        return new JarInputStream(new ByteArrayInputStream(this.mJarBytes));
    }

    InputStream getByteArrayInputStream() {
        return new ByteArrayInputStream(this.mJarBytes);
    }

    JarEntry getJarEntry(String entryName) throws PluginException {
        return this.getJarEntry(entryName, false);
    }

    JarEntry getJarEntry(String entryName, boolean consume) throws PluginException {
        try {
            JarEntry entry;
            JarInputStream in = this.getJarInputStream();
            while ((entry = in.getNextJarEntry()) != null) {
                if (!PluginDescriptor.entryNamesEqual(entryName, entry.getName())) continue;
                if (consume) {
                    byte[] buf = new byte[4096];
                    while (in.read(buf, 0, buf.length) != -1) {
                    }
                }
                in.closeEntry();
                return entry;
            }
        }
        catch (IOException e) {
            throw PluginException.invalidJarFile();
        }
        throw PluginException.jarEntryNotFound(entryName);
    }

    private Certificate[] getCertificateChain(String entryName) throws PluginException {
        JarEntry entry = this.getJarEntry(entryName, true);
        return this.getCertificates(entry);
    }

    private Certificate getCertificateForEntry(String entryName) throws PluginException {
        Certificate[] certificates = this.getCertificateChain(entryName);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        for (int i = 0; i < certificates.length - 1; ++i) {
            try {
                certificates[i].verify(certificates[i + 1].getPublicKey());
                continue;
            }
            catch (GeneralSecurityException e) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Error verifying certificate", e, this);
                }
                throw PluginException.tooManyCertificates();
            }
        }
        return certificates[0];
    }

    private Certificate[] getCertificates(JarEntry entry) {
        try {
            Certificate[] certificates = entry.getCertificates();
            if (certificates != null) {
                return certificates;
            }
            Method getCodeSigners = entry.getClass().getMethod("getCodeSigners", new Class[0]);
            Object[] codeSigners = (Object[])getCodeSigners.invoke((Object)entry, new Object[0]);
            if (codeSigners != null && codeSigners.length > 0) {
                ArrayList<? extends Certificate> allCodeSignersCert = new ArrayList<Certificate>();
                for (int x = 0; x < codeSigners.length; ++x) {
                    Class<?> codeSigner = Class.forName("java.security.CodeSigner");
                    Method getSignerCertPath = codeSigner.getMethod("getSignerCertPath", new Class[0]);
                    CertPath certPath = (CertPath)getSignerCertPath.invoke(Array.get(codeSigners, x), new Object[0]);
                    allCodeSignersCert.addAll(certPath.getCertificates());
                }
                return allCodeSignersCert.toArray(new Certificate[allCodeSignersCert.size()]);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            Logger.error("Error collecting jar entry certificate", e);
        }
        return null;
    }

    private static boolean entryNamesEqual(String p1, String p2) {
        if (p1 == null) {
            return p2 == null;
        }
        p1 = Replace.replace(p1, File.separatorChar, UNIVERSAL_FILE_SEPARATOR);
        p2 = Replace.replace(p2, File.separatorChar, UNIVERSAL_FILE_SEPARATOR);
        return p1.equals(p2);
    }

    private static boolean entryNameContainedBy(String subEntryName, String entryName) {
        return entryName.equals(subEntryName) || entryName.endsWith(UNIVERSAL_FILE_SEPARATOR) && subEntryName.startsWith(entryName);
    }

    static SystemModelParseException newParseError(Exception e, String messagePrefix) {
        return new SystemModelParseException(e, messagePrefix);
    }
}

