/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginAutoLoader;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginEventListener;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSession;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginNotificationException;
import com.raplix.rolloutexpress.systemmodel.plugindb.SinglePluginQuery;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.file.FileUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.PasswordEscape;
import com.raplix.util.threads.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;

public class PluginDBSubsystem
extends Subsystem {
    private static PluginDBSubsystem sInstance;
    private Hashtable mImportSessions = new Hashtable();
    private PluginEventListener mListener;
    private PluginAutoLoader mAutoLoader;
    private static ROXMessage AUTO_LOAD_ERROR;
    private static final String CACERT_PASSWORD = "cacert.key.store.pass";
    private static final String CACERT_DEFAULT_PASSWORD = "1if6kro0qt8c4";
    private static final String VALIDATE_CERT_ON_RE_IMPORT = "validate.cert.on.reimport";
    private static final String VALIDATE_CERT_ON_NEW_IMPORT = "validate.cert.on.new.import";
    private boolean mIsAutoLoading;
    public static final String propertyPrefix = "plugindb.";
    private Context mGlobalImportContext;

    public static PluginDBSubsystem getInstance() {
        return sInstance;
    }

    synchronized Context getImportContext() {
        if (this.mGlobalImportContext == null) {
            this.setImportContext(new Context("Plugin_Import_Context"));
        }
        return this.mGlobalImportContext;
    }

    private synchronized void setImportContext(Context inContext) {
        this.mGlobalImportContext = inContext;
    }

    private PluginDBSubsystem() {
    }

    public PluginDBSubsystem(Application app) throws ConfigurationException {
        super(app);
        sInstance = this;
        this.mListener = new DummyListener();
        try {
            this.resetData();
            this.mAutoLoader = new PluginAutoLoader(this);
        }
        catch (IOException e) {
            throw new ConfigurationException(AUTO_LOAD_ERROR, (Throwable)e);
        }
        catch (PluginException e) {
            throw new ConfigurationException(e);
        }
        catch (UnsupportedSubsystemException e) {
            throw new ConfigurationException(AUTO_LOAD_ERROR, (Throwable)e);
        }
    }

    private void resetData() throws IOException {
        if (PersistenceManager.getInstance().isResettingData()) {
            FileUtil.ensureDeleted(PluginImpl.getRepoRoot());
        }
    }

    public void postInit() throws ConfigurationException {
        try {
            this.mIsAutoLoading = true;
            this.mAutoLoader.loadPlugins();
        }
        catch (PluginException e) {
            throw new ConfigurationException(e);
        }
        catch (PersistenceManagerException e) {
            throw new ConfigurationException(AUTO_LOAD_ERROR, (Throwable)e);
        }
        finally {
            this.mIsAutoLoading = false;
        }
    }

    public String[] getAutoLoadPluginNames() {
        return this.mAutoLoader.getAutoLoadPluginNames();
    }

    PluginImportSessionID createImportSession(PluginDescriptor descriptor) throws PersistenceManagerException {
        PluginImportSessionID sessionID = PluginImportSessionID.generateID();
        PluginImportSession session = new PluginImportSession(sessionID, descriptor, this.getImportContext());
        try {
            this.startSubsystemTask(session);
        }
        catch (Throwable t) {
            if (Logger.isErrorEnabled(this)) {
                Logger.debug("ERROR starting import task: " + t, this);
            }
            throw PluginException.unexpectedError(t);
        }
        this.setSession(sessionID, session);
        return sessionID;
    }

    PluginImportSession getSession(PluginImportSessionID sessionID) {
        return (PluginImportSession)this.mImportSessions.get(sessionID);
    }

    void setSession(PluginImportSessionID sessionID, PluginImportSession session) {
        this.mImportSessions.put(sessionID, session);
    }

    public void registerPluginEventListener(PluginEventListener listener) {
        this.mListener = listener;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        DefaultConfiguration[] defaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration(CACERT_PASSWORD, CACERT_DEFAULT_PASSWORD, "The jre/lib/cacert keystore encoded password, encoded using crkeys."), new DefaultConfiguration(VALIDATE_CERT_ON_RE_IMPORT, "true", "The default behaviour to validate the plugin certificate during a re-import."), new DefaultConfiguration(VALIDATE_CERT_ON_NEW_IMPORT, "true", "The default behaviour to validate the plugin certificate during a new import.")};
        return defaultConfiguration;
    }

    protected String getConfigurationPropertyPrefix() {
        return propertyPrefix;
    }

    public String getConfigCacertKeyStorePass() throws ConfigurationException {
        try {
            return PasswordEscape.decodePassword(this.getConfigurationAsString(CACERT_PASSWORD));
        }
        catch (IOException io) {
            throw new ConfigurationException(io);
        }
    }

    public boolean isAutoLoading() {
        return this.mIsAutoLoading;
    }

    public boolean getConfigValidateCertOnReimport() throws ConfigurationException {
        return this.getConfigurationAsBoolean(VALIDATE_CERT_ON_RE_IMPORT);
    }

    public boolean getConfigValidateCertOnNewimport() throws ConfigurationException {
        return this.getConfigurationAsBoolean(VALIDATE_CERT_ON_NEW_IMPORT);
    }

    PluginEventListener getPluginEventListener() {
        return this.mListener;
    }

    void pluginAdded(PluginID pluginID) throws PluginNotificationException {
        this.checkListener();
        this.mListener.pluginAdded(pluginID);
    }

    void pluginDeleted(PluginID pluginID) throws PluginNotificationException {
        this.checkListener();
        this.mListener.pluginDeleted(pluginID);
    }

    void pluginEdited(PluginID pluginID) throws PluginNotificationException {
        this.checkListener();
        this.mListener.pluginEdited(pluginID);
    }

    void transform(PluginID pluginID, InputStream in, OutputStream out) throws PluginNotificationException {
        this.checkListener();
        this.mListener.transform(pluginID, in, out);
    }

    void checkListener() throws PluginNotificationException {
        if (this.mListener == null) {
            throw new PluginNotificationException(PluginException.unexpectedError());
        }
    }

    void cancelDelete(PluginImportSessionID importSessionID) throws PluginException {
        PluginImportSession session = this.getSession(importSessionID);
        if (session == null) {
            throw PluginException.unexpectedError();
        }
        session.cancel();
    }

    public void createRepoForPlugin(PluginDescriptor desc) throws PersistenceManagerException, RPCException, IOException {
        Plugin plugin = SinglePluginQuery.byName(desc.getName()).select();
        plugin.createRepoFromDescriptorMS(desc);
    }

    static {
        AUTO_LOAD_ERROR = new ROXMessage("plg.PLUGIN_AUTO_LOAD_ERROR");
    }

    private class DummyListener
    implements PluginEventListener {
        private DummyListener() {
        }

        public void DummyListener() {
        }

        public void pluginAdded(PluginID pluginID) throws PluginNotificationException {
        }

        public void transform(PluginID pluginID, InputStream in, OutputStream out) throws PluginNotificationException {
            try {
                String input = new String(CopyUtil.readText(new InputStreamReader(in)));
                String test = "transform" + input;
                out.write(test.getBytes());
            }
            catch (IOException e) {
                throw new PluginNotificationException(e);
            }
        }

        public void pluginDeleted(PluginID pluginID) throws PluginNotificationException {
        }

        public void pluginEdited(PluginID pluginID) throws PluginNotificationException {
        }
    }
}

