/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDependency;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginEventListener;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginIDSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginNotificationException;
import com.raplix.rolloutexpress.systemmodel.plugindb.SinglePluginQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class PluginAutoLoader {
    private PluginDBSubsystem mPluginDB;
    private HashMap mNameToVersionsMap;
    private File mPluginDir;
    private UserID mAdminUserID;
    private static final String PLUGIN_SUFFIX = ".jar";
    private static final char VERSION_SEP = '_';
    private static final String UPGRADE_VERSION_SEP = "to";
    private static final VersionNumber NO_UPGRADE_VERSION = new VersionNumber(0);

    public PluginAutoLoader(PluginDBSubsystem pluginDB) throws IOException, PluginException, UnsupportedSubsystemException {
        this.mPluginDB = pluginDB;
        Application app = this.mPluginDB.getApplication();
        this.mPluginDir = new File(app.getHomeDirAbsPath() + File.separator + "custom" + File.separator + "plugins");
        this.mNameToVersionsMap = this.readPluginDir();
        this.mAdminUserID = app.getUserDBSubsystem().getLocalUserDBAdmin().getUserManager().getAdminUserID();
    }

    public synchronized void loadPlugins() throws PersistenceManagerException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("starting to load plug-ins", this);
        }
        PluginEventListener origListener = this.mPluginDB.getPluginEventListener();
        AddUserListener newListener = new AddUserListener(origListener);
        this.mPluginDB.registerPluginEventListener(newListener);
        try {
            HashSet loadedPluginNames = new HashSet();
            PluginIDSet loadedPlugins = new PluginIDSet();
            Iterator pluginsToLoad = this.mNameToVersionsMap.keySet().iterator();
            while (pluginsToLoad.hasNext()) {
                this.loadAllVersionsOf((String)pluginsToLoad.next(), loadedPluginNames, loadedPlugins);
            }
        }
        catch (RPCException e) {
            throw PluginException.unexpectedError(e);
        }
        catch (IOException e) {
            throw PluginException.unexpectedError(e);
        }
        finally {
            this.mPluginDB.registerPluginEventListener(origListener);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("plugin-in loading complete", this);
        }
    }

    public String[] getAutoLoadPluginNames() {
        return this.mNameToVersionsMap.keySet().toArray(new String[0]);
    }

    private HashMap readPluginDir() throws IOException, PluginException {
        String[] files = this.mPluginDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(PluginAutoLoader.PLUGIN_SUFFIX);
            }
        });
        if (files == null) {
            throw PluginException.invalidPluginDir(this.mPluginDir);
        }
        HashMap result = new HashMap();
        for (int i = 0; i < files.length; ++i) {
            VersionNumber storedNewVersion;
            VersionNumber newVersion;
            VersionNumber oldVersion;
            String file = files[i];
            int ndx = file.lastIndexOf(95);
            if (ndx == -1) {
                throw PluginException.invalidPluginFilename(file);
            }
            String pluginName = file.substring(0, ndx);
            String versionPart = file.substring(ndx + 1, file.length() - PLUGIN_SUFFIX.length());
            if ((ndx = versionPart.indexOf(UPGRADE_VERSION_SEP)) == -1) {
                oldVersion = NO_UPGRADE_VERSION;
                newVersion = this.parseVersion(file, versionPart, 0, versionPart.length());
            } else {
                oldVersion = this.parseVersion(file, versionPart, 0, ndx);
                newVersion = this.parseVersion(file, versionPart, ndx + UPGRADE_VERSION_SEP.length(), versionPart.length());
            }
            HashMap<VersionNumber, VersionNumber> versionMap = (HashMap<VersionNumber, VersionNumber>)result.get(pluginName);
            if (versionMap == null) {
                versionMap = new HashMap<VersionNumber, VersionNumber>();
                result.put(pluginName, versionMap);
            }
            if ((storedNewVersion = (VersionNumber)versionMap.get(oldVersion)) != null && !newVersion.isGreaterThan(storedNewVersion)) continue;
            versionMap.put(oldVersion, newVersion);
        }
        return result;
    }

    private VersionNumber parseVersion(String file, String versionStr, int start, int end) throws PluginException {
        try {
            return new VersionNumber(versionStr.substring(start, end));
        }
        catch (PersistenceManagerException e) {
            throw PluginException.invalidPluginFilename(file);
        }
    }

    private void loadAllVersionsOf(String pluginName, HashSet loadedPluginNames, PluginIDSet loadedPlugins) throws PersistenceManagerException, IOException, RPCException {
        VersionNumber newVersion;
        VersionNumber currentVersion;
        if (loadedPluginNames.contains(pluginName)) {
            return;
        }
        Map availableVersions = (Map)this.mNameToVersionsMap.get(pluginName);
        if (availableVersions == null) {
            return;
        }
        loadedPluginNames.add(pluginName);
        try {
            currentVersion = SinglePluginQuery.byName(pluginName).selectSummaryView().getVersionNumber();
        }
        catch (NoResultsFoundException e) {
            currentVersion = NO_UPGRADE_VERSION;
        }
        while ((newVersion = (VersionNumber)availableVersions.get(currentVersion)) != null) {
            this.loadPlugin(pluginName, currentVersion, newVersion, loadedPluginNames, loadedPlugins);
            currentVersion = newVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlugin(String pluginName, VersionNumber oldVersion, VersionNumber newVersion, HashSet loadedPluginNames, PluginIDSet loadedPlugins) throws PersistenceManagerException, IOException, RPCException {
        String fileName = pluginName + '_';
        if (!oldVersion.equals(NO_UPGRADE_VERSION)) {
            fileName = fileName + oldVersion.getAsString() + UPGRADE_VERSION_SEP;
        }
        fileName = fileName + newVersion.getAsString() + PLUGIN_SUFFIX;
        File pluginFile = new File(this.mPluginDir, fileName);
        FileInputStream pluginStream = new FileInputStream(pluginFile);
        try {
            this.loadPlugin(new PluginDescriptor(pluginStream, true), pluginName, newVersion, loadedPluginNames, loadedPlugins);
        }
        finally {
            ((InputStream)pluginStream).close();
        }
    }

    private void loadPlugin(PluginDescriptor desc, String expectedName, VersionNumber expectedVersion, HashSet loadedPluginNames, PluginIDSet loadedPlugins) throws PersistenceManagerException, IOException, RPCException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("loading plug-in: " + expectedName + " v." + expectedVersion.getAsString(), this);
        }
        if (!expectedName.equals(desc.getName()) || !expectedVersion.equals(desc.getVersion())) {
            throw PluginException.unmatchedPluginFilename(expectedName, expectedVersion, desc.getName(), desc.getVersion());
        }
        PluginDependency[] dependencies = desc.getDependencyList();
        for (int i = 0; i < dependencies.length; ++i) {
            this.loadAllVersionsOf(dependencies[i].getName(), loadedPluginNames, loadedPlugins);
        }
        PluginID result = Plugin.importPlugin(desc).join();
        if (result == null) {
            throw PluginException.importInterrupted(expectedName, expectedVersion);
        }
        loadedPlugins.add(result);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("plug-in load complete: " + expectedName + " v." + expectedVersion.getAsString(), this);
        }
    }

    private void updateUsers(PluginID plugin) throws PluginNotificationException {
        try {
            ComponentImplTable ct = ComponentImplTable.DEFAULT;
            ComponentImplTable.execute(ct.update(ComponentImplTable.uList(ComponentImplTable.set(ct.UserID, this.mAdminUserID)), ComponentImplTable.where(ComponentImplTable.and(ComponentImplTable.equals(ct.PluginID, plugin), ComponentImplTable.isNull(ct.UserID)))));
            ExecutionPlanImplTable pt = ExecutionPlanImplTable.DEFAULT;
            ExecutionPlanImplTable.execute(pt.update(ExecutionPlanImplTable.uList(ExecutionPlanImplTable.set(pt.UserID, this.mAdminUserID)), ExecutionPlanImplTable.where(ExecutionPlanImplTable.and(ExecutionPlanImplTable.equals(pt.PluginID, plugin), ExecutionPlanImplTable.isNull(pt.UserID)))));
            ResourceTable rt = ResourceTable.DEFAULT;
            ResourceTable.execute(rt.update(ResourceTable.uList(ResourceTable.set(rt.UserID, this.mAdminUserID)), ResourceTable.where(ResourceTable.and(ResourceTable.equals(rt.PluginID, plugin), ResourceTable.isNull(rt.UserID)))));
        }
        catch (PersistenceManagerException e) {
            throw new PluginNotificationException(e);
        }
    }

    private class AddUserListener
    implements PluginEventListener {
        private PluginEventListener mDelegate;

        public AddUserListener(PluginEventListener delegate) {
            this.mDelegate = delegate;
        }

        public void pluginAdded(PluginID pluginID) throws PluginNotificationException {
            PluginAutoLoader.this.updateUsers(pluginID);
            this.mDelegate.pluginAdded(pluginID);
        }

        public void transform(PluginID plugin, InputStream in, OutputStream out) throws PluginNotificationException {
            this.mDelegate.transform(plugin, in, out);
        }

        public void pluginDeleted(PluginID pluginID) throws PluginNotificationException {
            this.mDelegate.pluginDeleted(pluginID);
        }

        public void pluginEdited(PluginID pluginID) throws PluginNotificationException {
            this.mDelegate.pluginEdited(pluginID);
        }
    }
}

