/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.ResourceIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginIDSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSession;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMemberWritePermission;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.util.Validate;
import java.io.IOException;
import java.security.AccessController;
import java.security.cert.Certificate;

public class Plugin
extends SummaryPlugin
implements Cloneable {
    public static String DEFAULT_MENU_ORDER = "";
    public static String NAME_SEPARATOR = "#";
    private boolean mPluginIsCopy;
    private static final int MAX_NAME_LENGTH = 64;

    public static PluginImportSessionID importPlugin(final PluginDescriptor descriptor) throws PersistenceManagerException, RPCException {
        PluginImportSessionIDCtx result = (PluginImportSessionIDCtx)Plugin.transactRPC(new RPCTransaction(false){

            protected PersistContext executeMS() throws PersistenceManagerException {
                return Plugin.trImportPluginMS(descriptor);
            }
        });
        return result.getID();
    }

    static PluginImportSessionIDCtx trImportPluginMS(PluginDescriptor descriptor) throws PersistenceManagerException {
        PluginImportSessionID sessionID = PluginDBSubsystem.getInstance().createImportSession(descriptor);
        return new PluginImportSessionIDCtx(sessionID);
    }

    static PersistContext transactRPC(RPCTransaction transaction) throws PersistenceManagerException, RPCException {
        return PersistentServicesInit.transact(transaction);
    }

    public static void checkWritePermissions(PluginMember member) {
        PluginID pID = member.getPluginID();
        if (pID != null) {
            PluginMemberWritePermission perm = new PluginMemberWritePermission(pID);
            AccessController.checkPermission(perm);
        }
    }

    Plugin() {
        super(PluginImpl.create());
        this.mPluginIsCopy = true;
    }

    Plugin(PluginImpl plugin) {
        super(plugin);
        this.mPluginIsCopy = false;
    }

    public void save() throws PluginException, PersistenceManagerException, RPCException {
        this.getMutablePlugin().save(null);
    }

    void readFromDescriptor(PluginDescriptor pd, PluginImportSession session) throws PluginException, PersistenceManagerException, RPCException {
        this.getMutablePlugin().readFromDescriptor(pd, session);
    }

    public static void validateMenuOrder(String order) throws PluginException {
        int len = order.length();
        if (len > 64) {
            throw PluginException.invalidMenuOrder();
        }
        if (!Validate.hasValidDescriptionChars(order)) {
            throw PluginException.invalidMenuOrder();
        }
    }

    public void validate() throws PluginException {
        this.getPlugin().validate();
    }

    private PluginImpl getMutablePlugin() {
        if (!this.mPluginIsCopy) {
            this.setPlugin((PluginImpl)this.getPlugin().clone());
            this.mPluginIsCopy = true;
        }
        return this.getPlugin();
    }

    public void setMenuOrder(String menuOrder) {
        this.getMutablePlugin().setMenuOrder(menuOrder);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutablePlugin().setUpdateCount(updateCount);
    }

    public ComponentIDSet getComponents() {
        return this.getPlugin().getComponents();
    }

    public ExecutionPlanIDSet getPlans() {
        return this.getPlugin().getPlans();
    }

    public HostTypeIDSet getHostTypes() {
        return this.getPlugin().getHostTypes();
    }

    public HostSearchIDSet getHostSearches() {
        return this.getPlugin().getHostSearches();
    }

    public HostSetIDSet getHostSets() {
        return this.getPlugin().getHostSets();
    }

    public FolderIDSet getFolders() {
        return this.getPlugin().getFolders();
    }

    public ComponentTypeRefIDSet getComponentTypes() {
        return this.getPlugin().getComponentTypes();
    }

    public SystemServiceRefIDSet getSystemServices() {
        return this.getPlugin().getSystemServices();
    }

    public ResourceIDSet getResources() {
        return this.getPlugin().getResources();
    }

    public String getServerPluginJARPath() {
        return this.getPlugin().getServerPluginJARPath();
    }

    public String getReadMeText() {
        return this.getPlugin().getReadMeText();
    }

    public String getCustomPagePath() {
        return this.getPlugin().getCustomPagePath();
    }

    public Certificate getCertificate() {
        return this.getPlugin().getCertificate();
    }

    public String getCertificateText() {
        return this.getPlugin().getCertificate() == null ? null : this.getPlugin().getCertificate().toString();
    }

    public String getIconPath() {
        return this.getPlugin().getIconPath();
    }

    public PluginIDSet getDependencies() {
        return this.getPlugin().getDependencies();
    }

    public Object clone() {
        if (this.mPluginIsCopy) {
            return new Plugin((PluginImpl)this.getPlugin().clone());
        }
        return new Plugin(this.getPlugin());
    }

    void createRepoFromDescriptorMS(PluginDescriptor desc) throws PersistenceManagerException, IOException {
        this.getMutablePlugin().createRepoFromDescriptorMS(desc);
    }

    public void validateNamespace(PluginID objPlId, String objName, String objType) throws PluginException {
        if (this.getID().equals(objPlId)) {
            return;
        }
        PluginIDSet deps = this.getDependencies();
        if (objPlId == null || !deps.contains(objPlId)) {
            throw PluginException.objectDependencyError(this.getName(), this.getVersionNumber().getAsString(), objType, objName);
        }
    }

    static final class PluginImportSessionIDCtx
    extends PersistContext {
        private PluginImportSessionID mSessionID;

        public PluginImportSessionIDCtx(PluginImportSessionID sessionID) {
            this.setID(sessionID);
        }

        public PluginImportSessionID getID() {
            return this.mSessionID;
        }

        private void setID(PluginImportSessionID sessionID) {
            this.mSessionID = sessionID;
        }
    }
}

