/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.SingleExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import java.io.InputStream;
import org.w3c.dom.Element;

public class PlanItem
extends PluginItem {
    static final String ELEMENT_NAME = "plan";
    private static final String JAR_PATH_ATTR = "jarPath";
    private static final String MAJOR_VERSION_ATTR = "majorVersion";
    private String mJarPath;
    private boolean mMajorVersion;

    private PlanItem() {
    }

    PlanItem(Element element, PluginDescriptor descriptor) throws PluginException {
        this.setDescriptor(descriptor);
        this.setJarPath(XMLUtil.getAttribute(element, JAR_PATH_ATTR));
        this.setMajorVersion(XMLUtil.getBooleanAttribute(element, MAJOR_VERSION_ATTR, false));
    }

    public InputStream getInputStream() throws PluginException {
        return this.mDescriptor.getEntryInputStream(this.getJarPath());
    }

    private String getJarPath() {
        return this.mJarPath;
    }

    private void setJarPath(String jarPath) throws PluginException {
        this.mDescriptor.getJarEntry(jarPath);
        this.mJarPath = jarPath;
    }

    public boolean getMajorVersion() {
        return this.mMajorVersion;
    }

    private void setMajorVersion(boolean majorVersion) {
        this.mMajorVersion = majorVersion;
    }

    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        ExecutionPlan plan = new ExecutionPlan(plugin.getID());
        VersionedSaveContext context = new VersionedSaveContext();
        context.setSaveAsNewMajor(this.mMajorVersion);
        try {
            ExecutionPlan latest;
            plan.readFromXML(this.mDescriptor.getEntryInputStream(this.mJarPath));
            String xml = plan.writeToXML();
            SingleExecutionPlanQuery query = SingleExecutionPlanQuery.byName(plan.getPath(), plan.getName(), null);
            plan = latest = query.select();
            plan.readFromXML(xml);
            context.setLatestVersion(plan.getVersionNumber());
            context.setHideObjectID(plan.getID());
        }
        catch (NoResultsFoundException e) {
            // empty catch block
        }
        PlanItem.validatePluginOwnership(plugin, plan.getPluginID(), ELEMENT_NAME, plan.getName());
        plan.save(context);
        plugin.addPlan(plan.getID());
        return plan;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(ExecutionPlanImplTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mJarPath;
    }
}

