/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVar;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVarList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import org.w3c.dom.Element;

public class HostTypeItem
extends PluginItem {
    static final String ELEMENT_NAME = "hostType";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String VAR_LIST_ELEMENT = "varList";
    private static final String VAR_ELEMENT_NAME = "var";
    private static final String DEFAULT_ATTR = "default";
    private String mName;
    private String mDescription;
    private HostTypeVarList mVarList;

    private HostTypeItem() {
    }

    HostTypeItem(Element element) {
        this.setName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setDescription(XMLUtil.getAttribute(element, DESCRIPTION_ATTR));
        this.mVarList = new HostTypeVarList();
        Element[] list = XMLUtil.getChildren(element, VAR_LIST_ELEMENT);
        if (list.length > 0) {
            Element[] hostTypeVars = XMLUtil.getChildren(list[0], VAR_ELEMENT_NAME);
            for (int i = 0; i < hostTypeVars.length; ++i) {
                this.mVarList.add(i, new HostTypeVar(XMLUtil.getAttribute(hostTypeVars[i], NAME_ATTR), XMLUtil.getAttributeEmptyAllowed(hostTypeVars[i], DEFAULT_ATTR)));
            }
        }
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    public HostTypeVarList getVarList() {
        return this.mVarList;
    }

    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        HostType hostType = null;
        try {
            SingleHostTypeQuery query = SingleHostTypeQuery.byName(plugin.getName() + Plugin.NAME_SEPARATOR + this.mName);
            hostType = query.select();
        }
        catch (NoResultsFoundException e) {
            hostType = new HostType(plugin.getID());
        }
        hostType.setSimpleName(this.mName);
        if (this.mDescription != null) {
            hostType.setDescription(this.mDescription);
        }
        hostType.setVarList(this.mVarList);
        hostType.save(false);
        plugin.addHostType(hostType.getID());
        return hostType;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(HostTypeImplTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mName;
    }
}

