/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import java.util.Vector;
import org.w3c.dom.Element;

public class HostSetItem
extends PluginItem {
    static final String ELEMENT_NAME = "hostSet";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String UNSUPPORTED_ATTR = "unsupported";
    private static final String HOST_SET_ELEMENT_NAME = "hostSetRef";
    private static final String HOST_SEARCH_ELEMENT_NAME = "hostSearchRef";
    private String mName;
    private String mDescription;
    private boolean mIsUnsupported;
    private Vector mMemberHostSets;
    private Vector mMemberHostSearches;

    private HostSetItem() {
    }

    HostSetItem(Element element) {
        this.setName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setDescription(XMLUtil.getAttribute(element, DESCRIPTION_ATTR));
        this.setIsUnsupported(XMLUtil.getBooleanAttribute(element, UNSUPPORTED_ATTR, false));
        this.mMemberHostSets = this.getHostEntityReferences(element, HOST_SET_ELEMENT_NAME);
        this.mMemberHostSearches = this.getHostEntityReferences(element, HOST_SEARCH_ELEMENT_NAME);
    }

    private Vector getHostEntityReferences(Element element, String refName) {
        Vector<String> v = new Vector<String>();
        Element[] refs = XMLUtil.getChildren(element, refName);
        for (int i = 0; i < refs.length; ++i) {
            v.add(XMLUtil.getAttribute(refs[i], NAME_ATTR));
        }
        return v;
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    public boolean getIsUnsupported() {
        return this.mIsUnsupported;
    }

    private void setIsUnsupported(boolean isUnsupported) {
        this.mIsUnsupported = isUnsupported;
    }

    public String[] getMemberHostSets() {
        return this.mMemberHostSets.toArray(new String[0]);
    }

    public String[] getMemberHostSearches() {
        return this.mMemberHostSearches.toArray(new String[0]);
    }

    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        boolean shouldThrow = false;
        HostSet hostSet = null;
        try {
            SingleHostSetQuery query = SingleHostSetQuery.byName(plugin.getName() + Plugin.NAME_SEPARATOR + this.mName);
            hostSet = query.select();
        }
        catch (NoResultsFoundException e) {
            hostSet = new HostSet(plugin.getID());
        }
        hostSet.setSimpleName(this.mName);
        if (this.mDescription != null) {
            hostSet.setDescription(this.mDescription);
        }
        hostSet.setIsSupported(!this.getIsUnsupported());
        String[] hostSearchNames = this.getMemberHostSearches();
        HostSearchIDSet hostSearches = new HostSearchIDSet();
        for (int i = 0; i < hostSearchNames.length; ++i) {
            String hostSearchOrigName = hostSearchNames[i];
            String hostSearchName = hostSearchOrigName;
            if (hostSearchName.indexOf(Plugin.NAME_SEPARATOR) == -1) {
                hostSearchName = plugin.getName() + Plugin.NAME_SEPARATOR + hostSearchName;
            }
            SingleHostSearchQuery query = SingleHostSearchQuery.byName(hostSearchName);
            SummaryHostSearch sHostSearch = null;
            try {
                sHostSearch = query.selectSummaryView();
                PluginID pluginID = sHostSearch.getPluginID();
                if (!plugin.getID().equals(pluginID) && !plugin.getDependencies().contains(pluginID)) {
                    shouldThrow = true;
                }
            }
            catch (NoResultsFoundException e) {
                shouldThrow = true;
            }
            if (shouldThrow) {
                throw PluginException.objectDependencyError(plugin.getName(), plugin.getVersionNumber().getAsString(), "hostSearch", hostSearchOrigName);
            }
            hostSearches.add(sHostSearch.getID());
        }
        hostSet.setMemberHostSearchIDSet(hostSearches);
        String[] hostSetNames = this.getMemberHostSets();
        HostSetIDSet hostSets = new HostSetIDSet();
        for (int i = 0; i < hostSetNames.length; ++i) {
            String hostSetOrigName = hostSetNames[i];
            String hostSetName = hostSetOrigName;
            if (hostSetName.indexOf(Plugin.NAME_SEPARATOR) == -1) {
                hostSetName = plugin.getName() + Plugin.NAME_SEPARATOR + hostSetName;
            }
            SingleHostSetQuery query = SingleHostSetQuery.byName(hostSetName);
            SummaryHostSet sHostSet = null;
            try {
                sHostSet = query.selectSummaryView();
                PluginID pluginID = sHostSet.getPluginID();
                if (!plugin.getID().equals(pluginID) && !plugin.getDependencies().contains(pluginID)) {
                    shouldThrow = true;
                }
            }
            catch (NoResultsFoundException e) {
                shouldThrow = true;
            }
            if (shouldThrow) {
                throw PluginException.objectDependencyError(plugin.getName(), plugin.getVersionNumber().getAsString(), ELEMENT_NAME, hostSetOrigName);
            }
            hostSets.add(query.selectSummaryView().getID());
        }
        hostSet.setMemberHostSetIDSet(hostSets);
        hostSet.save();
        plugin.addHostSet(hostSet.getID());
        return hostSet;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(HostSetImplTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mName;
    }
}

