/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppTypeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ComparisonType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.PhysicalCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.util.regex.GlobPattern;
import org.w3c.dom.Element;

public class HostSearchItem
extends PluginItem {
    private String mName;
    private String mDescription;
    private HostSearchCriteria mCriteria;
    static final String ELEMENT_NAME = "hostSearch";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String APP_TYPE_ELEMENT_NAME = "appTypeCriteria";
    private static final String PHYSICAL_ELEMENT_NAME = "physicalCriteria";
    private static final String CRITERIA_LIST_ELEMENT = "criteriaList";
    private static final String CRITERIA_ELEMENT_NAME = "criteria";
    private static final String PATTERN_ATTR = "pattern";
    private static final String MATCH_ATTR = "match";
    private static final String MS_ATTR = "ms";
    private static final String LD_ATTR = "ld";
    private static final String RA_ATTR = "ra";
    private static final String PHYSICAL_ATTR = "physical";
    private static final String VIRTUAL_ATTR = "virtual";

    private HostSearchItem() {
    }

    HostSearchItem(Element element) throws PluginException {
        this.setName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setDescription(XMLUtil.getAttribute(element, DESCRIPTION_ATTR));
        this.mCriteria = new HostSearchCriteria();
        this.mCriteria.setAttributeCriteriaList(this.readCriteriaList(element));
        this.mCriteria.setAppTypeCriteria(this.readAppTypeCriteria(element));
        this.mCriteria.setPhysicalCriteria(this.readPhysicalCriteria(element));
        if (this.mCriteria.isEmptyCriteria()) {
            throw PluginException.emptySearchCriteria(this.getName());
        }
    }

    private AttributeCriteriaList readCriteriaList(Element element) {
        AttributeCriteriaList attrCriteriaList = new AttributeCriteriaList();
        Element[] list = XMLUtil.getChildren(element, CRITERIA_LIST_ELEMENT);
        if (list.length > 0) {
            Element[] criteriaList = XMLUtil.getChildren(list[0], CRITERIA_ELEMENT_NAME);
            for (int i = 0; i < criteriaList.length; ++i) {
                Element criteriaElem = criteriaList[i];
                String name = XMLUtil.getAttribute(criteriaElem, NAME_ATTR);
                ComparisonType comparisonType = ComparisonType.EQUALS;
                String matchStr = XMLUtil.getAttribute(criteriaElem, MATCH_ATTR);
                if (matchStr != null) {
                    comparisonType = ComparisonType.FACTORY.get(matchStr.toLowerCase());
                }
                GlobPattern globPattern = GlobPattern.create(XMLUtil.getAttribute(criteriaElem, PATTERN_ATTR));
                attrCriteriaList.add(AttributeCriteria.create(name, comparisonType, globPattern));
            }
        }
        return attrCriteriaList;
    }

    private AppTypeCriteria readAppTypeCriteria(Element element) {
        AppTypeCriteria appTypeCriteria = new AppTypeCriteria();
        Element[] list = XMLUtil.getChildren(element, APP_TYPE_ELEMENT_NAME);
        if (list.length > 0) {
            Element appType = list[0];
            appTypeCriteria.setIncludeMS(XMLUtil.getBooleanAttribute(appType, MS_ATTR, false));
            appTypeCriteria.setIncludeLD(XMLUtil.getBooleanAttribute(appType, LD_ATTR, false));
            appTypeCriteria.setIncludeRA(XMLUtil.getBooleanAttribute(appType, RA_ATTR, false));
        }
        return appTypeCriteria;
    }

    private PhysicalCriteria readPhysicalCriteria(Element element) {
        PhysicalCriteria physicalCriteria = new PhysicalCriteria();
        Element[] list = XMLUtil.getChildren(element, PHYSICAL_ELEMENT_NAME);
        if (list.length > 0) {
            Element physical = list[0];
            physicalCriteria.setIncludePhysical(XMLUtil.getBooleanAttribute(physical, PHYSICAL_ATTR, false));
            physicalCriteria.setIncludeVirtual(XMLUtil.getBooleanAttribute(physical, VIRTUAL_ATTR, false));
        }
        return physicalCriteria;
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    public HostSearchCriteria getCriteria() {
        return this.mCriteria;
    }

    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        HostSearch hostSearch = null;
        try {
            SingleHostSearchQuery query = SingleHostSearchQuery.byName(plugin.getName() + Plugin.NAME_SEPARATOR + this.mName);
            hostSearch = query.select();
        }
        catch (NoResultsFoundException e) {
            hostSearch = new HostSearch(plugin.getID());
        }
        hostSearch.setSimpleName(this.mName);
        if (this.mDescription != null) {
            hostSearch.setDescription(this.mDescription);
        }
        hostSearch.setCriteria(this.mCriteria);
        hostSearch.save();
        plugin.addHostSearch(hostSearch.getID());
        return hostSearch;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(HostSearchImplTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mName;
    }
}

