/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.util.string.StringEscapedTokenizer;
import org.w3c.dom.Element;

public class FolderItem
extends PluginItem {
    static final String ELEMENT_NAME = "folder";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private String mName;
    private String mDescription;

    private FolderItem() {
    }

    FolderItem(Element element) {
        this.setName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setDescription(XMLUtil.getAttribute(element, DESCRIPTION_ATTR));
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        int pathLength = this.mName.length();
        StringEscapedTokenizer st = new StringEscapedTokenizer(this.mName.substring(1, pathLength), "/", "");
        FolderID parentFolderID = FolderID.ROOT_FOLDER_ID;
        SummaryFolder parentFolder = null;
        SummaryFolder folder = null;
        String totalPath = "/";
        PluginID owningPluginID = null;
        boolean interiorFolder = true;
        boolean saveFolder = false;
        UserDBSubsystem udb = null;
        try {
            udb = PluginDBSubsystem.getInstance().getApplication().getUserDBSubsystem();
        }
        catch (UnsupportedSubsystemException e) {
            throw PluginException.unexpectedError(e);
        }
        GroupID adminGroup = udb.getLocalUserDBAdmin().getGroupManager().getAdminGroupID();
        while (st.hasMoreTokens()) {
            block11: {
                String folderName = st.nextToken();
                if (!st.hasMoreTokens()) {
                    interiorFolder = false;
                }
                totalPath = totalPath + folderName + "/";
                parentFolder = parentFolderID.getByIDQuery().selectSummaryView();
                owningPluginID = parentFolder.getPluginID();
                SingleFolderQuery query = SingleFolderQuery.byPath(totalPath);
                try {
                    folder = query.select();
                    if (!interiorFolder && this.mDescription != null) {
                        saveFolder = true;
                        ((Folder)folder).setDescription(this.mDescription);
                    }
                }
                catch (NoResultsFoundException e) {
                    saveFolder = true;
                    if (interiorFolder) {
                        if (owningPluginID != null) throw PluginException.folderCreationError(plugin.getName(), plugin.getVersionNumber().getAsString(), this.mName);
                        folder = new Folder(folderName, parentFolderID, null);
                    } else {
                        if (owningPluginID != null && !plugin.getID().equals(owningPluginID) && !plugin.getDependencies().contains(owningPluginID)) throw PluginException.folderCreationError(plugin.getName(), plugin.getVersionNumber().getAsString(), this.mName);
                        folder = new Folder(folderName, parentFolderID, plugin.getID());
                    }
                    FolderAccessData data = new FolderAccessData();
                    data.clearACLs();
                    data.setOwnerID(adminGroup);
                    ((Folder)folder).setFolderAccessData(data);
                    if (this.mDescription == null) break block11;
                    ((Folder)folder).setDescription(this.mDescription);
                }
            }
            if (!interiorFolder) {
                FolderItem.validatePluginOwnership(plugin, folder.getPluginID(), ELEMENT_NAME, folder.getName());
            }
            if (saveFolder) {
                ((Folder)folder).save();
            }
            parentFolderID = folder.getID();
        }
        plugin.addFolder(folder.getID());
        return folder;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(FolderImplTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mName;
    }
}

