/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import org.w3c.dom.Element;

public class ComponentTypeItem
extends PluginItem {
    static final String ELEMENT_NAME = "componentType";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String GROUP_ATTR = "group";
    private static final String ORDER_ATTR = "order";
    private static final String INDENT_LEVEL_ATTR = "indentLevel";
    private String mName;
    private String mDescription;
    private String mGroup;
    private String mOrder;
    private int mIndentLevel;

    private ComponentTypeItem() {
    }

    ComponentTypeItem(Element element) {
        this.setName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setDescription(XMLUtil.getAttribute(element, DESCRIPTION_ATTR));
        this.setGroup(XMLUtil.getAttribute(element, GROUP_ATTR));
        this.setOrder(XMLUtil.getAttribute(element, ORDER_ATTR));
        this.setIndentLevel(Integer.parseInt(XMLUtil.getAttribute(element, INDENT_LEVEL_ATTR)));
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String description) {
        this.mDescription = description;
    }

    public String getGroup() {
        return this.mGroup;
    }

    private void setGroup(String group) {
        if (group == null) {
            group = "";
        }
        this.mGroup = group;
    }

    public String getOrder() {
        return this.mOrder;
    }

    private void setOrder(String order) {
        this.mOrder = order;
    }

    public int getIndentLevel() {
        return this.mIndentLevel;
    }

    private void setIndentLevel(int indentLevel) {
        this.mIndentLevel = indentLevel;
    }

    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        ComponentTypeRef componentTypeRef = null;
        try {
            SingleComponentTypeRefQuery query = SingleComponentTypeRefQuery.byName(plugin.getName() + Plugin.NAME_SEPARATOR + this.mName);
            componentTypeRef = query.select();
        }
        catch (NoResultsFoundException e) {
            componentTypeRef = new ComponentTypeRef(plugin.getID());
        }
        componentTypeRef.setSimpleName(this.mName);
        if (this.mDescription != null) {
            componentTypeRef.setDescription(this.mDescription);
        }
        componentTypeRef.setGroup(this.mGroup);
        componentTypeRef.setOrder(this.mOrder);
        componentTypeRef.setIndentLevel(this.mIndentLevel);
        return componentTypeRef;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(ComponentTypeRefImplTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mName;
    }
}

