/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plugindb;

import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.plugindb.ComponentTypeItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.plugindb.ResourceItem;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemServiceItem;
import java.io.InputStream;
import org.w3c.dom.Element;

public class ComponentItem
extends PluginItem {
    static final String ELEMENT_NAME = "component";
    private static final String JAR_PATH_ATTR = "jarPath";
    private static final String MAJOR_VERSION_ATTR = "majorVersion";
    private static final String SYSTEM_SERVICE_ELEMENT_NAME = "systemService";
    private static final String COMPONENT_TYPE_ELEMENT_NAME = "componentType";
    private static final String RESOURCE_ELEMENT_NAME = "resource";
    private String mJarPath;
    private boolean mMajorVersion;
    private ComponentTypeItem mComponentType;
    private SystemServiceItem mSystemService;
    private ResourceItem mResource;
    private static final String CONFIG_TEMPLATE_VAR = "configTemplate";
    private static final String TRUE = new Boolean(true).toString();
    private static final String FALSE = new Boolean(false).toString();

    private ComponentItem() {
    }

    ComponentItem(Element element, PluginDescriptor descriptor) throws PluginException {
        this.setDescriptor(descriptor);
        this.setJarPath(XMLUtil.getAttribute(element, JAR_PATH_ATTR));
        this.setMajorVersion(XMLUtil.getBooleanAttribute(element, MAJOR_VERSION_ATTR, false));
        Element[] list = XMLUtil.getChildren(element, SYSTEM_SERVICE_ELEMENT_NAME);
        if (list.length > 0) {
            this.mSystemService = new SystemServiceItem(list[0]);
        }
        if ((list = XMLUtil.getChildren(element, COMPONENT_TYPE_ELEMENT_NAME)).length > 0) {
            this.mComponentType = new ComponentTypeItem(list[0]);
        }
        if ((list = XMLUtil.getChildren(element, RESOURCE_ELEMENT_NAME)).length > 0) {
            this.mResource = new ResourceItem(list[0], descriptor);
        }
    }

    void setDescriptor(PluginDescriptor descriptor) {
        this.mDescriptor = descriptor;
        if (this.mResource != null) {
            this.mResource.setDescriptor(descriptor);
        }
    }

    public InputStream getInputStream() throws PluginException {
        return this.mDescriptor.getEntryInputStream(this.getJarPath());
    }

    private String getJarPath() {
        return this.mJarPath;
    }

    private void setJarPath(String jarPath) throws PluginException {
        this.mDescriptor.getJarEntry(jarPath);
        this.mJarPath = jarPath;
    }

    public boolean getMajorVersion() {
        return this.mMajorVersion;
    }

    private void setMajorVersion(boolean majorVersion) {
        this.mMajorVersion = majorVersion;
    }

    public ComponentTypeItem getComponentType() {
        return this.mComponentType;
    }

    public SystemServiceItem getSystemService() {
        return this.mSystemService;
    }

    public ResourceItem getResource() {
        return this.mResource;
    }

    PluginMember generateFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        boolean isResourceDefined;
        boolean bl = isResourceDefined = this.mResource != null;
        if (isResourceDefined) {
            this.mResource.generateFromXML(plugin);
        }
        Component comp = this.getComponentFromXML(plugin);
        RsrcInfo rInfo = comp.getLocalResource();
        SourceInfo si = new SourceInfo(null, null, null, null);
        if (rInfo != null) {
            if (rInfo.getTypeName().equals(rInfo.getFileTypeName())) {
                if (rInfo.getConfigurable()) {
                    si.addParameter(CONFIG_TEMPLATE_VAR, TRUE, "configuration template");
                } else {
                    si.addParameter(CONFIG_TEMPLATE_VAR, FALSE, "not a configuration template");
                }
            }
        }
        comp.setSourceInfo(si);
        if (isResourceDefined) {
            if (!comp.isSimpleComponent() || rInfo == null || !rInfo.getResourceID().equals(this.mResource.getResource().getResourceID())) {
                throw PluginException.componentResourceMismatch(plugin.getName(), plugin.getVersionNumber().getAsString(), this.mResource.getName(), comp.getName());
            }
            plugin.addResource(rInfo.getResourceID());
        } else if (rInfo != null && !plugin.getID().equals(rInfo.getPluginID())) {
            throw PluginException.componentResourceMismatch2(plugin.getName(), plugin.getVersionNumber().getAsString(), comp.getName(), rInfo.getName());
        }
        ComponentSaveContext context = new ComponentSaveContext();
        context.setSaveAsNewMajor(this.mMajorVersion);
        context.setLatestVersion(comp);
        context.setHideLatest(true);
        context.setImportSettings(true);
        ComponentItem.validatePluginOwnership(plugin, comp.getPluginID(), ELEMENT_NAME, comp.getName());
        comp.save(context);
        plugin.addComponent(comp.getID());
        if (this.mComponentType != null) {
            ComponentTypeRef ct = (ComponentTypeRef)this.mComponentType.generateFromXML(plugin);
            ComponentRef cr = new ComponentRef(comp.getPath(), comp.getName(), comp.getVersionNumber().getAsString());
            ct.setComponentRef(cr);
            ct.save();
            plugin.addComponentType(ct.getID());
        }
        if (this.mSystemService != null) {
            SystemServiceRef ss = (SystemServiceRef)this.mSystemService.generateFromXML(plugin);
            InstalledComponentRef icr = new InstalledComponentRef(comp.getPath(), comp.getName(), comp.getVersionNumber().getAsString(), Comparator.EQUAL, false, null, false);
            ss.setInstalledComponentRef(icr);
            ss.save();
            plugin.addSystemService(ss.getID());
        }
        return comp;
    }

    private Component getComponentFromXML(PluginImpl plugin) throws PersistenceManagerException, RPCException {
        Component comp = new Component(plugin.getID());
        comp.readFromXML(this.getInputStream());
        try {
            Component latest = SingleComponentQuery.byName(comp.getPath(), comp.getName(), null).select();
            latest.readFromXML(comp.writeToXML());
            comp = latest;
        }
        catch (NoResultsFoundException noResultsFoundException) {
            // empty catch block
        }
        return comp;
    }

    String getObjectType() {
        return PersistenceManager.getObjectName(ComponentImplTable.DEFAULT.getJavaClass()).toString();
    }

    String getObjectIdentifier() {
        return this.mJarPath;
    }
}

