/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class XMLVariableSettings
extends VariableSettingsHolder {
    private String mListElem;
    private String mVarElem;
    private String mNameAttr;
    private String mValueAttr;

    private XMLVariableSettings() {
        super(true);
    }

    protected XMLVariableSettings(String listElem, String varElem, String nameAttr, String valAttr) {
        super(true);
        this.mListElem = listElem;
        this.mVarElem = varElem;
        this.mNameAttr = nameAttr;
        this.mValueAttr = valAttr;
    }

    public XMLVariableSettings(VariableSettingsSource vars, String listElem, String varElem, String nameAttr, String valAttr) {
        super(vars, true);
        this.mListElem = listElem;
        this.mVarElem = varElem;
        this.mNameAttr = nameAttr;
        this.mValueAttr = valAttr;
    }

    public XMLVariableSettings(Element topElement, VariableSettingsSource existingVars, String listElem, String varElem, String nameAttr, String valAttr) throws SystemModelParseException {
        this(listElem, varElem, nameAttr, valAttr);
        HashSet<Object> existingNames = existingVars != null ? new HashSet<String>(Arrays.asList(existingVars.getVarNames())) : new HashSet();
        Element[] varListElem = XMLUtil.getChildren(topElement, this.mListElem);
        if (varListElem.length > 0) {
            Element[] vars = XMLUtil.getChildren(varListElem[0], this.mVarElem);
            for (int i = 0; i < vars.length; ++i) {
                String name = XMLUtil.getAttribute(vars[i], this.mNameAttr);
                String val = XMLUtil.getAttribute(vars[i], this.mValueAttr);
                if (val == null) {
                    val = "";
                }
                if (this.containsVarValue(name)) {
                    throw this.newParseError("pdb.DUP_VAR_ERR", name);
                }
                if (existingNames.contains(name)) {
                    throw this.newParseError("pdb.VAR_DUP_PARAM_ERR", name);
                }
                this.setVarValue(name, val);
            }
        }
    }

    public void writeToXML(XML topElem) {
        if (this.size() > 0) {
            XML varList = new XML(this.mListElem);
            varList.setPrettyPrint(true);
            String[] names = this.getVarNames();
            for (int i = 0; i < names.length; ++i) {
                String val = this.getVarValue(names[i]);
                XML var = new XML(this.mVarElem);
                var.setPrettyPrint(true);
                XMLUtil.addAttributeIfNotNull(var, this.mNameAttr, names[i]);
                XMLUtil.addAttributeIfNotNull(var, this.mValueAttr, val);
                varList.addElement((org.apache.ecs.Element)var);
            }
            topElem.addElement((org.apache.ecs.Element)varList);
        }
    }

    private SystemModelParseException newParseError(String code, String arg) {
        ROXMessage message = new ROXMessage(code, (Object[])new String[]{arg}, 2000);
        return new SystemModelParseException(message);
    }
}

