/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TryStep;
import java.util.Stack;

public class ValidationState {
    private Stack mCallStack = new Stack();

    ValidationState() {
        this.initiateCallStack();
    }

    StepValidationState createValidationState(ExecStep s) {
        switch (s.getStepType()) {
            case 127: {
                return new IfValidationState(s);
            }
            case 125: {
                return new TryCatchValidationState(s);
            }
        }
        return new SimpleStepValidationState(s);
    }

    public StepValidationState getCurrenState() {
        if (this.mCallStack.size() > 0) {
            return (StepValidationState)this.mCallStack.peek();
        }
        throw new IllegalStateException();
    }

    public void initiateCallStack() {
        this.mCallStack.push(new SimpleStepValidationState(null));
    }

    void pushCallStack(ExecStep s) {
        this.mCallStack.push(this.createValidationState(s));
    }

    public StepValidationState popCallStack() {
        return (StepValidationState)this.mCallStack.pop();
    }

    private static class TryCatchValidationState
    extends StepValidationState {
        int mSeriesCnt = 0;
        SimpleStepValidationState mTryState = new SimpleStepValidationState(null);
        SimpleStepValidationState mCatchState = new SimpleStepValidationState(null);
        SimpleStepValidationState mFinallyState = new SimpleStepValidationState(null);

        public TryCatchValidationState(ExecStep inStep) {
            super(inStep);
        }

        public boolean isFoundReturnStep() {
            return this.getCurrent().isFoundReturnStep();
        }

        public void setFoundReturnStep() {
            this.getCurrent().setFoundReturnStep();
        }

        public boolean isFoundRaiseStep() {
            return this.getCurrent().isFoundRaiseStep();
        }

        public void setFoundRaiseStep() {
            this.getCurrent().setFoundRaiseStep();
        }

        public void mergeIntoParent(StepValidationState inCurrenState) {
            boolean foundRaiseStep;
            boolean foundReturnStep;
            ExecStep[] catchSteps = ((TryStep)this.getStep()).getCatchSteps();
            boolean bl = foundReturnStep = !(!this.mFinallyState.isFoundReturnStep() && !this.mFinallyState.isFoundRaiseStep() && (!this.mCatchState.isFoundReturnStep() && !this.mCatchState.isFoundRaiseStep() && catchSteps != null || !this.mTryState.isFoundReturnStep() && (!this.mTryState.isFoundRaiseStep() || catchSteps != null)) || !this.mTryState.isFoundReturnStep() && !this.mCatchState.isFoundReturnStep() && !this.mFinallyState.isFoundReturnStep());
            if (foundReturnStep) {
                inCurrenState.setFoundReturnStep();
            }
            boolean bl2 = foundRaiseStep = this.mFinallyState.isFoundRaiseStep() || this.mCatchState.isFoundRaiseStep() && this.mTryState.isFoundRaiseStep() || catchSteps == null && this.mTryState.isFoundRaiseStep();
            if (foundRaiseStep) {
                inCurrenState.setFoundRaiseStep();
            }
        }

        public void startStepSeries() {
            ++this.mSeriesCnt;
        }

        StepValidationState getCurrent() {
            switch (this.mSeriesCnt) {
                case 1: {
                    return this.mTryState;
                }
                case 2: {
                    return this.mCatchState;
                }
                case 3: {
                    return this.mFinallyState;
                }
            }
            throw new IllegalArgumentException("" + this.mSeriesCnt);
        }
    }

    private static class IfValidationState
    extends StepValidationState {
        int mSeriesCnt = 0;
        SimpleStepValidationState mThenState = new SimpleStepValidationState(null);
        SimpleStepValidationState mElseState = new SimpleStepValidationState(null);

        public IfValidationState(ExecStep inStep) {
            super(inStep);
        }

        public boolean isFoundReturnStep() {
            return this.getCurrent().isFoundReturnStep();
        }

        public void setFoundReturnStep() {
            this.getCurrent().setFoundReturnStep();
        }

        public boolean isFoundRaiseStep() {
            return this.getCurrent().isFoundRaiseStep();
        }

        public void setFoundRaiseStep() {
            this.getCurrent().setFoundRaiseStep();
        }

        public void mergeIntoParent(StepValidationState inCurrenState) {
            boolean foundReturnStep;
            boolean foundRaiseStep;
            boolean bl = foundRaiseStep = this.mThenState.isFoundRaiseStep() && this.mElseState.isFoundRaiseStep();
            if (foundRaiseStep) {
                inCurrenState.setFoundRaiseStep();
            }
            boolean bl2 = foundReturnStep = !(!this.mThenState.isFoundReturnStep() && !this.mThenState.isFoundRaiseStep() || !this.mElseState.isFoundReturnStep() && !this.mElseState.isFoundRaiseStep() || !this.mThenState.isFoundReturnStep() && !this.mElseState.isFoundReturnStep());
            if (foundReturnStep) {
                inCurrenState.setFoundReturnStep();
            }
        }

        public void startStepSeries() {
            ++this.mSeriesCnt;
        }

        StepValidationState getCurrent() {
            return this.mSeriesCnt == 1 ? this.mThenState : this.mElseState;
        }
    }

    private static class SimpleStepValidationState
    extends StepValidationState {
        boolean mFoundReturnStep = false;
        boolean mFoundRaiseStep = false;

        public boolean isFoundReturnStep() {
            return this.mFoundReturnStep;
        }

        public void setFoundReturnStep() {
            this.mFoundReturnStep = true;
        }

        public boolean isFoundRaiseStep() {
            return this.mFoundRaiseStep;
        }

        public void setFoundRaiseStep() {
            this.mFoundRaiseStep = true;
        }

        public SimpleStepValidationState(ExecStep inStep) {
            super(inStep);
        }

        public void mergeIntoParent(StepValidationState inCurrenState) {
            if (this.isFoundRaiseStep()) {
                inCurrenState.setFoundRaiseStep();
            }
            if (this.isFoundReturnStep()) {
                inCurrenState.setFoundReturnStep();
            }
        }
    }

    public static abstract class StepValidationState {
        ExecStep mStep = null;

        public StepValidationState(ExecStep inStep) {
            this.mStep = inStep;
        }

        public abstract boolean isFoundReturnStep();

        public abstract void setFoundReturnStep();

        public abstract boolean isFoundRaiseStep();

        public abstract void setFoundRaiseStep();

        public abstract void mergeIntoParent(StepValidationState var1);

        public void startStepSeries() {
        }

        public ExecStep getStep() {
            return this.mStep;
        }
    }
}

