/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.AssigningStep;
import com.raplix.rolloutexpress.systemmodel.plandb.BlockCallerStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterFactory;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TargetVariableStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ThisTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.UninstallBlockStep;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class UninstallStep
extends ExecStep
implements SimplePlanStep,
UninstallBlockStep,
TargetVariableStep,
BlockCallerStep,
AssigningStep {
    private String mAssignTo;
    public static final String ELEMENT_NAME = "uninstall";
    private static final String ATTR_BLOCK_NAME = "blockName";
    private static final String ELEMENT_ASSIGN = "assign";
    private static final String ATTR_VARNAME = "varName";
    private InstalledComponentTargeter mTargeter;
    private String mBlockName;
    private ArgList mArgs;

    private UninstallStep() {
    }

    public UninstallStep(Element uninstallElement) throws SystemModelParseException {
        super(uninstallElement);
        this.setTargeter(ComponentTargeterFactory.getInstalledTargeter(uninstallElement));
        this.setBlockName(UninstallStep.getAttribute(uninstallElement, ATTR_BLOCK_NAME));
        this.mArgs = new ArgList(uninstallElement);
        Element[] elements = UninstallStep.getChildren(uninstallElement, ELEMENT_ASSIGN);
        if (elements.length > 0) {
            this.setAssignTo(UninstallStep.getAttribute(elements[0], ATTR_VARNAME));
        }
    }

    public UninstallStep(InstalledComponentTargeter targetComp, String blockName) {
        this(targetComp, blockName, new ArgList());
    }

    public UninstallStep(InstalledComponentTargeter targetComp, String blockName, VariableSettingsSource args) {
        this(targetComp, blockName, args, null);
    }

    public UninstallStep(InstalledComponentTargeter targetComp, String blockName, VariableSettingsSource args, String inAssignVarName) {
        this.setTargeter(targetComp);
        this.setBlockName(blockName);
        this.setArgs(args);
        this.setAssignTo(inAssignVarName);
    }

    public InstalledComponentTargeter getTargeter() {
        return this.mTargeter;
    }

    private void setTargeter(InstalledComponentTargeter targeter) {
        if (targeter == null) {
            targeter = new ThisTargeter();
        }
        this.mTargeter = targeter;
    }

    public String getBlockName() {
        return this.mBlockName;
    }

    public void setBlockName(String blockName) {
        this.mBlockName = blockName;
    }

    public VariableSettingsSource getArgs() {
        return (VariableSettingsSource)this.mArgs.clone();
    }

    private void setArgs(VariableSettingsSource args) {
        this.mArgs = new ArgList(args);
    }

    public NamedBlockType getBlockType() {
        return NamedBlockType.UNINSTALL;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        UninstallStep result = (UninstallStep)super.generate(generator);
        result.setTargeter((InstalledComponentTargeter)result.getTargeter().generate(generator));
        result.mArgs = this.mArgs.generate(generator);
        return result;
    }

    protected void populateXML(XML outXML) {
        UninstallStep.addAttributeIfNotNull(outXML, ATTR_BLOCK_NAME, this.getBlockName());
        this.mArgs.writeToXML(outXML);
        outXML.addElement((org.apache.ecs.Element)this.getTargeter().writeToXML());
        if (this.getAssignTo() != null) {
            XML assign = new XML(ELEMENT_ASSIGN);
            assign.setPrettyPrint(true);
            UninstallStep.addAttributeIfNotNull(assign, ATTR_VARNAME, this.getAssignTo());
            outXML.addElement((org.apache.ecs.Element)assign);
        }
    }

    public void validate(Caller container) throws PlanDBException {
        this.getTargeter().validate(container);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof UninstallStep)) {
            return false;
        }
        UninstallStep theStep = (UninstallStep)inStep;
        if (!ObjectUtil.equals(theStep.getTargeter(), this.getTargeter())) {
            return false;
        }
        if (!ObjectUtil.equals(this.getBlockName(), theStep.getBlockName())) {
            return false;
        }
        return this.mArgs.equals(theStep.mArgs);
    }

    public int getStepType() {
        return 109;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargeter());
        v.visit(this.mArgs);
        v.visitMutableVar(this.getAssignTo());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        UninstallStep result = (UninstallStep)super.accept(t);
        result.setTargeter(t.transform(this.getTargeter()));
        result.mArgs = (ArgList)t.transform(this.mArgs);
        return result;
    }

    public String getAssignTo() {
        return this.mAssignTo;
    }

    public void setAssignTo(String inVarname) {
        this.mAssignTo = inVarname;
    }
}

