/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class URLTestStep
extends ExecStep
implements SimplePlanStep,
ComponentStep {
    public static final String ELEMENT_NAME = "urlTest";
    public static final int DEFAULT_DELAY = 1;
    public static final int DEFAULT_TIMEOUT = 5;
    protected String mURL;
    protected int mDelaySecs;
    protected int mTimeoutSecs;
    protected String mPattern;

    private URLTestStep() {
    }

    public URLTestStep(Element URLTestElement) {
        super(URLTestElement);
        this.setDelaySecs(URLTestElement.getAttribute("delaySecs"));
        this.setTimeoutSecs(URLTestElement.getAttribute("timeoutSecs"));
        this.mPattern = URLTestElement.getAttribute("pattern");
        this.mURL = URLTestElement.getAttribute("URL");
    }

    public URLTestStep(String inURL, String inDelay, String inTimeout, String inPattern) {
        this.mURL = inURL;
        this.setDelaySecs(inDelay);
        this.setTimeoutSecs(inTimeout);
        this.mPattern = inPattern;
    }

    public String getURL() {
        return this.mURL;
    }

    public void setURL(String inValue) {
        this.mURL = inValue;
    }

    public int getDelaySecs() {
        return this.mDelaySecs;
    }

    public void setDelaySecs(int inValue) {
        this.mDelaySecs = inValue;
    }

    public void setDelaySecs(String inValue) throws NumberFormatException {
        this.mDelaySecs = inValue == null || inValue.equals("") ? 1 : Integer.parseInt(inValue);
    }

    public int getTimeoutSecs() {
        return this.mTimeoutSecs;
    }

    public void setTimeoutSecs(int inValue) {
        this.mTimeoutSecs = inValue;
    }

    public void setTimeoutSecs(String inValue) throws NumberFormatException {
        this.mTimeoutSecs = inValue == null || inValue.equals("") ? 5 : Integer.parseInt(inValue);
    }

    public String getPattern() {
        return this.mPattern;
    }

    public void setPattern(String inValue) {
        this.mPattern = inValue;
    }

    protected void populateXML(XML outXML) {
        outXML.addAttribute("delaySecs", "" + this.mDelaySecs);
        outXML.addAttribute("timeoutSecs", "" + this.mTimeoutSecs);
        URLTestStep.addAttributeIfNotNull(outXML, "URL", this.mURL);
        URLTestStep.addAttributeIfNotNull(outXML, "pattern", this.mPattern);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof URLTestStep)) {
            return false;
        }
        URLTestStep theStep = (URLTestStep)inStep;
        if (!theStep.getURL().equals(this.mURL)) {
            return false;
        }
        if (theStep.getDelaySecs() != this.mDelaySecs) {
            return false;
        }
        if (theStep.getTimeoutSecs() != this.mTimeoutSecs) {
            return false;
        }
        return theStep.getPattern().equals(this.mPattern);
    }

    public int getStepType() {
        return 107;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        URLTestStep copy = (URLTestStep)super.generate(generator);
        copy.setURL(generator.generate(copy.getURL()));
        copy.setPattern(generator.generate(copy.getPattern()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getURL());
        v.visitToken(this.getPattern());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        URLTestStep result = (URLTestStep)super.accept(t);
        result.setURL(t.transformToken(this.getURL()));
        result.setPattern(t.transformToken(this.getPattern()));
        return result;
    }
}

