/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TargetVariableStep;
import java.util.Arrays;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class TryStep
extends ExecStep
implements SimplePlanStep,
ComponentStep,
TargetVariableStep {
    public static final String ELEMENT_NAME = "try";
    private static final String BLOCK_ELEM = "block";
    private static final String CATCH_ELEM = "catch";
    private static final String FINALLY_ELEM = "finally";
    private ExecStep[] mTrySteps;
    private ExecStep[] mCatchSteps;
    private ExecStep[] mFinallySteps;

    private TryStep() {
    }

    public TryStep(Element tryElem) throws SystemModelParseException {
        super(tryElem);
        this.setTrySteps(TryStep.parseStepBlock(tryElem, BLOCK_ELEM), false);
        this.setCatchSteps(TryStep.parseStepBlock(tryElem, CATCH_ELEM), false);
        this.setFinallySteps(TryStep.parseStepBlock(tryElem, FINALLY_ELEM), false);
    }

    public TryStep(ExecStep[] trySteps, ExecStep[] catchSteps, ExecStep[] finallySteps) {
        this.setTrySteps(trySteps, true);
        this.setCatchSteps(catchSteps, true);
        this.setFinallySteps(finallySteps, true);
    }

    public ExecStep[] getTrySteps() {
        return this.mTrySteps;
    }

    private void setTrySteps(ExecStep[] steps, boolean copy) {
        if (steps == null) {
            throw new NullPointerException();
        }
        if (copy) {
            steps = TryStep.deepClone(steps);
        }
        this.mTrySteps = steps;
    }

    public ExecStep[] getCatchSteps() {
        return this.mCatchSteps;
    }

    private void setCatchSteps(ExecStep[] steps, boolean copy) {
        if (steps != null && copy) {
            steps = TryStep.deepClone(steps);
        }
        this.mCatchSteps = steps;
    }

    public ExecStep[] getFinallySteps() {
        return this.mFinallySteps;
    }

    private void setFinallySteps(ExecStep[] steps, boolean copy) {
        if (steps != null && copy) {
            steps = TryStep.deepClone(steps);
        }
        this.mFinallySteps = steps;
    }

    protected void populateXML(XML outXML) {
        TryStep.writeStepBlock(outXML, BLOCK_ELEM, this.mTrySteps);
        TryStep.writeStepBlock(outXML, CATCH_ELEM, this.mCatchSteps);
        TryStep.writeStepBlock(outXML, FINALLY_ELEM, this.mFinallySteps);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof TryStep)) {
            return false;
        }
        TryStep theStep = (TryStep)inStep;
        return Arrays.equals(this.mTrySteps, theStep.mTrySteps) && Arrays.equals(this.mCatchSteps, theStep.mCatchSteps) && Arrays.equals(this.mFinallySteps, theStep.mFinallySteps);
    }

    public int getStepType() {
        return 125;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        return super.generate(generator);
    }

    protected Object clone() {
        TryStep result = (TryStep)super.clone();
        result.setTrySteps(result.getTrySteps(), true);
        result.setCatchSteps(result.getCatchSteps(), true);
        result.setFinallySteps(result.getFinallySteps(), true);
        return result;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.mTrySteps);
        if (this.mCatchSteps != null) {
            v.visit(this.mCatchSteps);
        }
        if (this.mFinallySteps != null) {
            v.visit(this.mFinallySteps);
        }
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        ExecStep[] finallySteps;
        TryStep result = (TryStep)super.accept(t);
        ExecStep[] trySteps = result.getTrySteps();
        for (int i = 0; i < trySteps.length; ++i) {
            trySteps[i] = t.transform(trySteps[i]);
        }
        result.setTrySteps(trySteps, false);
        ExecStep[] catchSteps = result.getCatchSteps();
        if (catchSteps != null) {
            for (int i = 0; i < catchSteps.length; ++i) {
                catchSteps[i] = t.transform(catchSteps[i]);
            }
            result.setCatchSteps(catchSteps, false);
        }
        if ((finallySteps = result.getFinallySteps()) != null) {
            for (int i = 0; i < finallySteps.length; ++i) {
                finallySteps[i] = t.transform(finallySteps[i]);
            }
            result.setFinallySteps(finallySteps, false);
        }
        return result;
    }
}

