/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PerlSub;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotPrepareStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TransformType;
import com.raplix.util.ObjectUtil;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransformStep
extends ExecStep
implements SimplePlanStep,
SnapshotPrepareStep {
    public static final String ELEMENT_NAME = "transform";
    private static final String STYLESHEET_ELEM = "stylesheet";
    private static final String ATTR_INPUT = "input";
    private static final String ATTR_OUTPUT = "output";
    private static final String ELEM_SOURCE = "source";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private TransformType mTransformType;
    private String mInputFile;
    private String mOutputFile;
    private String mSourceFile;
    private PerlSub[] mPerlTransforms;
    private String mXSLTTransform;

    private TransformStep() {
    }

    public TransformStep(Element stepElement) throws SystemModelParseException {
        super(stepElement);
        this.setInputFile(TransformStep.getAttribute(stepElement, ATTR_INPUT));
        this.setOutputFile(TransformStep.getAttribute(stepElement, ATTR_OUTPUT));
        TransformType type = this.parseSubstElems(stepElement);
        if (type == null) {
            type = this.parseSourceElem(stepElement);
        }
        if (type == null) {
            type = this.parseTransformElem(stepElement);
        }
        if (type == null) {
            type = TransformType.COPY;
        }
        this.setTransformType(type);
    }

    private TransformType parseSubstElems(Element stepElement) {
        Element[] substElems = TransformStep.getChildren(stepElement, "subst");
        if (substElems.length > 0) {
            Vector<PerlSub> subs = new Vector<PerlSub>();
            for (int i = 0; i < substElems.length; ++i) {
                subs.add(new PerlSub(substElems[i]));
            }
            this.setPerlTransforms(subs.toArray(new PerlSub[subs.size()]));
            return TransformType.PERL;
        }
        return null;
    }

    private TransformType parseSourceElem(Element stepElement) {
        Element[] sourceElems = TransformStep.getChildren(stepElement, ELEM_SOURCE);
        if (sourceElems.length > 0) {
            this.setSourceFile(TransformStep.getAttribute(sourceElems[0], ATTR_NAME));
            return (TransformType)TransformStep.getEnumAttribute(sourceElems[0], ATTR_TYPE, TransformType.FACTORY);
        }
        return null;
    }

    private TransformType parseTransformElem(Element stepElement) throws SystemModelParseException {
        NodeList children = stepElement.getChildNodes();
        Element transform = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            transform = (Element)child;
            break;
        }
        if (transform == null) {
            return null;
        }
        String xfm = this.validateTransform(transform);
        this.setXSLTTransform(xfm);
        return TransformType.XSLT;
    }

    private String validateTransform(Element transform) throws SystemModelParseException {
        if (!STYLESHEET_ELEM.equals(transform.getLocalName())) {
            ROXMessage msg = new ROXMessage("pdb.ROOT_XSLT_PARSE_ERR", 2000);
            throw new SystemModelParseException(msg);
        }
        String xfm = TransformStep.toString(transform, "pdb.");
        StreamSource xfmSrc = new StreamSource(new StringReader(xfm));
        try {
            TransformerFactory.newInstance().newTransformer(xfmSrc);
        }
        catch (TransformerConfigurationException e) {
            String errMsg = e.getMessage();
            ROXMessage msg = errMsg == null ? new ROXMessage("pdb.XSLT_PARSE_ERR", 2000) : new ROXMessage("pdb.DETAIL_XSLT_PARSE_ERR", new Object[]{errMsg}, 2000);
            throw new SystemModelParseException(msg);
        }
        return xfm;
    }

    public TransformStep(String inputFile, String outputFile) {
        this.setInputFile(inputFile);
        this.setOutputFile(outputFile);
        this.setTransformType(TransformType.COPY);
    }

    public TransformStep(String inputFile, String outputFile, TransformType type, String sourceFile) {
        this.setInputFile(inputFile);
        this.setOutputFile(outputFile);
        this.setTransformType(type);
        this.setSourceFile(sourceFile);
    }

    public TransformStep(String inputFile, String outputFile, PerlSub[] subs) {
        this.setInputFile(inputFile);
        this.setOutputFile(outputFile);
        this.setTransformType(TransformType.PERL);
        this.setPerlTransforms(subs);
    }

    public TransformStep(String inputFile, String outputFile, String transform) {
        this.setInputFile(inputFile);
        this.setOutputFile(outputFile);
        this.setTransformType(TransformType.XSLT);
        this.setXSLTTransform(transform);
    }

    public TransformType getTransformType() {
        return this.mTransformType;
    }

    private void setTransformType(TransformType transformType) {
        this.mTransformType = transformType;
    }

    public String getInputFile() {
        return this.mInputFile;
    }

    private void setInputFile(String inputFile) {
        this.mInputFile = inputFile;
    }

    public String getOutputFile() {
        return this.mOutputFile;
    }

    private void setOutputFile(String outputFile) {
        this.mOutputFile = outputFile;
    }

    public String getSourceFile() {
        return this.mSourceFile;
    }

    private void setSourceFile(String sourceFile) {
        this.mSourceFile = sourceFile;
    }

    public PerlSub[] getPerlTransforms() {
        return this.mPerlTransforms == null ? null : (PerlSub[])this.mPerlTransforms.clone();
    }

    private void setPerlTransforms(PerlSub[] perlTransforms) {
        this.mPerlTransforms = (PerlSub[])perlTransforms.clone();
    }

    public String getXSLTTransform() {
        return this.mXSLTTransform;
    }

    private void setXSLTTransform(String XSLTTransform2) {
        this.mXSLTTransform = XSLTTransform2;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        TransformStep result = (TransformStep)super.generate(generator);
        result.setInputFile(generator.generate(result.getInputFile()));
        result.setOutputFile(generator.generate(result.getOutputFile()));
        result.setSourceFile(generator.generate(result.getSourceFile()));
        result.setXSLTTransform(generator.generate(result.getXSLTTransform()));
        PerlSub[] subs = result.getPerlTransforms();
        if (subs != null) {
            for (int i = 0; i < subs.length; ++i) {
                subs[i] = subs[i].generate(generator);
            }
            result.setPerlTransforms(subs);
        }
        return result;
    }

    protected void populateXML(XML outXML) {
        TransformStep.addAttributeIfNotNull(outXML, ATTR_INPUT, this.getInputFile());
        TransformStep.addAttributeIfNotNull(outXML, ATTR_OUTPUT, this.getOutputFile());
        if (this.getSourceFile() != null) {
            XML source = new XML(ELEM_SOURCE);
            source.setPrettyPrint(true);
            TransformStep.addAttributeIfNotNull(source, ATTR_TYPE, this.getTransformType().toString());
            TransformStep.addAttributeIfNotNull(source, ATTR_NAME, this.getSourceFile());
            outXML.addElement((org.apache.ecs.Element)source);
        } else if (TransformType.PERL.equals(this.getTransformType())) {
            PerlSub[] subs = this.getPerlTransforms();
            for (int i = 0; i < subs.length; ++i) {
                subs[i].writeToXML(outXML);
            }
        } else if (TransformType.XSLT.equals(this.getTransformType())) {
            outXML.setTagText(this.getXSLTTransform());
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof TransformStep)) {
            return false;
        }
        TransformStep theStep = (TransformStep)inStep;
        return ObjectUtil.equals(this.getInputFile(), theStep.getInputFile()) && ObjectUtil.equals(this.getOutputFile(), theStep.getOutputFile()) && ObjectUtil.equals(this.getTransformType(), theStep.getTransformType()) && ObjectUtil.equals(this.getSourceFile(), theStep.getSourceFile()) && ObjectUtil.equals(this.getXSLTTransform(), theStep.getXSLTTransform()) && Arrays.equals(this.mPerlTransforms, theStep.mPerlTransforms);
    }

    public int getStepType() {
        return 121;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getInputFile());
        v.visitToken(this.getOutputFile());
        v.visitToken(this.getSourceFile());
        v.visitToken(this.getXSLTTransform());
        PerlSub[] subs = this.getPerlTransforms();
        if (subs != null) {
            for (int i = 0; i < subs.length; ++i) {
                v.visitToken(subs[i].getMatch());
                v.visitToken(subs[i].getReplace());
            }
        }
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        TransformStep result = (TransformStep)super.accept(t);
        result.setInputFile(t.transformToken(this.getInputFile()));
        result.setOutputFile(t.transformToken(this.getOutputFile()));
        result.setSourceFile(t.transformToken(this.getSourceFile()));
        result.setXSLTTransform(t.transformToken(this.getXSLTTransform()));
        PerlSub[] subs = this.getPerlTransforms();
        if (subs != null) {
            for (int i = 0; i < subs.length; ++i) {
                String newMatch = t.transformToken(subs[i].getMatch());
                String newReplace = t.transformToken(subs[i].getReplace());
                subs[i] = new PerlSub(newMatch, newReplace);
            }
            result.setPerlTransforms(subs);
        }
        return result;
    }
}

