/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class TopLevelRefTargeter
extends ComponentTargeterBase
implements RepoComponentTargeter,
InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "toplevelRef";
    private static final String NAME_ATTR = "name";
    private static final String HOST_ATTR = "host";
    private static final String INSTALL_PATH_ATTR = "installPath";
    private static final String VERSION_OP_ATTR = "versionOp";
    private static final String ONLY_COMPAT_ATTR = "onlyCompat";
    private String mTopLevelRefName;
    private static final Comparator DEFAULT_COMPARATOR = Comparator.GREATER_THAN_EQUAL;
    private Comparator mVersionComparator = DEFAULT_COMPARATOR;
    private static final boolean DEFAULT_ONLY_COMPAT = false;
    private boolean mOnlyCallCompatible = false;
    private String mInstallPath;
    private String mHost;

    public TopLevelRefTargeter(String topLevelRefName, Comparator versionComp, boolean onlyCompat, String installPath, String host) {
        this(topLevelRefName, host);
        this.setVersionComparator(versionComp);
        this.setOnlyCallCompatible(onlyCompat);
        this.setInstallPath(installPath);
    }

    public TopLevelRefTargeter(String topLevelRefName, String host) {
        this.setTopLevelRefName(topLevelRefName);
        this.setHost(host);
    }

    TopLevelRefTargeter(Element element) {
        this.setTopLevelRefName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setInstallPath(XMLUtil.getAttribute(element, INSTALL_PATH_ATTR));
        this.setHost(XMLUtil.getAttribute(element, HOST_ATTR));
        Comparator comp = (Comparator)XMLUtil.getEnumAttribute(element, VERSION_OP_ATTR, Comparator.FACTORY);
        this.setVersionComparator(comp);
        boolean onlyCompat = XMLUtil.getBooleanAttribute(element, ONLY_COMPAT_ATTR, false);
        this.setOnlyCallCompatible(onlyCompat);
    }

    private TopLevelRefTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.TOPLEVEL_REF", this.getTopLevelRefName());
    }

    public String getTopLevelRefName() {
        return this.mTopLevelRefName;
    }

    private void setTopLevelRefName(String name) {
        this.mTopLevelRefName = name;
    }

    public Comparator getVersionComparator() {
        return this.mVersionComparator;
    }

    private void setVersionComparator(Comparator versionComp) {
        if (versionComp == null) {
            versionComp = DEFAULT_COMPARATOR;
        }
        this.mVersionComparator = versionComp;
    }

    public boolean getOnlyCallCompatible() {
        return this.mOnlyCallCompatible;
    }

    private void setOnlyCallCompatible(boolean onlyCallCompatible) {
        this.mOnlyCallCompatible = onlyCallCompatible;
    }

    public String getInstallPath() {
        return this.mInstallPath;
    }

    private void setInstallPath(String path) {
        this.mInstallPath = path;
    }

    public String getHost() {
        return this.mHost;
    }

    private void setHost(String host) {
        this.mHost = host;
    }

    private ComponentRefDecl resolveRef(Caller caller) throws PlanDBException {
        return this.resolveRef(caller, this.getTopLevelRefName(), InstallMode.TOPLEVEL);
    }

    public RepoTarget getRepoTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        Host h = ctx.resolveHost(this.getHost());
        ComponentRefDecl ref = this.resolveRef(caller);
        Component target = ref.getComponent().getID().getByIDQuery().select();
        return new RepoTarget(target, this.getDeclaredTypeOfRef(ref, caller), h, caller, ref, this);
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        ComponentRefDecl ref = this.resolveRef(caller);
        SummaryComponent target = ref.getComponent();
        InstalledComponentRef icr = new InstalledComponentRef(target.getPath(), target.getName(), target.getVersionNumber().getAsString(), this.getVersionComparator(), this.getOnlyCallCompatible(), this.getInstallPath(), false);
        return this.getInstalledTarget(icr, this.getDeclaredTypeOfRef(ref, caller), this.getHost(), ctx, caller, installDBContext);
    }

    public void validate(Caller container) throws PlanDBException {
        this.resolveRef(container);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, NAME_ATTR, this.getTopLevelRefName());
        Comparator comp = this.getVersionComparator();
        if (!DEFAULT_COMPARATOR.equals(comp)) {
            XMLUtil.addAttributeIfNotNull(outXML, VERSION_OP_ATTR, comp.toString());
        }
        XMLUtil.addAttribute(outXML, ONLY_COMPAT_ATTR, this.getOnlyCallCompatible(), false);
        XMLUtil.addAttributeIfNotNull(outXML, INSTALL_PATH_ATTR, this.getInstallPath());
        XMLUtil.addAttributeIfNotNull(outXML, HOST_ATTR, this.getHost());
    }

    public Object generate(ConfigGenerator generator) throws ConfigGenException {
        TopLevelRefTargeter copy = (TopLevelRefTargeter)this.clone();
        copy.setHost(generator.generate(copy.getHost()));
        copy.setInstallPath(generator.generate(copy.getInstallPath()));
        return copy;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TopLevelRefTargeter)) {
            return false;
        }
        TopLevelRefTargeter targeter = (TopLevelRefTargeter)other;
        return ObjectUtil.equals(this.getTopLevelRefName(), targeter.getTopLevelRefName()) && ObjectUtil.equals(this.getHost(), targeter.getHost()) && ObjectUtil.equals(this.getInstallPath(), targeter.getInstallPath()) && ObjectUtil.equals(this.getVersionComparator(), targeter.getVersionComparator()) && this.getOnlyCallCompatible() == targeter.getOnlyCallCompatible();
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getHost());
        v.visitToken(this.getInstallPath());
    }

    ComponentTargeterBase accept(PlanDBTransformer t) throws Exception {
        TopLevelRefTargeter result = (TopLevelRefTargeter)super.accept(t);
        result.setHost(t.transformToken(this.getHost()));
        result.setInstallPath(t.transformToken(this.getInstallPath()));
        return result;
    }
}

